/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MacTest
implements Test {
    static byte[] input1;
    static byte[] input2;
    static byte[] ivBytes;
    static byte[] keyBytes;
    static byte[] output1;
    static byte[] output2;
    static byte[] output3;
    static byte[] output4;
    static byte[] output5;
    static byte[] output6;

    static {
        keyBytes = Hex.decode("0123456789abcdef");
        ivBytes = Hex.decode("1234567890abcdef");
        input1 = Hex.decode("37363534333231204e6f77206973207468652074696d6520666f7220");
        output1 = Hex.decode("f1d30f68");
        output2 = Hex.decode("58d2e77e");
        output3 = Hex.decode("cd647403");
        input2 = Hex.decode("3736353433323120");
        output4 = Hex.decode("3af549c9");
        output5 = Hex.decode("188fbdd5");
        output6 = Hex.decode("7045eecd");
    }

    private boolean arraysEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] args) {
        MacTest test = new MacTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        Mac mac = new CBCBlockCipherMac(cipher);
        mac.init(key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output1)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(out)));
        }
        ParametersWithIV param = new ParametersWithIV(key, ivBytes);
        mac.init(param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output2)) + " got " + new String(Hex.encode(out)));
        }
        param = new ParametersWithIV(key, ivBytes);
        mac = new CFBBlockCipherMac(cipher);
        mac.init(param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output3)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output3)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output4)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output4)) + " got " + new String(Hex.encode(out)));
        }
        mac = new CBCBlockCipherMac((BlockCipher)cipher, new PKCS7Padding());
        mac.init(key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output5)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output5)) + " got " + new String(Hex.encode(out)));
        }
        mac.reset();
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output6)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.arraysEqual(out, output6)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(output6)) + " got " + new String(Hex.encode(out)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

