/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class DSATest
implements Test {
    SecureRandom keyRandom;
    BigInteger pValue;
    BigInteger qValue;
    SecureRandom random = new SecureRandom(){
        boolean first = true;

        public void nextBytes(byte[] bytes) {
            byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
            byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
            if (this.first) {
                System.arraycopy(k1, 0, bytes, 0, k1.length);
                this.first = false;
            } else {
                System.arraycopy(k2, 0, bytes, 0, k2.length);
            }
        }
    };

    public DSATest() {
        this.keyRandom = new SecureRandom(){

            public void nextBytes(byte[] bytes) {
                byte[] k = Hex.decode("b5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
                int i = 0;
                while (i < bytes.length - k.length) {
                    System.arraycopy(k, 0, bytes, i, k.length);
                    i += k.length;
                }
                if (i > bytes.length) {
                    System.arraycopy(k, 0, bytes, i - k.length, bytes.length - (i - k.length));
                } else {
                    System.arraycopy(k, 0, bytes, i, bytes.length - i);
                }
            }
        };
        this.pValue = new BigInteger("8df2a494492276aa3d25759bb06869cbeac0d83afb8d0cf7cbb8324f0d7882e5d0762fc5b7210eafc2e9adac32ab7aac49693dfbf83724c2ec0736ee31c80291", 16);
        this.qValue = new BigInteger("c773218c737ec8ee993b4f2ded30f48edace915f", 16);
    }

    public String getName() {
        return "DSA";
    }

    public static void main(String[] args) {
        DSATest test = new DSATest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        BigInteger r = new BigInteger("68076202252361894315274692543577577550894681403");
        BigInteger s = new BigInteger("1089214853334067536215539335472893651470583479365");
        DSAParametersGenerator pGen = new DSAParametersGenerator();
        pGen.init(512, 80, this.random);
        DSAParameters params = pGen.generateParameters();
        DSAValidationParameters pValid = params.getValidationParameters();
        if (pValid.getCounter() != 105) {
            return new SimpleTestResult(false, this.getName() + ": Counter wrong");
        }
        if (!this.pValue.equals(params.getP()) || !this.qValue.equals(params.getQ())) {
            return new SimpleTestResult(false, this.getName() + ": p or q wrong");
        }
        DSAKeyPairGenerator dsaKeyGen = new DSAKeyPairGenerator();
        DSAKeyGenerationParameters genParam = new DSAKeyGenerationParameters(this.keyRandom, params);
        dsaKeyGen.init(genParam);
        AsymmetricCipherKeyPair pair = dsaKeyGen.generateKeyPair();
        ParametersWithRandom param = new ParametersWithRandom(pair.getPrivate(), this.keyRandom);
        DSASigner dsa = new DSASigner();
        dsa.init(true, param);
        byte[] message = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
        BigInteger[] sig = dsa.generateSignature(message);
        if (!r.equals(sig[0])) {
            return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + r + System.getProperty("line.separator") + " got      : " + sig[0]);
        }
        if (!s.equals(sig[1])) {
            return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + s + System.getProperty("line.separator") + " got      : " + sig[1]);
        }
        dsa.init(false, pair.getPublic());
        if (dsa.verifySignature(message, sig[0], sig[1])) {
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        return new SimpleTestResult(false, this.getName() + ": verification fails");
    }
}

