/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BlockCipherMonteCarloTest
implements Test {
    BlockCipher engine;
    int id;
    byte[] input;
    int iterations;
    byte[] output;
    CipherParameters param;

    public BlockCipherMonteCarloTest(int id, int iterations, BlockCipher engine, CipherParameters param, String input, String output) {
        this.id = id;
        this.iterations = iterations;
        this.engine = engine;
        this.param = param;
        this.input = Hex.decode(input);
        this.output = Hex.decode(output);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    private boolean isEqualArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TestResult perform() {
        BufferedBlockCipher cipher = new BufferedBlockCipher(this.engine);
        cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        System.arraycopy(this.input, 0, out, 0, out.length);
        int i = 0;
        while (i != this.iterations) {
            int len1 = cipher.processBytes(out, 0, out.length, out, 0);
            try {
                cipher.doFinal(out, len1);
            }
            catch (CryptoException e) {
                return new SimpleTestResult(false, this.getName() + ": failed - exception " + e.toString());
            }
            ++i;
        }
        if (!this.isEqualArray(out, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
        }
        cipher.init(false, this.param);
        int i2 = 0;
        while (i2 != this.iterations) {
            int len1 = cipher.processBytes(out, 0, out.length, out, 0);
            try {
                cipher.doFinal(out, len1);
            }
            catch (CryptoException e) {
                return new SimpleTestResult(false, this.getName() + ": failed reversal - exception " + e.toString());
            }
            ++i2;
        }
        if (!this.isEqualArray(this.input, out)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal");
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }
}

