/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Extension;

public class X509Extensions
extends ASN1Encodable {
    public static final DERObjectIdentifier AuthorityInfoAccess;
    public static final DERObjectIdentifier AuthorityKeyIdentifier;
    public static final DERObjectIdentifier BasicConstraints;
    public static final DERObjectIdentifier CRLDistributionPoints;
    public static final DERObjectIdentifier CRLNumber;
    public static final DERObjectIdentifier CertificateIssuer;
    public static final DERObjectIdentifier CertificatePolicies;
    public static final DERObjectIdentifier DeltaCRLIndicator;
    public static final DERObjectIdentifier ExtendedKeyUsage;
    public static final DERObjectIdentifier InhibitAnyPolicy;
    public static final DERObjectIdentifier InstructionCode;
    public static final DERObjectIdentifier InvalidityDate;
    public static final DERObjectIdentifier IssuerAlternativeName;
    public static final DERObjectIdentifier IssuingDistributionPoint;
    public static final DERObjectIdentifier KeyUsage;
    public static final DERObjectIdentifier NameConstraints;
    public static final DERObjectIdentifier PolicyConstraints;
    public static final DERObjectIdentifier PolicyMappings;
    public static final DERObjectIdentifier PrivateKeyUsagePeriod;
    public static final DERObjectIdentifier ReasonCode;
    public static final DERObjectIdentifier SubjectAlternativeName;
    public static final DERObjectIdentifier SubjectKeyIdentifier;
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    static {
        SubjectKeyIdentifier = new DERObjectIdentifier("2.5.29.14");
        KeyUsage = new DERObjectIdentifier("2.5.29.15");
        PrivateKeyUsagePeriod = new DERObjectIdentifier("2.5.29.16");
        SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
        IssuerAlternativeName = new DERObjectIdentifier("2.5.29.18");
        BasicConstraints = new DERObjectIdentifier("2.5.29.19");
        CRLNumber = new DERObjectIdentifier("2.5.29.20");
        ReasonCode = new DERObjectIdentifier("2.5.29.21");
        InstructionCode = new DERObjectIdentifier("2.5.29.23");
        InvalidityDate = new DERObjectIdentifier("2.5.29.24");
        DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
        IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
        CertificateIssuer = new DERObjectIdentifier("2.5.29.29");
        NameConstraints = new DERObjectIdentifier("2.5.29.30");
        CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
        CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
        PolicyMappings = new DERObjectIdentifier("2.5.29.33");
        AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
        PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
        ExtendedKeyUsage = new DERObjectIdentifier("2.5.29.37");
        InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
        AuthorityInfoAccess = new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
    }

    public X509Extensions(Vector objectIDs, Vector values) {
        Enumeration e = objectIDs.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        int count = 0;
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)values.elementAt(count);
            this.extensions.put(oid, ext);
            ++count;
        }
    }

    public X509Extensions(Vector ordering, Hashtable extensions) {
        Enumeration<Object> e = ordering == null ? extensions.keys() : ordering.elements();
        while (e.hasMoreElements()) {
            this.ordering.addElement(e.nextElement());
        }
        e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)extensions.get(oid);
            this.extensions.put(oid, ext);
        }
    }

    public X509Extensions(Hashtable extensions) {
        this(null, extensions);
    }

    public X509Extensions(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            if (s.size() == 3) {
                this.extensions.put(s.getObjectAt(0), new X509Extension((DERBoolean)s.getObjectAt(1), (ASN1OctetString)s.getObjectAt(2)));
            } else {
                this.extensions.put(s.getObjectAt(0), new X509Extension(false, (ASN1OctetString)s.getObjectAt(1)));
            }
            this.ordering.addElement(s.getObjectAt(0));
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof X509Extensions)) {
            return false;
        }
        X509Extensions other = (X509Extensions)o;
        Enumeration e1 = this.extensions.keys();
        Enumeration e2 = other.extensions.keys();
        while (e1.hasMoreElements() && e2.hasMoreElements()) {
            Object o2;
            Object o1 = e1.nextElement();
            if (o1.equals(o2 = e2.nextElement())) continue;
            return false;
        }
        return !e1.hasMoreElements() && !e2.hasMoreElements();
    }

    public X509Extension getExtension(DERObjectIdentifier oid) {
        return (X509Extension)this.extensions.get(oid);
    }

    public static X509Extensions getInstance(Object obj) {
        if (obj == null || obj instanceof X509Extensions) {
            return (X509Extensions)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Extensions((ASN1Sequence)obj);
        }
        if (obj instanceof ASN1TaggedObject) {
            return X509Extensions.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static X509Extensions getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Extensions.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public int hashCode() {
        Enumeration e = this.extensions.keys();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            hashCode ^= o.hashCode();
            hashCode ^= this.extensions.get(o).hashCode();
        }
        return hashCode;
    }

    public Enumeration oids() {
        return this.ordering.elements();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        Enumeration e = this.ordering.elements();
        while (e.hasMoreElements()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
            X509Extension ext = (X509Extension)this.extensions.get(oid);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(oid);
            if (ext.isCritical()) {
                v.add(new DERBoolean(true));
            }
            v.add(ext.getValue());
            vec.add(new DERSequence(v));
        }
        return new DERSequence(vec);
    }
}

