/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.ReasonFlags;

public class DistributionPoint
extends ASN1Encodable {
    GeneralNames cRLIssuer;
    DistributionPointName distributionPoint;
    ReasonFlags reasons;

    public DistributionPoint(DistributionPointName distributionPoint, ReasonFlags reasons, GeneralNames cRLIssuer) {
        this.distributionPoint = distributionPoint;
        this.reasons = reasons;
        this.cRLIssuer = cRLIssuer;
    }

    public DistributionPoint(ASN1Sequence seq) {
        int i = 0;
        while (i != seq.size()) {
            ASN1TaggedObject t = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (t.getTagNo()) {
                case 0: {
                    this.distributionPoint = DistributionPointName.getInstance(t, true);
                    break;
                }
                case 1: {
                    this.reasons = new ReasonFlags(DERBitString.getInstance(t, false));
                    break;
                }
                case 2: {
                    this.cRLIssuer = GeneralNames.getInstance(t, false);
                }
            }
            ++i;
        }
    }

    public GeneralNames getCRLIssuer() {
        return this.cRLIssuer;
    }

    public DistributionPointName getDistributionPoint() {
        return this.distributionPoint;
    }

    public static DistributionPoint getInstance(Object obj) {
        if (obj == null || obj instanceof DistributionPoint) {
            return (DistributionPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new DistributionPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid DistributionPoint: " + obj.getClass().getName());
    }

    public static DistributionPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DistributionPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.distributionPoint != null) {
            v.add(new DERTaggedObject(0, this.distributionPoint));
        }
        if (this.reasons != null) {
            v.add(new DERTaggedObject(false, 1, this.reasons));
        }
        if (this.cRLIssuer != null) {
            v.add(new DERTaggedObject(false, 2, this.cRLIssuer));
        }
        return new DERSequence(v);
    }
}

