/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class X9Test
implements Test {
    private byte[] expPriv;
    private byte[] expPub;
    private byte[] namedPriv;
    private byte[] namedPub = Base64.decode("MBowEwYHKoZIzj0CAQYIKoZIzj0DAQEDAwACAQ==");

    public X9Test() {
        this.expPub = Base64.decode("MIHcMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEDAwACAQ==");
        this.namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
        this.expPriv = Base64.decode("MIHkAgEAMIHUBgcqhkjOPQIBMIHIAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVEECDAGAgEBBAEU");
    }

    private TestResult encodePrivateKey() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters params = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(ecP.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)))).getDERObject();
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKeyStructure(BigInteger.valueOf(10L)).getDERObject());
        if (!this.isSameAs(info.getEncoded(), this.namedPriv)) {
            return new SimpleTestResult(false, this.getName() + ": failed private named generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.namedPriv));
        DERObject o = aIn.readObject();
        if (!info.equals(o)) {
            return new SimpleTestResult(false, this.getName() + ": failed private named equality");
        }
        params = new X962Parameters(ecP);
        info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKeyStructure(BigInteger.valueOf(20L)).toASN1Object());
        if (!this.isSameAs(info.getEncoded(), this.expPriv)) {
            return new SimpleTestResult(false, this.getName() + ": failed private explicit generation");
        }
        aIn = new ASN1InputStream(new ByteArrayInputStream(this.expPriv));
        o = aIn.readObject();
        if (!info.equals(o)) {
            return new SimpleTestResult(false, this.getName() + ": failed private explicit equality");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private TestResult encodePublicKey() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X962Parameters params = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(ecP.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)))).getDERObject();
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        if (!this.isSameAs(info.getEncoded(), this.namedPub)) {
            return new SimpleTestResult(false, this.getName() + ": failed public named generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.namedPub));
        DERObject o = aIn.readObject();
        if (!info.equals(o)) {
            return new SimpleTestResult(false, this.getName() + ": failed public named equality");
        }
        params = new X962Parameters(ecP);
        info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        if (!this.isSameAs(info.getEncoded(), this.expPub)) {
            return new SimpleTestResult(false, this.getName() + ": failed public explicit generation");
        }
        aIn = new ASN1InputStream(new ByteArrayInputStream(this.expPub));
        o = aIn.readObject();
        if (!info.equals(o)) {
            return new SimpleTestResult(false, this.getName() + ": failed public explicit equality");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "X9";
    }

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        X9Test test = new X9Test();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        try {
            TestResult res = this.encodePublicKey();
            if (!res.isSuccessful()) {
                return res;
            }
            return this.encodePrivateKey();
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed - exception " + e.toString(), e);
        }
    }
}

