/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GenerationTest
implements Test {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v2CertList;
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");

    public GenerationTest() {
        this.v2CertList = Base64.decode("MIIBRQIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAkMCICAQEXDTcwMDEwMTAwMDAwMVowDjAMBgNVHRUEBQoDAIAAoIHFMIHCMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMEMGA1UdEgQ8MDqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAzMAoGA1UdFAQDAgEBMAwGA1UdHAEB/wQCMAA=");
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo info, X509Name name, int sNumber) {
        GeneralName genName = new GeneralName(name);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(genName);
        return new AuthorityKeyIdentifier(info, new GeneralNames(new DERSequence(v)), BigInteger.valueOf(sNumber));
    }

    public String getName() {
        return "Generation";
    }

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        GenerationTest test = new GenerationTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        TestResult res = this.tbsV1CertGen();
        if (!res.isSuccessful()) {
            return res;
        }
        res = this.tbsV3CertGen();
        if (!res.isSuccessful()) {
            return res;
        }
        return this.tbsV2CertListGen();
    }

    private TestResult tbsV1CertGen() {
        try {
            V1TBSCertificateGenerator gen = new V1TBSCertificateGenerator();
            Date startDate = new Date(1000L);
            Date endDate = new Date(12000L);
            gen.setSerialNumber(new DERInteger(1));
            gen.setStartDate(new Time(startDate));
            gen.setEndDate(new Time(endDate));
            gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            gen.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
            gen.setSubjectPublicKeyInfo(info);
            TBSCertificateStructure tbs = gen.generateTBSCertificate();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(tbs);
            if (!this.isSameAs(bOut.toByteArray(), this.v1Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert generation");
            }
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject o = aIn.readObject();
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(o);
            if (!this.isSameAs(bOut.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": v1 cert list failed " + e.toString(), e);
        }
    }

    private TestResult tbsV2CertListGen() {
        try {
            V2TBSCertListGenerator gen = new V2TBSCertListGenerator();
            gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            gen.addCRLEntry(new DERInteger(1), new Time(new Date(1000L)), 32768);
            gen.setNextUpdate(new Time(new Date(2000L)));
            gen.setThisUpdate(new Time(new Date(500L)));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, new DERNull()));
            Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            order.addElement(X509Extensions.AuthorityKeyIdentifier);
            order.addElement(X509Extensions.IssuerAlternativeName);
            order.addElement(X509Extensions.CRLNumber);
            order.addElement(X509Extensions.IssuingDistributionPoint);
            extensions.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(info, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            extensions.put(X509Extensions.IssuerAlternativeName, new X509Extension(false, (ASN1OctetString)new DEROctetString(new GeneralNames(new DERSequence(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 3")))))));
            extensions.put(X509Extensions.CRLNumber, new X509Extension(false, (ASN1OctetString)new DEROctetString(new DERInteger(1))));
            extensions.put(X509Extensions.IssuingDistributionPoint, new X509Extension(true, (ASN1OctetString)new DEROctetString(new IssuingDistributionPoint(new DERSequence()))));
            X509Extensions ex = new X509Extensions(order, extensions);
            gen.setExtensions(ex);
            TBSCertList tbs = gen.generateTBSCertList();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(tbs);
            if (!this.isSameAs(bOut.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list generation");
            }
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject o = aIn.readObject();
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(o);
            if (!this.isSameAs(bOut.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": v2 cert list failed " + e.toString(), e);
        }
    }

    private TestResult tbsV3CertGen() {
        try {
            V3TBSCertificateGenerator gen = new V3TBSCertificateGenerator();
            Date startDate = new Date(1000L);
            Date endDate = new Date(2000L);
            gen.setSerialNumber(new DERInteger(2));
            gen.setStartDate(new Time(startDate));
            gen.setEndDate(new Time(endDate));
            gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            gen.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            gen.setSubjectPublicKeyInfo(info);
            Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
            order.addElement(X509Extensions.AuthorityKeyIdentifier);
            order.addElement(X509Extensions.SubjectKeyIdentifier);
            order.addElement(X509Extensions.KeyUsage);
            extensions.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(info, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            extensions.put(X509Extensions.SubjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(info))));
            extensions.put(X509Extensions.KeyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString(new KeyUsage(16))));
            X509Extensions ex = new X509Extensions(order, extensions);
            gen.setExtensions(ex);
            TBSCertificateStructure tbs = gen.generateTBSCertificate();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(tbs);
            if (!this.isSameAs(bOut.toByteArray(), this.v3Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert generation");
            }
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject o = aIn.readObject();
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(o);
            if (!this.isSameAs(bOut.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": v3 cert list failed " + e.toString(), e);
        }
    }
}

