/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class PKIFreeText
extends ASN1Encodable {
    ASN1Sequence strings;

    public PKIFreeText(DERUTF8String p) {
        this.strings = new DERSequence(p);
    }

    public PKIFreeText(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            if (e.nextElement() instanceof DERUTF8String) continue;
            throw new IllegalArgumentException("attempt to insert non UTF8 STRING into PKIFreeText");
        }
        this.strings = seq;
    }

    public static PKIFreeText getInstance(Object obj) {
        if (obj instanceof PKIFreeText) {
            return (PKIFreeText)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIFreeText((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory");
    }

    public static PKIFreeText getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIFreeText.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DERUTF8String getStringAt(int i) {
        return (DERUTF8String)this.strings.getObjectAt(i);
    }

    public int size() {
        return this.strings.size();
    }

    public DERObject toASN1Object() {
        return this.strings;
    }
}

