/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERBoolean
extends DERObject {
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);
    byte value;

    public DERBoolean(boolean value) {
        this.value = (byte)(value ? -1 : 0);
    }

    public DERBoolean(byte[] value) {
        this.value = value[0];
    }

    void encode(DEROutputStream out) throws IOException {
        byte[] bytes = new byte[]{this.value};
        out.writeEncoded(1, bytes);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)o).value;
    }

    public static DERBoolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERBoolean.getInstance(obj.getObject());
    }

    public static DERBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(Object obj) {
        if (obj == null || obj instanceof DERBoolean) {
            return (DERBoolean)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERBoolean(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERBoolean.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public int hashCode() {
        return this.value;
    }

    public boolean isTrue() {
        return this.value != 0;
    }
}

