/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class TrendySliderUI
extends BasicSliderUI {
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    boolean thumbIsPressed = false;
    MouseListener thumbPressedListener;

    public TrendySliderUI(JSlider jslider) {
        super(jslider);
    }

    protected void installDefaults() {
        super.installDefaults(this.slider);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public static ComponentUI createUI(JComponent jcomponent) {
        return new TrendySliderUI((JSlider)jcomponent);
    }

    public void paintThumb(Graphics g) {
        g.translate(this.thumbRect.x, this.thumbRect.y);
        this._$13138(g);
        g.translate(-this.thumbRect.x, -this.thumbRect.y);
    }

    public void paintTrack(Graphics g) {
        if (this.slider.getOrientation() == 0) {
            int trackTop = (int)this.trackRect.getY() + 2;
            int w = this.slider.getWidth();
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawRect(2, trackTop, w - 6, 6);
            if (this.slider.isEnabled()) {
                g.setColor(new ColorUIResource(220, 220, 220));
                g.drawLine(3, trackTop + 1, w - 5, trackTop + 1);
                g.setColor(new ColorUIResource(230, 230, 230));
                g.drawLine(3, trackTop + 2, w - 5, trackTop + 2);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.drawLine(3, trackTop + 3, w - 5, trackTop + 3);
                g.setColor(new ColorUIResource(245, 245, 245));
                g.drawLine(3, trackTop + 4, w - 5, trackTop + 4);
                g.setColor(new ColorUIResource(250, 250, 250));
                g.drawLine(3, trackTop + 5, w - 5, trackTop + 5);
            } else {
                g.setColor(new ColorUIResource(240, 240, 240));
                g.drawLine(3, trackTop + 1, w - 5, trackTop + 1);
                g.drawLine(3, trackTop + 2, w - 5, trackTop + 2);
                g.drawLine(3, trackTop + 3, w - 5, trackTop + 3);
                g.drawLine(3, trackTop + 4, w - 5, trackTop + 4);
                g.drawLine(3, trackTop + 5, w - 5, trackTop + 5);
            }
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(2, trackTop, 3, trackTop);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(2, trackTop + 6, 3, trackTop + 6);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(2, trackTop + 1, 2, trackTop + 1);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(2, trackTop + 5, 2, trackTop + 5);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(w - 4, trackTop, w - 5, trackTop);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(w - 4, trackTop + 6, w - 5, trackTop + 6);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(w - 4, trackTop + 1, w - 4, trackTop + 1);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(w - 4, trackTop + 5, w - 4, trackTop + 5);
        } else {
            int trackLeft = (int)this.trackRect.getX() + 2;
            int h = this.slider.getHeight();
            g.setColor(new ColorUIResource(170, 170, 170));
            g.drawRect(trackLeft, 2, 6, h - 6);
            if (this.slider.isEnabled()) {
                g.setColor(new ColorUIResource(220, 220, 220));
                g.drawLine(trackLeft + 1, 3, trackLeft + 1, h - 5);
                g.setColor(new ColorUIResource(230, 230, 230));
                g.drawLine(trackLeft + 2, 3, trackLeft + 2, h - 5);
                g.setColor(new ColorUIResource(240, 240, 240));
                g.drawLine(trackLeft + 3, 3, trackLeft + 3, h - 5);
                g.setColor(new ColorUIResource(245, 245, 245));
                g.drawLine(trackLeft + 4, 3, trackLeft + 4, h - 5);
                g.setColor(new ColorUIResource(250, 250, 250));
                g.drawLine(trackLeft + 5, 3, trackLeft + 5, h - 5);
            } else {
                g.setColor(new ColorUIResource(240, 240, 240));
                g.drawLine(trackLeft + 1, 3, trackLeft + 1, h - 5);
                g.drawLine(trackLeft + 2, 3, trackLeft + 2, h - 5);
                g.drawLine(trackLeft + 3, 3, trackLeft + 3, h - 5);
                g.drawLine(trackLeft + 4, 3, trackLeft + 4, h - 5);
                g.drawLine(trackLeft + 5, 3, trackLeft + 5, h - 5);
            }
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(trackLeft, 2, trackLeft, 3);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(trackLeft + 6, 2, trackLeft + 6, 3);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(trackLeft + 1, 2, trackLeft + 1, 2);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(trackLeft + 5, 2, trackLeft + 5, 2);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(trackLeft, h - 4, trackLeft, h - 5);
            g.setColor(new ColorUIResource(210, 210, 210));
            g.drawLine(trackLeft + 6, h - 4, trackLeft + 6, h - 5);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(trackLeft + 1, h - 4, trackLeft + 1, h - 4);
            g.setColor(new ColorUIResource(190, 190, 190));
            g.drawLine(trackLeft + 5, h - 4, trackLeft + 5, h - 4);
        }
    }

    public void paintFocus(Graphics g) {
    }

    private void _$13138(Graphics g) {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.isEnabled()) {
                if (this.thumbIsPressed) {
                    int difY = 15;
                    g.setColor(new ColorUIResource(97, 142, 226));
                    g.drawLine(9, difY - 1, 14, difY - 6);
                    g.drawLine(6, difY - 1, 1, difY - 6);
                    g.setColor(new ColorUIResource(224, 231, 246));
                    g.drawLine(10, difY - 1, 15, difY - 6);
                    g.drawLine(5, difY - 1, 0, difY - 6);
                    g.setColor(new ColorUIResource(70, 120, 213));
                    g.drawLine(1, difY - 7, 1, difY - 14);
                    g.drawLine(14, difY - 7, 14, difY - 14);
                    g.setColor(new ColorUIResource(180, 200, 235));
                    g.drawLine(0, difY - 7, 0, difY - 13);
                    g.drawLine(15, difY - 7, 15, difY - 13);
                    g.setColor(new ColorUIResource(225, 232, 245));
                    g.drawLine(0, difY - 14, 1, difY - 15);
                    g.drawLine(14, difY - 15, 15, difY - 14);
                    g.setColor(new ColorUIResource(220, 230, 250));
                    g.drawLine(7, difY, 8, difY);
                    g.setColor(new ColorUIResource(108, 150, 228));
                    g.drawLine(7, difY - 1, 8, difY - 1);
                    g.setColor(new ColorUIResource(148, 188, 253));
                    g.drawLine(6, difY - 2, 9, difY - 2);
                    g.setColor(new ColorUIResource(158, 195, 253));
                    g.drawLine(5, difY - 3, 10, difY - 3);
                    g.setColor(new ColorUIResource(172, 203, 253));
                    g.drawLine(4, difY - 4, 11, difY - 4);
                    g.setColor(new ColorUIResource(186, 212, 254));
                    g.drawLine(3, difY - 5, 12, difY - 5);
                    g.setColor(new ColorUIResource(200, 220, 254));
                    g.drawLine(2, difY - 6, 13, difY - 6);
                    g.setColor(new ColorUIResource(215, 230, 254));
                    g.drawLine(2, difY - 7, 13, difY - 7);
                    g.setColor(new ColorUIResource(228, 238, 255));
                    g.drawLine(2, difY - 8, 13, difY - 8);
                    g.setColor(new ColorUIResource(228, 238, 255));
                    g.drawLine(2, difY - 9, 13, difY - 9);
                    g.setColor(new ColorUIResource(215, 230, 254));
                    g.drawLine(2, difY - 10, 13, difY - 10);
                    g.setColor(new ColorUIResource(200, 220, 254));
                    g.drawLine(2, difY - 11, 13, difY - 11);
                    g.setColor(new ColorUIResource(186, 212, 254));
                    g.drawLine(2, difY - 12, 13, difY - 12);
                    g.setColor(new ColorUIResource(172, 203, 253));
                    g.drawLine(2, difY - 13, 13, difY - 13);
                    g.setColor(new ColorUIResource(160, 195, 253));
                    g.drawLine(2, difY - 14, 13, difY - 14);
                    g.setColor(new ColorUIResource(108, 150, 228));
                    g.drawLine(2, difY - 15, 13, difY - 15);
                } else {
                    int difY = 15;
                    g.setColor(new ColorUIResource(97, 142, 226));
                    g.drawLine(9, difY - 1, 14, difY - 6);
                    g.drawLine(6, difY - 1, 1, difY - 6);
                    g.setColor(new ColorUIResource(224, 231, 246));
                    g.drawLine(10, difY - 1, 15, difY - 6);
                    g.drawLine(5, difY - 1, 0, difY - 6);
                    g.setColor(new ColorUIResource(70, 120, 213));
                    g.drawLine(1, difY - 7, 1, difY - 14);
                    g.drawLine(14, difY - 7, 14, difY - 14);
                    g.setColor(new ColorUIResource(180, 200, 235));
                    g.drawLine(0, difY - 7, 0, difY - 13);
                    g.drawLine(15, difY - 7, 15, difY - 13);
                    g.setColor(new ColorUIResource(225, 232, 245));
                    g.drawLine(0, difY - 14, 1, difY - 15);
                    g.drawLine(14, difY - 15, 15, difY - 14);
                    g.setColor(new ColorUIResource(220, 230, 250));
                    g.drawLine(7, difY, 8, difY);
                    g.setColor(new ColorUIResource(108, 150, 228));
                    g.drawLine(7, difY - 1, 8, difY - 1);
                    g.setColor(new ColorUIResource(254, 255, 255));
                    g.drawLine(6, difY - 2, 9, difY - 2);
                    g.setColor(new ColorUIResource(242, 247, 255));
                    g.drawLine(5, difY - 3, 10, difY - 3);
                    g.setColor(new ColorUIResource(228, 238, 255));
                    g.drawLine(4, difY - 4, 11, difY - 4);
                    g.setColor(new ColorUIResource(215, 230, 254));
                    g.drawLine(3, difY - 5, 12, difY - 5);
                    g.setColor(new ColorUIResource(200, 220, 254));
                    g.drawLine(2, difY - 6, 13, difY - 6);
                    g.setColor(new ColorUIResource(186, 212, 254));
                    g.drawLine(2, difY - 7, 13, difY - 7);
                    g.setColor(new ColorUIResource(172, 203, 253));
                    g.drawLine(2, difY - 8, 13, difY - 8);
                    g.setColor(new ColorUIResource(158, 195, 253));
                    g.drawLine(2, difY - 9, 13, difY - 9);
                    g.setColor(new ColorUIResource(148, 188, 253));
                    g.drawLine(2, difY - 10, 13, difY - 10);
                    g.setColor(new ColorUIResource(161, 196, 253));
                    g.drawLine(2, difY - 11, 13, difY - 11);
                    g.setColor(new ColorUIResource(174, 205, 254));
                    g.drawLine(2, difY - 12, 13, difY - 12);
                    g.setColor(new ColorUIResource(188, 213, 254));
                    g.drawLine(2, difY - 13, 13, difY - 13);
                    g.setColor(new ColorUIResource(208, 223, 249));
                    g.drawLine(2, difY - 14, 13, difY - 14);
                    g.setColor(new ColorUIResource(108, 150, 228));
                    g.drawLine(2, difY - 15, 13, difY - 15);
                }
            }
        } else if (this.slider.isEnabled()) {
            if (this.thumbIsPressed) {
                int difX = 15;
                g.setColor(new ColorUIResource(97, 142, 226));
                g.drawLine(difX - 1, 9, difX - 6, 14);
                g.drawLine(difX - 1, 6, difX - 6, 1);
                g.setColor(new ColorUIResource(224, 231, 246));
                g.drawLine(difX - 1, 10, difX - 6, 15);
                g.drawLine(difX - 1, 5, difX - 6, 0);
                g.setColor(new ColorUIResource(70, 120, 213));
                g.drawLine(difX - 7, 1, difX - 14, 1);
                g.drawLine(difX - 7, 14, difX - 14, 14);
                g.setColor(new ColorUIResource(180, 200, 235));
                g.drawLine(difX - 7, 0, difX - 13, 0);
                g.drawLine(difX - 7, 15, difX - 13, 15);
                g.setColor(new ColorUIResource(225, 232, 245));
                g.drawLine(difX - 14, 0, difX - 15, 1);
                g.drawLine(difX - 15, 14, difX - 14, 15);
                g.setColor(new ColorUIResource(220, 230, 250));
                g.drawLine(difX, 7, difX, 8);
                g.setColor(new ColorUIResource(108, 150, 228));
                g.drawLine(difX - 1, 7, difX - 1, 8);
                g.setColor(new ColorUIResource(148, 188, 253));
                g.drawLine(difX - 2, 6, difX - 2, 9);
                g.setColor(new ColorUIResource(158, 195, 253));
                g.drawLine(difX - 3, 5, difX - 3, 10);
                g.setColor(new ColorUIResource(172, 203, 253));
                g.drawLine(difX - 4, 4, difX - 4, 11);
                g.setColor(new ColorUIResource(186, 212, 254));
                g.drawLine(difX - 5, 3, difX - 5, 12);
                g.setColor(new ColorUIResource(200, 220, 254));
                g.drawLine(difX - 6, 2, difX - 6, 13);
                g.setColor(new ColorUIResource(215, 230, 254));
                g.drawLine(difX - 7, 2, difX - 7, 13);
                g.setColor(new ColorUIResource(228, 238, 255));
                g.drawLine(difX - 8, 2, difX - 8, 13);
                g.setColor(new ColorUIResource(228, 238, 255));
                g.drawLine(difX - 9, 2, difX - 9, 13);
                g.setColor(new ColorUIResource(215, 230, 254));
                g.drawLine(difX - 10, 2, difX - 10, 13);
                g.setColor(new ColorUIResource(200, 220, 254));
                g.drawLine(difX - 11, 2, difX - 11, 13);
                g.setColor(new ColorUIResource(186, 212, 254));
                g.drawLine(difX - 12, 2, difX - 12, 13);
                g.setColor(new ColorUIResource(172, 203, 253));
                g.drawLine(difX - 13, 2, difX - 13, 13);
                g.setColor(new ColorUIResource(160, 195, 253));
                g.drawLine(difX - 14, 2, difX - 14, 13);
                g.setColor(new ColorUIResource(108, 150, 228));
                g.drawLine(difX - 15, 2, difX - 15, 13);
            } else {
                int difX = 15;
                g.setColor(new ColorUIResource(97, 142, 226));
                g.drawLine(difX - 1, 9, difX - 6, 14);
                g.drawLine(difX - 1, 6, difX - 6, 1);
                g.setColor(new ColorUIResource(224, 231, 246));
                g.drawLine(difX - 1, 10, difX - 6, 15);
                g.drawLine(difX - 1, 5, difX - 6, 0);
                g.setColor(new ColorUIResource(70, 120, 213));
                g.drawLine(difX - 7, 1, difX - 14, 1);
                g.drawLine(difX - 7, 14, difX - 14, 14);
                g.setColor(new ColorUIResource(180, 200, 235));
                g.drawLine(difX - 7, 0, difX - 13, 0);
                g.drawLine(difX - 7, 15, difX - 13, 15);
                g.setColor(new ColorUIResource(225, 232, 245));
                g.drawLine(difX - 14, 0, difX - 15, 1);
                g.drawLine(difX - 15, 14, difX - 14, 15);
                g.setColor(new ColorUIResource(220, 230, 250));
                g.drawLine(difX, 7, difX, 8);
                g.setColor(new ColorUIResource(108, 150, 228));
                g.drawLine(difX - 1, 7, difX - 1, 8);
                g.setColor(new ColorUIResource(254, 255, 255));
                g.drawLine(difX - 2, 6, difX - 2, 9);
                g.setColor(new ColorUIResource(242, 247, 255));
                g.drawLine(difX - 3, 5, difX - 3, 10);
                g.setColor(new ColorUIResource(228, 238, 255));
                g.drawLine(difX - 4, 4, difX - 4, 11);
                g.setColor(new ColorUIResource(215, 230, 254));
                g.drawLine(difX - 5, 3, difX - 5, 12);
                g.setColor(new ColorUIResource(200, 220, 254));
                g.drawLine(difX - 6, 2, difX - 6, 13);
                g.setColor(new ColorUIResource(186, 212, 254));
                g.drawLine(difX - 7, 2, difX - 7, 13);
                g.setColor(new ColorUIResource(172, 203, 253));
                g.drawLine(difX - 8, 2, difX - 8, 13);
                g.setColor(new ColorUIResource(158, 195, 253));
                g.drawLine(difX - 9, 2, difX - 9, 13);
                g.setColor(new ColorUIResource(148, 188, 253));
                g.drawLine(difX - 10, 2, difX - 10, 13);
                g.setColor(new ColorUIResource(161, 196, 253));
                g.drawLine(difX - 11, 2, difX - 11, 13);
                g.setColor(new ColorUIResource(174, 205, 254));
                g.drawLine(difX - 12, 2, difX - 12, 13);
                g.setColor(new ColorUIResource(188, 213, 254));
                g.drawLine(difX - 13, 2, difX - 13, 13);
                g.setColor(new ColorUIResource(208, 223, 249));
                g.drawLine(difX - 14, 2, difX - 14, 13);
                g.setColor(new ColorUIResource(108, 150, 228));
                g.drawLine(difX - 15, 2, difX - 15, 13);
            }
        }
    }

    protected void calculateThumbSize() {
        Dimension size = new Dimension(16, 16);
        this.thumbRect.setSize(size.width, size.height);
    }

    Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    JSlider getSlider() {
        return this.slider;
    }

    protected MouseListener createThumbPressedListener() {
        return new ThumbListener();
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.thumbPressedListener = this.createThumbPressedListener();
        if (this.thumbPressedListener != null) {
            slider.addMouseListener(this.thumbPressedListener);
        }
    }

    protected void uninstallListeners(JSlider slider) {
        if (this.thumbPressedListener != null) {
            slider.removeMouseListener(this.thumbPressedListener);
            this.thumbPressedListener = null;
        }
        super.uninstallListeners(slider);
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        if (this.slider.isEnabled()) {
            g.setColor((Color)UIManager.get("Slider.minorColor"));
        } else {
            g.setColor((Color)UIManager.get("Slider.minorDisabledColor"));
        }
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        if (this.slider.isEnabled()) {
            g.setColor((Color)UIManager.get("Slider.majorColor"));
        } else {
            g.setColor((Color)UIManager.get("Slider.majorDisabledColor"));
        }
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        if (this.slider.isEnabled()) {
            g.setColor((Color)UIManager.get("Slider.minorColor"));
        } else {
            g.setColor((Color)UIManager.get("Slider.minorDisabledColor"));
        }
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        if (this.slider.isEnabled()) {
            g.setColor((Color)UIManager.get("Slider.majorColor"));
        } else {
            g.setColor((Color)UIManager.get("Slider.majorDisabledColor"));
        }
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    class ThumbListener
    extends MouseAdapter {
        ThumbListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (TrendySliderUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                TrendySliderUI.this.thumbIsPressed = true;
                TrendySliderUI.this.getSlider().repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            TrendySliderUI.this.thumbIsPressed = false;
            TrendySliderUI.this.getSlider().repaint();
        }
    }
}

