/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.ID3v2FormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ID3v2ExtendedHeader
implements Serializable {
    private final int CRC_SIZE = 5;
    private final int EXT_HEAD_LOCATION = 10;
    private final int[] MAX_TAG_FRAMES_TABLE = new int[]{128, 64, 32, 32};
    private final int[] MAX_TAG_SIZE_TABLE = new int[]{8000000, 1024000, 320000, 32000};
    private final int[] MAX_TEXT_SIZE_TABLE = new int[]{-1, 1024, 128, 30};
    private final int MIN_SIZE = 6;
    private byte[] crc;
    private boolean crced;
    private boolean imageEncode;
    private int imageRestrict;
    private int maxFrames;
    private int maxTagSize;
    private int maxTextSize;
    private File mp3 = null;
    private int numFlagBytes;
    private int size;
    private boolean textEncode;
    private boolean update;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ID3v2ExtendedHeader(File mp3) throws FileNotFoundException, IOException, ID3v2FormatException {
        this.mp3 = mp3;
        this.size = 0;
        this.numFlagBytes = 0;
        this.update = false;
        this.crced = false;
        this.crc = new byte[5];
        this.maxFrames = -1;
        this.maxTagSize = -1;
        this.textEncode = false;
        this.maxTextSize = -1;
        this.imageEncode = false;
        this.imageRestrict = -1;
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(mp3, "r");
            this.readExtendedHeader(in);
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.size];
        int bytesCopied = 0;
        System.arraycopy(BinaryParser.convertToSynchsafeBytes(this.size), 0, b, bytesCopied, 4);
        bytesCopied += 4;
        b[bytesCopied++] = (byte)this.numFlagBytes;
        System.arraycopy(this.getFlagBytes(), 0, b, bytesCopied, this.numFlagBytes);
        bytesCopied += this.numFlagBytes;
        return b;
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public boolean getCRCed() {
        return this.crced;
    }

    private byte[] getFlagBytes() {
        byte[] b = new byte[this.numFlagBytes];
        int bytesCopied = 1;
        b[0] = 0;
        if (this.update) {
            b[0] = BinaryParser.setBit(b[0], 7);
            b[bytesCopied++] = 0;
        }
        if (this.crced) {
            b[0] = BinaryParser.setBit(b[0], 6);
            b[bytesCopied++] = (byte)this.crc.length;
            System.arraycopy(this.crc, 0, b, bytesCopied, this.crc.length);
            bytesCopied += this.crc.length;
        }
        if (this.maxTagSize != -1 || this.textEncode || this.maxTextSize != -1 || this.imageEncode || this.imageRestrict != -1) {
            b[0] = BinaryParser.setBit(b[0], 5);
            b[bytesCopied++] = 1;
            byte restrict = 0;
            if (this.maxTagSize != -1) {
                if (BinaryParser.bitSet((byte)this.maxTagSize, 0)) {
                    restrict = BinaryParser.setBit(restrict, 6);
                }
                if (BinaryParser.bitSet((byte)this.maxTagSize, 1)) {
                    restrict = BinaryParser.setBit(restrict, 7);
                }
            }
            if (this.textEncode) {
                restrict = BinaryParser.setBit(restrict, 5);
            }
            if (this.maxTextSize != -1) {
                if (BinaryParser.bitSet((byte)this.maxTextSize, 0)) {
                    restrict = BinaryParser.setBit(restrict, 3);
                }
                if (BinaryParser.bitSet((byte)this.maxTextSize, 1)) {
                    restrict = BinaryParser.setBit(restrict, 4);
                }
            }
            if (this.imageEncode) {
                restrict = BinaryParser.setBit(restrict, 2);
            }
            if (this.imageRestrict != -1) {
                if (BinaryParser.bitSet((byte)this.imageRestrict, 0)) {
                    restrict = BinaryParser.setBit(restrict, 0);
                }
                if (BinaryParser.bitSet((byte)this.imageRestrict, 1)) {
                    restrict = BinaryParser.setBit(restrict, 1);
                }
            }
            b[bytesCopied++] = restrict;
        }
        return b;
    }

    public boolean getImageEncode() {
        return this.imageEncode;
    }

    public int getImageRestriction() {
        return this.imageRestrict;
    }

    public int getMaxFrames() {
        int retval = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < this.MAX_TAG_FRAMES_TABLE.length) {
            retval = this.MAX_TAG_FRAMES_TABLE[this.maxTagSize];
        }
        return retval;
    }

    public int getMaxTagSize() {
        int retval = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < this.MAX_TAG_SIZE_TABLE.length) {
            retval = this.MAX_TAG_SIZE_TABLE[this.maxTagSize];
        }
        return retval;
    }

    public int getMaxTextSize() {
        int retval = -1;
        if (this.maxTextSize >= 0 && this.maxTextSize < this.MAX_TEXT_SIZE_TABLE.length) {
            retval = this.MAX_TEXT_SIZE_TABLE[this.maxTextSize];
        }
        return retval;
    }

    public int getNumFlagBytes() {
        return this.numFlagBytes;
    }

    public int getSize() {
        return this.size;
    }

    public boolean getTextEncode() {
        return this.textEncode;
    }

    public boolean getUpdate() {
        return this.update;
    }

    private void parseFlags(byte[] flags) throws ID3v2FormatException {
        int bytesRead = 1;
        if (BinaryParser.bitSet(flags[0], 6)) {
            this.update = true;
            ++bytesRead;
        }
        if (BinaryParser.bitSet(flags[0], 5)) {
            this.crced = true;
            ++bytesRead;
            int i = 0;
            while (i < this.crc.length) {
                this.crc[i] = flags[bytesRead++];
                ++i;
            }
        }
        if (BinaryParser.bitSet(flags[0], 4)) {
            this.maxTagSize = BinaryParser.convertToDecimal(flags[++bytesRead], 6, 7);
            this.textEncode = BinaryParser.bitSet(flags[bytesRead], 5);
            this.maxTextSize = BinaryParser.convertToDecimal(flags[bytesRead], 3, 4);
            this.imageEncode = BinaryParser.bitSet(flags[bytesRead], 2);
            this.imageRestrict = BinaryParser.convertToDecimal(flags[bytesRead], 0, 1);
            ++bytesRead;
        }
        if (bytesRead != this.numFlagBytes) {
            throw new ID3v2FormatException("The number of found flag bytes in the extended header is not equal to the number specified in the extended header.");
        }
    }

    private void readExtendedHeader(RandomAccessFile raf) throws FileNotFoundException, IOException, ID3v2FormatException {
        raf.seek(10L);
        byte[] buf = new byte[4];
        if (raf.read(buf) != buf.length) {
            throw new IOException("Error reading extended header:size");
        }
        this.size = BinaryParser.convertToSynchsafeInt(buf);
        if (this.size < 6) {
            throw new ID3v2FormatException("The extended header size data is less than the minimum required size.");
        }
        buf = new byte[1];
        if (raf.read(buf) != buf.length) {
            throw new IOException("Error reading extended header:numflags");
        }
        this.numFlagBytes = buf[0];
        buf = new byte[this.numFlagBytes + 1];
        if (raf.read(buf) != buf.length) {
            throw new IOException("Error reading extended header:flags");
        }
        this.parseFlags(buf);
    }

    public String toString() {
        return "ExtendedSize:\t\t\t" + this.getSize() + " bytes" + "\nNumFlagBytes:\t\t\t" + this.getNumFlagBytes() + "\nUpdated:\t\t\t" + this.getUpdate() + "\nCRC:\t\t\t\t" + this.getCRCed() + "\nMaxFrames:\t\t\t" + this.getMaxFrames() + "\nMaxTagSize:\t\t\t" + this.getMaxTagSize() + "\nTextEncoded:\t\t\t" + this.getTextEncode() + "\nMaxTextSize:\t\t\t" + this.getMaxTextSize() + "\nImageEncoded:\t\t\t" + this.getImageEncode() + "\nImageRestriction:\t\t" + this.getImageRestriction();
    }
}

