/*
 * Decompiled with CFR 0.152.
 */
package j51.atmel;

import j51.atmel.AT89C51RD2Constants;
import j51.intel.CallListener;
import j51.intel.FlashCode;
import j51.intel.MCS51;
import j51.intel.SfrWriteListener;
import j51.intel.Timer;
import j51.intel.Timer2;
import j51.util.Hex;

public class AT89C51RD2
extends MCS51
implements AT89C51RD2Constants,
SfrWriteListener,
CallListener {
    public AT89C51RD2() throws Exception {
        this.setXdataSize(2048);
        this.setCode(new FlashCode("P89C51RD2", 65536));
        this.addPeripheral(new Timer());
        this.addPeripheral(new Timer2());
        this.addSfrWriteListener(162, this);
        this.setCallListener(65520, this);
        this.setSfrName(192, "P4");
        this.setSfrName(232, "P5");
        this.setSfrName(162, "AUXR1");
    }

    @Override
    public void call(MCS51 mCS51, int n) throws Exception {
        switch (this.r(1)) {
            case 9: {
                int n2 = this.getDptr(0);
                int n3 = this.getDptr(1);
                for (int i = 0; i < this.acc(); ++i) {
                    this.code(n2 + i, this.xdata(n3 + i));
                }
                this.acc(0);
                break;
            }
            default: {
                throw new Exception("API R1 " + this.r(1) + " A = " + this.acc() + " DPTR0 = " + Hex.bin2word(this.getDptr(0)) + " DPTR1 = " + Hex.bin2word(this.getDptr(1)));
            }
        }
    }

    @Override
    public void sfrWrite(int n, int n2) {
        switch (n) {
            case 162: {
                this.sfr(162, n2 &= 0xFD);
                this.swapDptr(n2 & 1);
            }
        }
    }
}

