/*
 * Decompiled with CFR 0.152.
 */
package j51;

import j51.J51Panel;
import j51.JAssembly;
import j51.JCode;
import j51.JIdata;
import j51.JInfo;
import j51.JPeripheral;
import j51.JRegister;
import j51.JSfr;
import j51.JXdata;
import j51.SortedLong;
import j51.Worker;
import j51.intel.InterruptStatistic;
import j51.intel.MCS51;
import j51.intel.MCS51Performance;
import j51.swing.JFactory;
import j51.swing.JFixedField;
import j51.util.Hex;
import j51.util.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class J51
extends JFrame
implements MCS51Performance,
ActionListener {
    private static Logger log = Logger.getLogger(J51.class);
    private static J51 instance = null;
    private J51Panel peripheral;
    private JRegister register;
    private JAssembly assembly;
    private JSfr sfr;
    private JIdata idata;
    private JXdata xdata;
    private JCode code;
    private JInfo info;
    private JFixedField messages;
    private JToolBar toolBar = new JToolBar();
    private MCS51 cpu;
    private JFileChooser fc = null;
    private JButton buttonStop;
    private AbstractAction actionDebugTrace;
    private AbstractAction actionDebugStep;
    private AbstractAction actionDebugGo;
    private AbstractAction actionDebugStop;
    private AbstractAction actionDebugReset;
    private AbstractAction actionDebugErase;
    private AbstractAction actionToolsProfile;
    private AbstractAction actionToolsStatistics;
    private AbstractAction actionToolsInterrupt;
    private JMenu menuCpu;
    private AbstractAction actionFileLoad;
    private AbstractAction actionFileExit;
    private int minCpuUsage;
    private int maxCpuUsage;
    private int avgCpuUsage;
    private int cpuTime;
    private Thread thread;
    private JRadioButtonMenuItem first = null;
    private Vector panels = new Vector();

    J51() {
        this.setTitle("J51 1.05 $Revision: 70 $ - Created by mario@viara.eu");
        this.pack();
        this.setVisible(true);
        this.info = new JInfo();
        this.register = new JRegister();
        this.assembly = new JAssembly();
        this.sfr = new JSfr();
        this.idata = new JIdata();
        this.xdata = new JXdata();
        this.code = new JCode();
        this.peripheral = new JPeripheral();
        this.messages = new JFixedField(64);
        JFactory.setTitle(this.messages, "Messages");
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.createMenuBar();
        this.register.setChangeListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.toolBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.info, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.register, gridBagConstraints);
        ++gridBagConstraints.gridx;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Assembler", this.assembly);
        jTabbedPane.add("SFR", this.sfr);
        jTabbedPane.add("IDATA", this.idata);
        jTabbedPane.add("XDATA", this.xdata);
        jTabbedPane.add("CODE", this.code);
        jPanel.add((Component)jTabbedPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.messages, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.peripheral, gridBagConstraints);
        this.setContentPane(jPanel);
        this.panels.add(this.info);
        this.panels.add(this.assembly);
        this.panels.add(this.sfr);
        this.panels.add(this.idata);
        this.panels.add(this.xdata);
        this.panels.add(this.code);
        this.panels.add(this.register);
        this.panels.add(this.peripheral);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.first.doClick();
        instance = this;
    }

    public static J51 getInstance() {
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PC")) {
            this.assembly.update(false);
        }
        if (string.equals("SFR")) {
            this.sfr.update(false);
        }
    }

    public void setCpu(String string) {
        final String string2 = string;
        Worker worker = new Worker(this, "Setup simulator", "Loading"){

            @Override
            public void process() {
                try {
                    J51Panel j51Panel;
                    int n;
                    Class<?> clazz = Class.forName(string2);
                    this.setProgress("Loading class");
                    MCS51 mCS51 = (MCS51)clazz.newInstance();
                    ((J51)J51.this).info.reset.setValue(0);
                    J51.this.cpu = mCS51;
                    this.setProgress("Reset cpu");
                    J51.this.reset();
                    for (n = 0; n < J51.this.panels.size(); ++n) {
                        j51Panel = (J51Panel)J51.this.panels.elementAt(n);
                        this.setProgress("Initialize  " + j51Panel.getTitle());
                        j51Panel.setCpu(J51.this.cpu);
                    }
                    J51.this.cpu.addPerformanceListener(J51.this);
                    if (J51.this.isVisible()) {
                        J51.this.invalidate();
                        J51.this.pack();
                    }
                    for (n = 0; n < J51.this.panels.size(); ++n) {
                        j51Panel = (J51Panel)J51.this.panels.elementAt(n);
                        this.setProgress("Update  " + j51Panel.getTitle());
                        j51Panel.update(true);
                    }
                    this.setProgress("Stop simulation");
                    J51.this.emulation(false);
                    J51.this.messages(J51.this.cpu.toString());
                    this.setProgress("Garbage collection");
                    System.gc();
                }
                catch (Exception exception) {
                    J51.this.messages(exception);
                    exception.printStackTrace(System.out);
                }
            }
        };
        worker.start();
    }

    private void erase() {
        for (int i = 0; i < this.cpu.getCodeSize(); ++i) {
            this.cpu.code(i, 255);
        }
    }

    private void reset() {
        this.cpu.reset();
        try {
            this.cpu.pc(this.info.reset.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.minCpuUsage = 100;
        this.maxCpuUsage = 0;
        this.cpuTime = 0;
        this.avgCpuUsage = 0;
    }

    public void setCpu(MCS51 mCS51) {
        this.info.reset.setValue(0);
        this.cpu = mCS51;
        System.out.println("Reset");
        this.reset();
        for (int i = 0; i < this.panels.size(); ++i) {
            System.out.println("SetCpu" + this.panels.elementAt(i));
            ((J51Panel)this.panels.elementAt(i)).setCpu(mCS51);
        }
        mCS51.addPerformanceListener(this);
        if (this.isVisible()) {
            this.invalidate();
            this.pack();
        }
        System.out.println("Update Panel");
        this.updatePanel(true);
        this.emulation(false);
        this.messages(mCS51.toString());
    }

    void addKey(JMenuItem jMenuItem, char c) {
        jMenuItem.setMnemonic(c);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)c, 8));
    }

    public void messages(Throwable throwable) {
        String string;
        if (!(throwable instanceof InterruptedException)) {
            throwable.printStackTrace();
        }
        if ((string = throwable.getMessage()) == null) {
            string = throwable.toString();
        }
        this.messages(string);
    }

    private void messages(String string) {
        new UpdateMessage(string);
    }

    private void emulation(boolean bl) {
        if (this.cpu != null) {
            this.cpu.setEmulation(bl);
        }
        this.menuCpu.setEnabled(!bl);
        this.actionDebugErase.setEnabled(!bl);
        this.actionDebugStop.setEnabled(bl);
        this.actionDebugReset.setEnabled(!bl);
        this.actionDebugGo.setEnabled(!bl);
        this.actionDebugTrace.setEnabled(!bl);
        this.actionDebugStep.setEnabled(!bl);
        this.actionFileLoad.setEnabled(!bl);
        this.actionFileExit.setEnabled(!bl);
        this.actionToolsStatistics.setEnabled(!bl);
        this.actionToolsProfile.setEnabled(!bl);
        this.actionToolsInterrupt.setEnabled(!bl);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((J51Panel)this.panels.elementAt(i)).setEmulation(bl);
        }
        this.updatePanel(false);
    }

    private void createMenuCpuLine(JMenu jMenu, ButtonGroup buttonGroup, String string) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, false);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.setCpu(actionEvent.getActionCommand());
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        if (this.first == null) {
            this.first = jRadioButtonMenuItem;
        }
    }

    public Icon getIcon(String string) {
        log.finer("Loading " + string);
        URL uRL = J51.class.getResource("images/" + string);
        if (uRL == null) {
            log.info("ImageFactory.getImageIcon - not found: " + string);
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    void addIcon(JMenu jMenu, String string) {
        jMenu.setIcon(this.getIcon(string));
    }

    void addIcon(Action action, String string) {
        Icon icon = this.getIcon(string);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    JMenu createMenuCpu() {
        this.menuCpu = new JMenu("Cpu", true);
        this.addIcon(this.menuCpu, "cpu.gif");
        ButtonGroup buttonGroup = new ButtonGroup();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("j51.conf"));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#") || string.length() < 3) continue;
                this.createMenuCpuLine(this.menuCpu, buttonGroup, string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.menuCpu.getMenuComponentCount() == 0) {
            this.createMenuCpuLine(this.menuCpu, buttonGroup, "j51.intel.P8051");
        }
        return this.menuCpu;
    }

    JMenu createMenuLaf() {
        JMenu jMenu = new JMenu("Look & Feel", true);
        this.addIcon(jMenu, "laf.gif");
        ButtonGroup buttonGroup = new ButtonGroup();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            boolean bl = false;
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName(), bl);
            final String string = lookAndFeelInfoArray[i].getClassName();
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        UIManager.setLookAndFeel(string);
                    }
                    catch (Exception exception) {
                        J51.this.messages(exception);
                    }
                    SwingUtilities.updateComponentTreeUI(J51.this);
                    J51.this.pack();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        jMenu.setMnemonic('K');
        return jMenu;
    }

    JButton addToBar(JToolBar jToolBar, Action action) {
        JButton jButton = jToolBar.add(action);
        String string = (String)action.getValue("Name");
        if (string != null) {
            jButton.setToolTipText(string);
        }
        return jButton;
    }

    void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createMenuFile());
        jMenuBar.add(this.createMenuCpu());
        jMenuBar.add(this.createMenuTools());
        jMenuBar.add(this.createMenuDebug());
        jMenuBar.add(this.createMenuLaf());
        this.setJMenuBar(jMenuBar);
        this.emulation(false);
        this.toolBar = new JToolBar();
        this.addToBar(this.toolBar, this.actionDebugGo);
        this.addToBar(this.toolBar, this.actionDebugTrace);
        this.addToBar(this.toolBar, this.actionDebugStep);
        this.buttonStop = this.addToBar(this.toolBar, this.actionDebugStop);
        this.addToBar(this.toolBar, this.actionDebugReset);
        this.addToBar(this.toolBar, this.actionDebugErase);
        this.addToBar(this.toolBar, this.actionFileLoad);
    }

    @Override
    public void cpuPerformance(int n, int n2) {
        this.avgCpuUsage = (n + this.avgCpuUsage) / 2;
        this.cpuTime += n2;
        if (this.cpuTime > 0) {
            if (n < this.minCpuUsage) {
                this.minCpuUsage = n;
            }
            if (n > this.maxCpuUsage) {
                this.maxCpuUsage = n;
            }
            this.messages("CPU Usage " + n + "%, min " + this.minCpuUsage + "%, max " + this.maxCpuUsage + "%, avg " + this.avgCpuUsage + "%, run " + this.cpuTime / 1000 + " sec.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    J51.this.info.updateClock();
                }
            });
        }
    }

    private void load(String string) throws Exception {
        int n;
        int n2;
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n3 = 65536;
        int n4 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n5;
            if (!string2.startsWith(":")) {
                throw new Exception(string + " is not a valid intel file");
            }
            n2 = Hex.getByte(string2, 1);
            n = Hex.getWord(string2, 3);
            int n6 = Hex.getByte(string2, 7);
            int n7 = n2 + n / 256 + n + n6;
            for (n5 = 0; n5 < n2 + 1; ++n5) {
                n7 += Hex.getByte(string2, 9 + n5 * 2);
            }
            if ((n7 &= 0xFF) != 0) {
                throw new Exception("Invalid chksum " + Hex.bin2byte(n7) + " in " + string2);
            }
            if (n6 == 1) break;
            if (n6 == 3) continue;
            if (n6 != 0) {
                throw new Exception("Unsupported record type " + n6);
            }
            if (n < n3) {
                n3 = n;
            }
            if (n + n2 - 1 > n4) {
                n4 = n + n2 - 1;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                this.cpu.code(n + n5, Hex.getByte(string2, 9 + n5 * 2));
            }
        }
        this.messages(" loaded at " + Hex.bin2word(n3) + "-" + Hex.bin2word(n4));
        bufferedReader.close();
        n2 = string.indexOf(46);
        if (n2 != -1) {
            string = string.substring(0, n2) + ".map";
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!(string2 = string2.trim()).startsWith("0C:")) continue;
                n = Hex.getWord(string2, 3);
                String string3 = string2.substring(7);
                string3 = string3.trim();
                this.cpu.setCodeName(n, string3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JMenu createMenuFile() {
        this.actionFileLoad = new AbstractAction("Load"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (J51.this.fc == null) {
                        J51.this.fc = new JFileChooser();
                        J51.this.fc.setCurrentDirectory(new File("."));
                    }
                    int n = J51.this.fc.showOpenDialog(J51.this);
                    J51.this.fc;
                    if (n == 0) {
                        J51.this.load(J51.this.fc.getSelectedFile().getCanonicalPath());
                        J51.this.updatePanel(true);
                    }
                }
                catch (Throwable throwable) {
                    J51.this.messages(throwable);
                }
            }
        };
        this.addIcon(this.actionFileLoad, "load.gif");
        this.actionFileExit = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
        this.addIcon(this.actionFileExit, "exit.gif");
        JMenu jMenu = new JMenu("File");
        this.addIcon(jMenu, "file.gif");
        this.addKey(jMenu.add(this.actionFileLoad), 'L');
        this.addKey(jMenu.add(this.actionFileExit), 'X');
        jMenu.setMnemonic('F');
        return jMenu;
    }

    void performTree(String string, JTree jTree) {
        class MyRenderer
        extends DefaultTreeCellRenderer {
            MyRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Font font = this.getFont();
                if (font != null) {
                    font = new Font("Monospaced", font.getStyle(), font.getSize());
                    this.setFont(font);
                }
                return this;
            }
        }
        jTree.setCellRenderer(new MyRenderer());
        Dimension dimension = this.getPreferredSize();
        dimension.width = dimension.width * 2 / 3;
        dimension.height = dimension.height * 2 / 3;
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(dimension);
        JDialog jDialog = new JDialog(this, string, true);
        Point point = this.getLocation();
        point.x += dimension.width / 10;
        point.y += dimension.height / 10;
        jDialog.setLocation(point);
        jDialog.setContentPane(jScrollPane);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    void performInterrupt() {
        SortedLong sortedLong = new SortedLong();
        for (int i = 0; i < this.cpu.getInterruptCount(); ++i) {
            InterruptStatistic interruptStatistic = this.cpu.getInterruptAt(i);
            long l = interruptStatistic.getCounter();
            sortedLong.put(l, interruptStatistic.toString());
        }
        this.performTree("Interrupt", sortedLong.createTree());
    }

    void performProfile() {
        SortedLong sortedLong = new SortedLong();
        for (int i = 0; i < this.cpu.getCodeSize(); ++i) {
            long l = this.cpu.getExecutionCounter(i);
            if (l <= 0L) continue;
            sortedLong.put(l, this.cpu.getDecodeAt(i));
        }
        this.performTree("Profiling", sortedLong.createTree());
    }

    void performStatistics() {
        SortedLong sortedLong = new SortedLong();
        for (int i = 0; i < 256; ++i) {
            long l = this.cpu.getOpcodeCounter(i);
            if (l <= 0L) continue;
            sortedLong.put(l, this.cpu.getOpcodeDescription(i));
        }
        this.performTree("Statistics", sortedLong.createTree());
    }

    JMenu createMenuTools() {
        this.actionToolsProfile = new AbstractAction("Profile"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.performProfile();
            }
        };
        this.actionToolsStatistics = new AbstractAction("Statistics"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.performStatistics();
            }
        };
        this.actionToolsInterrupt = new AbstractAction("Interrupt"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.performInterrupt();
            }
        };
        JMenu jMenu = new JMenu("Tools");
        this.addIcon(jMenu, "tools.gif");
        this.addKey(jMenu.add(this.actionToolsProfile), 'P');
        jMenu.add(this.actionToolsInterrupt);
        this.addKey(jMenu.add(this.actionToolsStatistics), 'C');
        jMenu.setMnemonic('T');
        return jMenu;
    }

    JMenu createMenuDebug() {
        this.actionDebugErase = new AbstractAction("Erase"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.erase();
                J51.this.updatePanel(true);
            }
        };
        this.addIcon(this.actionDebugErase, "erase.gif");
        this.actionDebugReset = new AbstractAction("Reset"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.reset();
                J51.this.updatePanel(false);
            }
        };
        this.addIcon(this.actionDebugReset, "reset.gif");
        this.actionDebugStop = new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    J51.this.thread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.addIcon(this.actionDebugStop, "stop.gif");
        this.actionDebugTrace = new AbstractAction("Step into"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    J51.this.cpu.step();
                    J51.this.updatePanel(false);
                }
                catch (Exception exception) {
                    J51.this.messages(exception);
                }
            }
        };
        this.addIcon(this.actionDebugTrace, "stepinto.gif");
        this.actionDebugGo = new AbstractAction("Go"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        J51.this.messages("Simulating ....");
                        try {
                            J51.this.cpu.go(-1);
                        }
                        catch (Throwable throwable) {
                            J51.this.messages(throwable);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                J51.this.emulation(false);
                            }
                        });
                    }
                });
                J51.this.emulation(true);
                J51.this.thread.start();
            }
        };
        this.addIcon(this.actionDebugGo, "play.gif");
        this.actionDebugStep = new AbstractAction("Step over"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J51.this.thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        J51.this.messages("Emulating ....");
                        try {
                            J51.this.cpu.pass();
                        }
                        catch (Throwable throwable) {
                            J51.this.messages(throwable);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                J51.this.emulation(false);
                            }
                        });
                    }
                });
                J51.this.emulation(true);
                J51.this.thread.start();
            }
        };
        this.addIcon(this.actionDebugStep, "step.gif");
        JMenu jMenu = new JMenu("Debug");
        this.addIcon(jMenu, "debug.gif");
        this.addKey(jMenu.add(this.actionDebugTrace), 'I');
        this.addKey(jMenu.add(this.actionDebugStep), 'O');
        this.addKey(jMenu.add(this.actionDebugReset), 'R');
        this.addKey(jMenu.add(this.actionDebugGo), 'G');
        this.addKey(jMenu.add(this.actionDebugStop), 'S');
        this.addKey(jMenu.add(this.actionDebugErase), 'E');
        jMenu.setMnemonic('D');
        return jMenu;
    }

    public static void main(String[] stringArray) {
        try {
            J51 j51 = new J51();
            j51.updatePanel(true);
            j51.pack();
            j51.setVisible(true);
            j51.requestFocus();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void updatePanel(boolean bl) {
        if (this.cpu == null) {
            return;
        }
        for (int i = 0; i < this.panels.size(); ++i) {
            ((J51Panel)this.panels.elementAt(i)).update(bl);
        }
    }

    class UpdateMessage
    implements Runnable {
        private String msg;

        public UpdateMessage(String string) {
            this.msg = string;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            if (this.msg == null) {
                this.msg = "";
            }
            J51.this.messages.setText(this.msg);
        }
    }
}

