/*
 * Decompiled with CFR 0.152.
 */
package jef.video;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import jef.video.BitMap;

public abstract class GfxProducer
extends Applet
implements Runnable,
ImageProducer {
    int _width;
    int _height;
    int _realheight;
    Image _image;
    Thread _thread;
    ImageConsumer _consumer;
    DirectColorModel _model;
    Graphics _graphics;
    boolean zoomed = false;

    public Thread getThread() {
        return this._thread;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public boolean isZoomed() {
        return this.zoomed;
    }

    public synchronized void update(BitMap bitmap) {
        this.update(bitmap.getPixels());
    }

    public synchronized void update(int[] pixels) {
        if (this._consumer != null) {
            this._consumer.setPixels(0, 0, this._width, this._height, (ColorModel)this._model, pixels, 0, this._width);
            this._consumer.imageComplete(2);
        }
        if (this.zoomed) {
            this._graphics.drawImage(this._image, 0, 0, this._width * 2, this._height * 2, 0, 0, this._width, this._height, null);
        } else {
            this._graphics.drawImage(this._image, 0, 0, this._width, this._height, null);
        }
        this.postPaint(this._graphics);
    }

    public void start() {
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.start();
        }
    }

    public void run() {
        this.zoomed = false;
        try {
            this.zoomed = this.getParameter("ZOOM").equals("Yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String parStr = this.getParameter("REALHEIGHT");
            if (parStr != null) {
                this._realheight = Integer.parseInt(parStr);
            }
        }
        catch (Exception parStr) {
            // empty catch block
        }
        Dimension size = this.getSize();
        if (this.zoomed) {
            this._width = size.width / 2;
            this._height = this._realheight / 2;
        } else {
            this._width = size.width;
            this._height = size.height;
        }
        this._model = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
        this._image = Toolkit.getDefaultToolkit().createImage(this);
        this._graphics = this.getGraphics();
        this.main(this._width, this._height);
    }

    public void stop() {
        this._thread = null;
    }

    public void postPaint(Graphics g) {
    }

    public void update() {
        if (this._graphics != null) {
            this._graphics.setColor(Color.black);
            if (this.zoomed) {
                this._graphics.fillRect(0, 0, this._width * 2, this._height * 2);
            } else {
                this._graphics.fillRect(0, 0, this._width, this._height);
            }
            this.postPaint(this._graphics);
        }
    }

    public synchronized void addConsumer(ImageConsumer ic) {
        this._consumer = ic;
        this._consumer.setDimensions(this._width, this._height);
        this._consumer.setHints(30);
        this._consumer.setColorModel(this._model);
    }

    public synchronized boolean isConsumer(ImageConsumer ic) {
        return true;
    }

    public synchronized void removeConsumer(ImageConsumer ic) {
    }

    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void main(int width, int height) {
    }
}

