/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import jef.map.ReadHandler;

public class InputPort
implements ReadHandler {
    public static final int IP_ACTIVE_HIGH = 0;
    public static final int IP_ACTIVE_LOW = 255;
    public static final int IPT_UNKNOWN = 0;
    public static final int IPT_UNUSED = 0;
    public static final int IPT_COIN1 = 1;
    public static final int IPT_COIN2 = 2;
    public static final int IPT_COIN3 = 2;
    public static final int IPT_START1 = 3;
    public static final int IPT_START2 = 4;
    public static final int IPT_START3 = 4;
    public static final int IPT_JOYSTICK_LEFT = 5;
    public static final int IPT_JOYSTICK_RIGHT = 6;
    public static final int IPT_JOYSTICK_UP = 7;
    public static final int IPT_JOYSTICK_DOWN = 8;
    public static final int IPT_BUTTON1 = 9;
    public static final int IPT_BUTTON2 = 10;
    public static final int IPT_BUTTON3 = 11;
    public static final int IPT_BUTTON4 = 12;
    public static final int IPT_BUTTON5 = 13;
    public static final int IPT_BUTTON6 = 14;
    public static final int IPT_TILT = 15;
    public static final int IPF_2WAY = 0;
    public static final int IPF_4WAY = 0;
    public static final int IPF_8WAY = 0;
    public static final int IPF_COCKTAIL = 128;
    public static final int IPF_TOGGLE = 2048;
    public static final int IPF_PLAYER1 = 0;
    public static final int IPF_PLAYER2 = 128;
    public static final int IPF_PLAYER3 = 256;
    public static final int IPF_PLAYER4 = 384;
    public static final int IPT_PADDLE = 1;
    public static final int IPT_DIAL = 2;
    public static final int IPF_REVERSE = 256;
    public static final int IPT_AD_STICK_X = 3;
    public static final int IPT_AD_STICK_Y = 4;
    private int value = 0;
    private boolean analog = false;
    private boolean reverse = false;
    private int center = 127;
    private int type = 0;
    private int[] bit = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private int[] bitMask = new int[512];
    private int[] activityType = new int[512];
    private boolean[] impulse = new boolean[8];
    private int[] impulseActivityType = new int[8];
    private int[] impulseInputType = new int[8];
    private int[] impulseCounter = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
    private int[] impulseDelay = new int[8];

    public void keyPress(int keyCode) {
        switch (keyCode) {
            case 53: {
                this.value = this.activityType[1] == 0 ? this.value | 0xFF & this.bitMask[1] : this.value & ~this.bitMask[1];
                break;
            }
            case 54: {
                this.value = this.activityType[2] == 0 ? this.value | 0xFF & this.bitMask[1] : this.value & ~this.bitMask[1];
                break;
            }
            case 49: {
                this.value = this.activityType[3] == 0 ? this.value | 0xFF & this.bitMask[3] : this.value & ~this.bitMask[3];
                break;
            }
            case 50: {
                this.value = this.activityType[4] == 0 ? this.value | 0xFF & this.bitMask[4] : this.value & ~this.bitMask[4];
                break;
            }
            case 37: {
                if (!this.analog) {
                    this.value = this.activityType[5] == 0 ? this.value | 0xFF & this.bitMask[5] : this.value & ~this.bitMask[5];
                    break;
                }
                switch (this.type) {
                    case 1: 
                    case 3: {
                        this.value = this.reverse ? 255 : 0;
                    }
                }
                break;
            }
            case 68: {
                if (!this.analog) {
                    this.value = this.activityType[133] == 0 ? this.value | 0xFF & this.bitMask[133] : this.value & ~this.bitMask[133];
                    break;
                }
                switch (this.type) {
                    case 1: {
                        this.value = this.reverse ? 255 : 0;
                    }
                }
                break;
            }
            case 39: {
                if (!this.analog) {
                    this.value = this.activityType[6] == 0 ? this.value | 0xFF & this.bitMask[6] : this.value & ~this.bitMask[6];
                    break;
                }
                switch (this.type) {
                    case 1: 
                    case 3: {
                        this.value = this.reverse ? 0 : 255;
                    }
                }
                break;
            }
            case 71: {
                if (!this.analog) {
                    this.value = this.activityType[134] == 0 ? this.value | 0xFF & this.bitMask[134] : this.value & ~this.bitMask[134];
                    break;
                }
                switch (this.type) {
                    case 1: {
                        this.value = this.reverse ? 0 : 255;
                    }
                }
                break;
            }
            case 38: {
                if (!this.analog) {
                    this.value = this.activityType[7] == 0 ? this.value | 0xFF & this.bitMask[7] : this.value & ~this.bitMask[7];
                    break;
                }
                switch (this.type) {
                    case 1: 
                    case 4: {
                        this.value = this.reverse ? 255 : 0;
                    }
                }
                break;
            }
            case 82: {
                this.value = this.activityType[135] == 0 ? this.value | 0xFF & this.bitMask[135] : this.value & ~this.bitMask[135];
                break;
            }
            case 40: {
                if (!this.analog) {
                    this.value = this.activityType[8] == 0 ? this.value | 0xFF & this.bitMask[8] : this.value & ~this.bitMask[8];
                    break;
                }
                switch (this.type) {
                    case 1: 
                    case 4: {
                        this.value = this.reverse ? 0 : 255;
                    }
                }
                break;
            }
            case 70: {
                this.value = this.activityType[136] == 0 ? this.value | 0xFF & this.bitMask[136] : this.value & ~this.bitMask[136];
                break;
            }
            case 17: {
                this.value = this.activityType[9] == 0 ? this.value | 0xFF & this.bitMask[9] : this.value & ~this.bitMask[9];
                break;
            }
            case 65: {
                this.value = this.activityType[137] == 0 ? this.value | 0xFF & this.bitMask[137] : this.value & ~this.bitMask[137];
                break;
            }
            case 32: {
                this.value = this.activityType[10] == 0 ? this.value | 0xFF & this.bitMask[10] : this.value & ~this.bitMask[10];
                break;
            }
            case 83: {
                this.value = this.activityType[138] == 0 ? this.value | 0xFF & this.bitMask[138] : this.value & ~this.bitMask[138];
                break;
            }
            case 90: {
                this.value = this.activityType[11] == 0 ? this.value | 0xFF & this.bitMask[11] : this.value & ~this.bitMask[11];
                break;
            }
            case 81: {
                this.value = this.activityType[139] == 0 ? this.value | 0xFF & this.bitMask[139] : this.value & ~this.bitMask[139];
                break;
            }
            case 88: {
                this.value = this.activityType[12] == 0 ? this.value | 0xFF & this.bitMask[12] : this.value & ~this.bitMask[12];
                break;
            }
            case 87: {
                this.value = this.activityType[140] == 0 ? this.value | 0xFF & this.bitMask[140] : this.value & ~this.bitMask[140];
                break;
            }
            case 67: {
                this.value = this.activityType[13] == 0 ? this.value | 0xFF & this.bitMask[13] : this.value & ~this.bitMask[13];
                break;
            }
            case 86: {
                this.value = this.activityType[14] == 0 ? this.value | 0xFF & this.bitMask[14] : this.value & ~this.bitMask[14];
            }
        }
    }

    public void keyRelease(int keyCode) {
        switch (keyCode) {
            case 53: {
                this.value = this.activityType[1] == 255 ? this.value | 0xFF & this.bitMask[1] : this.value & ~this.bitMask[1];
                break;
            }
            case 54: {
                this.value = this.activityType[2] == 255 ? this.value | 0xFF & this.bitMask[1] : this.value & ~this.bitMask[1];
                break;
            }
            case 49: {
                this.value = this.activityType[3] == 255 ? this.value | 0xFF & this.bitMask[3] : this.value & ~this.bitMask[3];
                break;
            }
            case 50: {
                this.value = this.activityType[4] == 255 ? this.value | 0xFF & this.bitMask[4] : this.value & ~this.bitMask[4];
                break;
            }
            case 37: {
                if (!this.analog) {
                    this.value = this.activityType[5] == 255 ? this.value | 0xFF & this.bitMask[5] : this.value & ~this.bitMask[5];
                    break;
                }
                this.value = this.center;
                break;
            }
            case 68: {
                if (!this.analog) {
                    this.value = this.activityType[133] == 255 ? this.value | 0xFF & this.bitMask[133] : this.value & ~this.bitMask[133];
                    break;
                }
                switch (this.type) {
                    case 1: {
                        this.value = this.center;
                    }
                }
                break;
            }
            case 39: {
                if (!this.analog) {
                    this.value = this.activityType[6] == 255 ? this.value | 0xFF & this.bitMask[6] : this.value & ~this.bitMask[6];
                    break;
                }
                this.value = this.center;
                break;
            }
            case 71: {
                if (!this.analog) {
                    this.value = this.activityType[134] == 255 ? this.value | 0xFF & this.bitMask[134] : this.value & ~this.bitMask[134];
                    break;
                }
                switch (this.type) {
                    case 1: {
                        this.value = this.center;
                    }
                }
                break;
            }
            case 38: {
                if (!this.analog) {
                    this.value = this.activityType[7] == 255 ? this.value | 0xFF & this.bitMask[7] : this.value & ~this.bitMask[7];
                    break;
                }
                this.value = this.center;
                break;
            }
            case 82: {
                this.value = this.activityType[135] == 255 ? this.value | 0xFF & this.bitMask[135] : this.value & ~this.bitMask[135];
                break;
            }
            case 40: {
                if (!this.analog) {
                    this.value = this.activityType[8] == 255 ? this.value | 0xFF & this.bitMask[8] : this.value & ~this.bitMask[8];
                    break;
                }
                this.value = this.center;
                break;
            }
            case 70: {
                this.value = this.activityType[136] == 255 ? this.value | 0xFF & this.bitMask[136] : this.value & ~this.bitMask[136];
                break;
            }
            case 17: {
                this.value = this.activityType[9] == 255 ? this.value | 0xFF & this.bitMask[9] : this.value & ~this.bitMask[9];
                break;
            }
            case 65: {
                this.value = this.activityType[137] == 255 ? this.value | 0xFF & this.bitMask[137] : this.value & ~this.bitMask[137];
                break;
            }
            case 32: {
                this.value = this.activityType[10] == 255 ? this.value | 0xFF & this.bitMask[10] : this.value & ~this.bitMask[10];
                break;
            }
            case 83: {
                this.value = this.activityType[138] == 255 ? this.value | 0xFF & this.bitMask[138] : this.value & ~this.bitMask[138];
                break;
            }
            case 90: {
                this.value = this.activityType[11] == 255 ? this.value | 0xFF & this.bitMask[11] : this.value & ~this.bitMask[11];
                break;
            }
            case 81: {
                this.value = this.activityType[139] == 255 ? this.value | 0xFF & this.bitMask[139] : this.value & ~this.bitMask[139];
                break;
            }
            case 88: {
                this.value = this.activityType[12] == 255 ? this.value | 0xFF & this.bitMask[12] : this.value & ~this.bitMask[12];
                break;
            }
            case 87: {
                this.value = this.activityType[140] == 255 ? this.value | 0xFF & this.bitMask[140] : this.value & ~this.bitMask[140];
                break;
            }
            case 67: {
                this.value = this.activityType[13] == 255 ? this.value | 0xFF & this.bitMask[13] : this.value & ~this.bitMask[13];
                break;
            }
            case 86: {
                this.value = this.activityType[12] == 255 ? this.value | 0xFF & this.bitMask[14] : this.value & ~this.bitMask[14];
            }
        }
    }

    public int read(int port) {
        if (!this.analog) {
            return this.value;
        }
        return 0;
    }

    public void write(int data) {
        this.value = data;
    }

    public void setBit(int bitMask, int activityType, int inputType) {
        this.bitMask[inputType] = bitMask;
        this.activityType[inputType] = activityType;
        this.value = activityType == 255 ? this.value | 0xFF & bitMask : this.value & ~bitMask;
    }

    public void setBitImpulse(int bitMask, int activityType, int inputType, int frames) {
        this.bitMask[inputType] = bitMask;
        this.activityType[inputType] = activityType;
        this.impulseActivityType[this.bitSet((int)bitMask)] = activityType;
        this.impulse[this.bitSet((int)bitMask)] = true;
        this.impulseInputType[this.bitSet((int)bitMask)] = inputType;
        this.impulseDelay[this.bitSet((int)bitMask)] = frames;
        this.value = activityType == 255 ? this.value | 0xFF & bitMask : this.value & ~bitMask;
    }

    public void update() {
        int i = 0;
        while (i < 8) {
            if (this.impulse[i]) {
                if (this.impulseCounter[i] > 0) {
                    int n = i;
                    this.impulseCounter[n] = this.impulseCounter[n] - 1;
                } else {
                    int bitMask = 1 << i;
                    this.value = this.impulseActivityType[i] == 255 ? this.value & ~bitMask : this.value | 0xFF & bitMask;
                }
            }
            ++i;
        }
    }

    public void setDipName(int bitMask, int defSetting, String name) {
        this.value = this.value & ~bitMask | defSetting;
    }

    public void setDipSetting(int setting, String name) {
    }

    public void setService(int bitMask, int activityType) {
        this.value = activityType == 255 ? this.value | 0xFF & bitMask : this.value & ~bitMask;
    }

    public void setAnalog(int bitMask, int center, int type, int a, int b, int c, int d) {
        this.analog = true;
        this.type = type & 0x1F;
        this.reverse = (type & 0x100) != 0;
        this.center = this.value = center;
    }

    private int bitSet(int value) {
        int i = 0;
        while (i < 8) {
            if (this.bit[i] == value) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

