/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sunw.html.AttributeList;
import sunw.html.Attributes;
import sunw.html.ContentModel;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.Element;
import sunw.html.Entity;
import sunw.html.HTMLOutputWriter;
import sunw.html.Tag;
import sunw.html.TagStack;
import sunw.html.UnknownTag;

public class Parser
implements DTDConstants {
    static final byte[] notext = new byte[0];
    char[] text = new char[1024];
    int textpos;
    Tag last;
    boolean space;
    boolean verbose;
    HTMLOutputWriter out;
    char[] str = new char[128];
    int strpos;
    protected Properties props;
    protected DTD dtd;
    int ch;
    int ln;
    Reader in;
    Element recent;
    TagStack stack;
    boolean skipTag = false;
    private boolean ignoringInterrupts = false;
    private boolean seenHtml;
    private boolean seenHead;
    private boolean seenBody;
    private boolean ignoreFormEnd = false;
    private boolean formNeedsPlacing = false;
    protected boolean strict = true;
    private char[] buf = new char[256];
    private int pos;
    private int len;

    protected int getCurrentLine() {
        return this.ln;
    }

    protected Tag makeTag(Element element, Attributes attributes) {
        return new UnknownTag(element, attributes);
    }

    protected void handleText(char[] cArray) {
        try {
            if (this.verbose && this.out != null) {
                this.out.text(cArray);
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleTitle(char[] cArray) {
        this.handleText(cArray);
    }

    protected void handleComment(char[] cArray) {
        try {
            if (this.verbose && this.out != null) {
                this.out.comment(new String(cArray));
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleEOFInComment() {
        int n = this.strIndexOf('\n');
        if (n >= 0) {
            this.handleComment(this.getChars(0, n));
            try {
                this.in.close();
                this.in = new CharArrayReader(this.getChars(n + 1));
                this.ch = 62;
            }
            catch (IOException iOException) {
                this.error("ioexception");
            }
            this.resetStrBuffer();
            return;
        }
        this.error("eof.comment");
    }

    protected void handleEmptyTag(Tag tag) {
        try {
            if (this.verbose && this.out != null) {
                this.out.emptyTag(tag);
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleStartTag(Tag tag) {
        try {
            if (this.verbose && this.out != null) {
                this.out.startTag(tag);
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleFormTagInTable(Tag tag) {
        try {
            if (this.verbose && this.out != null) {
                this.out.startTag(tag);
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleEndTag(Tag tag) {
        try {
            if (this.verbose && this.out != null) {
                this.out.endTag(tag);
                return;
            }
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
    }

    protected void handleError(int n, String string) {
        System.out.println("**** " + this.stack);
        System.out.println("line " + n + ": error: " + string);
        System.out.println();
    }

    void handleText(Tag tag) {
        char[] cArray;
        if (tag.isBlock()) {
            this.space = false;
        }
        if (!(this.textpos != 0 || this.space && this.stack != null && !this.last.isBlock() && this.stack.advance(this.dtd.pcdata))) {
            this.last = tag;
            this.space = false;
            return;
        }
        if (this.space) {
            if (this.textpos + 1 > this.text.length) {
                cArray = new char[this.text.length + 200];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = 32;
            this.space = false;
        }
        cArray = new char[this.textpos];
        System.arraycopy(this.text, 0, cArray, 0, this.textpos);
        if (tag.getElement().getName().equals("title")) {
            this.handleTitle(cArray);
        } else {
            this.handleText(cArray);
        }
        this.textpos = 0;
        this.last = tag;
        this.space = false;
    }

    protected void error(String string, String string2, String string3, String string4) {
        this.handleError(this.ln, String.valueOf(string) + string2 + string3 + string4);
    }

    protected void error(String string, String string2, String string3) {
        this.error(string, string2, string3, "?");
    }

    protected void error(String string, String string2) {
        this.error(string, string2, "?", "?");
    }

    protected void error(String string) {
        this.error(string, "?", "?", "?");
    }

    protected Tag getEnclosingForm() {
        TagStack tagStack = this.stack;
        while (tagStack != null && !tagStack.elem.getName().equals("form")) {
            tagStack = tagStack.next;
        }
        if (tagStack != null) {
            return tagStack.tag;
        }
        return null;
    }

    protected void startTag(Tag tag) {
        Element element = tag.getElement();
        Attributes attributes = tag.getAttributes();
        if (!element.isEmpty() || this.textpos != 0) {
            this.handleText(tag);
        } else {
            this.last = tag;
        }
        AttributeList attributeList = element.atts;
        while (attributeList != null) {
            if (attributeList.modifier == 2 && (attributes == null || attributes.get(attributeList.name) == null)) {
                this.error("req.att", attributeList.getName(), element.getName());
            }
            attributeList = attributeList.next;
        }
        if (element.isEmpty()) {
            this.handleEmptyTag(tag);
            return;
        }
        this.recent = element;
        this.stack = new TagStack(tag, this.stack);
        this.handleStartTag(tag);
    }

    protected void endTag(boolean bl) {
        this.handleText(this.stack.tag);
        if (bl && !this.stack.elem.omitEnd()) {
            this.error("end.missing", this.stack.elem.getName());
        } else if (!this.stack.terminate()) {
            this.error("end.unexpected", this.stack.elem.getName());
        }
        this.handleEndTag(this.stack.tag);
        this.stack = this.stack.next;
        this.recent = this.stack != null ? this.stack.elem : null;
    }

    boolean ignoreElement(Element element) {
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (string2.equals("html") && this.seenHtml || string2.equals("head") && this.seenHead || string2.equals("body") && this.seenBody) {
            return true;
        }
        if (string2.equals("dt") || string2.equals("dd")) {
            TagStack tagStack = this.stack;
            while (tagStack != null && !tagStack.elem.getName().equals("dl")) {
                tagStack = tagStack.next;
            }
            if (tagStack == null) {
                return true;
            }
        }
        return string.equals("table") && !string2.equals("#pcdata") && !string2.equals("input") || string2.equals("font") && (string.equals("ul") || string.equals("ol")) || string2.equals("meta") && this.stack != null || string2.equals("style") || string.equals("table") && string2.equals("a");
    }

    protected void setTableSurroundedByForm(Tag tag) {
    }

    protected void incrementNumberFormsToEnd(Tag tag) {
    }

    protected void checkForSurroundedTable(Element element, Tag tag) {
    }

    protected void doNecessarySurroundedTableCleanup() {
    }

    protected void markFirstTime(Element element) {
        String string = element.getName();
        if (string.equals("html")) {
            this.seenHtml = true;
            return;
        }
        if (string.equals("head")) {
            this.seenHead = true;
            return;
        }
        if (string.equals("body")) {
            this.seenBody = true;
        }
    }

    boolean legalElementContext(Element element) {
        DTDConstants dTDConstants;
        if (this.stack == null) {
            if (element != this.dtd.html) {
                this.startTag(this.makeTag(this.dtd.html, null));
                return this.legalElementContext(element);
            }
            return true;
        }
        if (!this.strict && element.getName().equals("form")) {
            TagStack tagStack = this.stack;
            while (tagStack != null && !tagStack.elem.getName().equals("table")) {
                tagStack = tagStack.next;
            }
            if (tagStack != null) {
                this.setTableSurroundedByForm(tagStack.tag);
                this.ignoreFormEnd = true;
                this.formNeedsPlacing = true;
                return true;
            }
        }
        if (this.stack.advance(element)) {
            this.markFirstTime(element);
            return true;
        }
        boolean bl = false;
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (!this.strict && (string.equals("table") && string2.equals("td") || string.equals("table") && string2.equals("th") || string.equals("tr") && !string2.equals("tr"))) {
            bl = true;
        }
        if (!this.strict && !bl && (this.stack.elem.getName() != element.getName() || element.getName().equals("body")) && (this.skipTag = this.ignoreElement(element))) {
            this.error("tag.ignore", element.getName());
            return this.skipTag;
        }
        if (!(this.strict || !string.equals("table") || string2.equals("tr") || string2.equals("td") || string2.equals("th") || string2.equals("caption"))) {
            Element element2 = this.dtd.getElement("tr");
            Tag tag = this.makeTag(element2, null);
            this.legalTagContext(tag);
            this.startTag(tag);
            this.error("start.missing", element.getName());
            return this.legalElementContext(element);
        }
        if (!bl && this.stack.terminate() && (!this.strict || this.stack.elem.omitEnd())) {
            dTDConstants = this.stack.next;
            while (dTDConstants != null) {
                if (((TagStack)dTDConstants).advance(element)) {
                    while (this.stack != dTDConstants) {
                        this.endTag(true);
                    }
                    return true;
                }
                if (!((TagStack)dTDConstants).terminate() || this.strict && !((TagStack)dTDConstants).elem.omitEnd()) break;
                dTDConstants = ((TagStack)dTDConstants).next;
            }
        }
        if ((dTDConstants = this.stack.first()) != null && (!this.strict || ((Element)dTDConstants).omitStart())) {
            Tag tag = this.makeTag((Element)dTDConstants, null);
            this.legalTagContext(tag);
            this.startTag(tag);
            if (!((Element)dTDConstants).omitStart()) {
                this.error("start.missing", element.getName());
            }
            return this.legalElementContext(element);
        }
        if (!this.strict) {
            ContentModel contentModel = this.stack.contentModel();
            Vector vector = new Vector();
            if (contentModel != null) {
                contentModel.getElements(vector);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ContentModel contentModel2;
                    Element element3 = (Element)enumeration.nextElement();
                    if (this.stack.excluded(element3.getIndex())) continue;
                    boolean bl2 = false;
                    AttributeList attributeList = element3.getAttributes();
                    while (attributeList != null) {
                        if (attributeList.modifier == 2) {
                            bl2 = true;
                            break;
                        }
                        attributeList = attributeList.next;
                    }
                    if (bl2 || (contentModel2 = element3.getContent()) == null || !contentModel2.first(element)) continue;
                    Tag tag = this.makeTag(element3, null);
                    this.legalTagContext(tag);
                    this.startTag(tag);
                    this.error("start.missing", element3.getName());
                    return this.legalElementContext(element);
                }
            }
        }
        if (this.stack.terminate() && this.stack.elem != this.dtd.body && (!this.strict || this.stack.elem.omitEnd())) {
            if (!this.stack.elem.omitEnd()) {
                this.error("end.missing", element.getName());
            }
            this.endTag(true);
            return this.legalElementContext(element);
        }
        return false;
    }

    void legalTagContext(Tag tag) {
        if (this.legalElementContext(tag.getElement())) {
            this.markFirstTime(tag.getElement());
            return;
        }
        if (tag.isBlock() && this.stack != null && !this.stack.tag.isBlock()) {
            this.endTag(true);
            this.legalTagContext(tag);
            return;
        }
        TagStack tagStack = this.stack;
        while (tagStack != null) {
            if (tagStack.tag.getElement() == this.dtd.head) {
                while (this.stack != tagStack) {
                    this.endTag(true);
                }
                this.endTag(true);
                this.legalTagContext(tag);
                return;
            }
            tagStack = tagStack.next;
        }
        this.error("tag.unexpected", tag.getElement().getName());
    }

    void errorContext() {
        while (this.stack != null && this.stack.tag.getElement() != this.dtd.body) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            this.legalElementContext(this.dtd.body);
            this.startTag(this.makeTag(this.dtd.body, null));
        }
    }

    void addString(int n) {
        if (this.strpos == this.str.length) {
            char[] cArray = new char[this.str.length + 128];
            System.arraycopy(this.str, 0, cArray, 0, this.str.length);
            this.str = cArray;
        }
        this.str[this.strpos++] = (char)n;
    }

    String getString(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return new String(cArray);
    }

    char[] getChars(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return cArray;
    }

    char[] getChars(int n, int n2) {
        char[] cArray = new char[n2 - n];
        System.arraycopy(this.str, n, cArray, 0, n2 - n);
        return cArray;
    }

    void resetStrBuffer() {
        this.strpos = 0;
    }

    int strIndexOf(char c) {
        int n = 0;
        while (n < this.strpos) {
            if (this.str[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void skipSpace() throws IOException {
        block5: while (true) {
            switch (this.ch) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    continue block5;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch != 10) continue block5;
                    this.ch = this.readCh();
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    continue block5;
                }
            }
            break;
        }
    }

    boolean parseIdentifier(boolean bl) throws IOException {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (!bl) break;
                this.ch = 97 + (this.ch - 65);
                break;
            }
            default: {
                return false;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.readCh();
            switch (this.ch) {
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (!bl) continue block8;
                    this.ch = 97 + (this.ch - 65);
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    private char[] parseEntityReference() throws IOException {
        int n = this.strpos;
        this.ch = this.readCh();
        if (this.ch == 35) {
            int n2 = 0;
            this.ch = this.readCh();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n2 = n2 * 10 + this.ch - 48;
                    this.ch = this.readCh();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.readCh();
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        this.ch = this.readCh();
                        if (this.ch != 10) break;
                        this.ch = this.readCh();
                        break;
                    }
                    case 59: {
                        this.ch = this.readCh();
                        break;
                    }
                }
                char[] cArray = new char[]{(char)n2};
                return cArray;
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = n;
                char[] cArray = new char[]{'&', '#'};
                return cArray;
            }
        } else if (!this.parseIdentifier(false)) {
            char[] cArray = new char[]{'&'};
            return cArray;
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.readCh();
                break;
            }
            case 13: {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch != 10) break;
                this.ch = this.readCh();
                break;
            }
            case 59: {
                this.ch = this.readCh();
                break;
            }
        }
        String string = this.getString(n);
        Entity entity = this.dtd.getEntity(string);
        if (!this.strict && entity == null) {
            entity = this.dtd.getEntity(string.toLowerCase());
        }
        if (entity == null || !entity.isGeneral()) {
            String string2;
            if (this.props == null || !this.matchesInterestedType() || (string2 = this.props.getProperty(string)) == null) {
                if (string.length() == 0) {
                    this.error("invalid.entref", string);
                    return new char[0];
                }
                string2 = "&" + string;
            }
            char[] cArray = new char[string2.length()];
            string2.getChars(0, cArray.length, cArray, 0);
            return cArray;
        }
        return entity.getData();
    }

    void parseComment() throws IOException {
        block7: while (true) {
            int n = this.ch;
            switch (n) {
                case 45: {
                    if (!this.strict && this.strpos != 0 && this.str[this.strpos - 1] == '-') {
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        if (this.ch != 33) break;
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        this.addString(45);
                        this.addString(33);
                        continue block7;
                    }
                    this.ch = this.readCh();
                    if (this.ch != 45) break;
                    this.ch = this.readCh();
                    if (this.strict || this.ch == 62) {
                        return;
                    }
                    if (this.ch == 33) {
                        this.ch = this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        this.addString(45);
                        this.addString(33);
                        continue block7;
                    }
                    this.addString(45);
                    break;
                }
                case -1: {
                    this.handleEOFInComment();
                    return;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    break;
                }
                case 62: {
                    this.ch = this.readCh();
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                    }
                    n = 10;
                    break;
                }
                default: {
                    this.ch = this.readCh();
                }
            }
            this.addString(n);
        }
    }

    void parseLiteral(boolean bl) throws IOException {
        block7: while (true) {
            int n = this.ch;
            switch (n) {
                case -1: {
                    this.error("eof.literal", this.stack.elem.getName());
                    this.endTag(true);
                    return;
                }
                case 62: {
                    this.ch = this.readCh();
                    int n2 = this.textpos - (this.stack.elem.name.length() + 2);
                    int n3 = 0;
                    if (n2 < 0 || this.text[n2++] != '<' || this.text[n2] != '/') break;
                    while (++n2 < this.textpos && Character.toLowerCase(this.text[n2]) == this.stack.elem.name.charAt(n3++)) {
                    }
                    if (n2 != this.textpos) break;
                    this.textpos -= this.stack.elem.name.length() + 2;
                    if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                        --this.textpos;
                    }
                    this.endTag(false);
                    return;
                }
                case 38: {
                    char[] cArray = this.parseEntityReference();
                    if (this.textpos + cArray.length > this.text.length) {
                        char[] cArray2 = new char[Math.max(this.textpos + cArray.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray2, 0, this.text.length);
                        this.text = cArray2;
                    }
                    System.arraycopy(cArray, 0, this.text, this.textpos, cArray.length);
                    this.textpos += cArray.length;
                    continue block7;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                    }
                    n = 10;
                    break;
                }
                default: {
                    this.ch = this.readCh();
                }
            }
            if (this.textpos == this.text.length) {
                char[] cArray = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = (char)n;
        }
    }

    String parseAttributeValue(boolean bl) throws IOException {
        int n = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                n = this.ch;
                this.ch = this.readCh();
                break;
            }
        }
        block14: while (true) {
            int n2 = this.ch;
            switch (n2) {
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                    }
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 9: {
                    if (n < 0) {
                        n2 = 32;
                    }
                }
                case 32: {
                    this.ch = this.readCh();
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 60: 
                case 62: {
                    if (n < 0) {
                        return this.getString(0);
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 34: 
                case 39: {
                    this.ch = this.readCh();
                    if (n2 == n) {
                        return this.getString(0);
                    }
                    if (n != -1) break;
                    this.error("attvalerr");
                    if (!this.strict && this.ch != 32) continue block14;
                    return this.getString(0);
                }
                case 61: {
                    if (n < 0) {
                        this.error("attvalerr");
                        if (this.strict) {
                            return this.getString(0);
                        }
                    }
                    this.ch = this.readCh();
                    break;
                }
                case 38: {
                    if (this.strict && n < 0) {
                        this.ch = this.readCh();
                        break;
                    }
                    char[] cArray = this.parseEntityReference();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= cArray.length) continue block14;
                        n2 = cArray[n3];
                        this.addString(bl && n2 >= 65 && n2 <= 90 ? 97 + n2 - 65 : n2);
                        ++n3;
                    }
                }
                case -1: {
                    return this.getString(0);
                }
                default: {
                    if (bl && n2 >= 65 && n2 <= 90) {
                        n2 = 97 + n2 - 65;
                    }
                    this.ch = this.readCh();
                }
            }
            this.addString(n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Attributes parseAttributeSpecificationList(Element element) throws IOException {
        Attributes attributes = null;
        block4: while (true) {
            String string;
            String string2;
            AttributeList attributeList;
            block21: {
                char[] cArray;
                block22: {
                    block23: {
                        block24: {
                            block19: {
                                block20: {
                                    this.skipSpace();
                                    switch (this.ch) {
                                        case -1: 
                                        case 47: 
                                        case 60: 
                                        case 62: {
                                            return attributes;
                                        }
                                        case 45: {
                                            this.ch = this.readCh();
                                            if (this.ch == 45) {
                                                this.ch = this.readCh();
                                                this.parseComment();
                                                this.strpos = 0;
                                                continue block4;
                                            }
                                            this.error("invalid.tagchar", "-", element.getName());
                                            this.ch = this.readCh();
                                            continue block4;
                                        }
                                    }
                                    attributeList = null;
                                    string2 = null;
                                    string = null;
                                    if (!this.parseIdentifier(true)) break block19;
                                    string2 = this.getString(0);
                                    this.skipSpace();
                                    if (this.ch != 61) break block20;
                                    this.ch = this.readCh();
                                    this.skipSpace();
                                    attributeList = element.getAttribute(string2);
                                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                                    break block21;
                                }
                                string = string2;
                                attributeList = element.getAttributeByValue(string);
                                if (attributeList != null || (attributeList = element.getAttribute(string2)) == null) break block21;
                                string = attributeList.getValue();
                                break block21;
                            }
                            if (!this.strict && this.ch == 44) {
                                this.ch = this.readCh();
                                continue;
                            }
                            if (this.strict || this.ch != 34) break block22;
                            this.ch = this.readCh();
                            this.skipSpace();
                            if (!this.parseIdentifier(true)) break block23;
                            string2 = this.getString(0);
                            if (this.ch == 34) {
                                this.ch = this.readCh();
                            }
                            this.skipSpace();
                            if (this.ch != 61) break block24;
                            this.ch = this.readCh();
                            this.skipSpace();
                            attributeList = element.getAttribute(string2);
                            string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                            break block21;
                        }
                        string = string2;
                        attributeList = element.getAttributeByValue(string);
                        if (attributeList != null || (attributeList = element.getAttribute(string2)) == null) break block21;
                        string = attributeList.getValue();
                        break block21;
                    }
                    cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    this.ch = this.readCh();
                    continue;
                }
                if (!this.strict && attributes == null && this.ch == 61) {
                    this.ch = this.readCh();
                    this.skipSpace();
                    string2 = element.getName();
                    attributeList = element.getAttribute(string2);
                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                } else {
                    if (!this.strict && this.ch == 61) {
                        this.ch = this.readCh();
                        this.skipSpace();
                        string = this.parseAttributeValue(true);
                        this.error("attvalerr");
                        return attributes;
                    }
                    cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    if (this.strict) return attributes;
                    this.ch = this.readCh();
                    continue;
                }
            }
            if (attributeList != null) {
                string2 = attributeList.getName();
            } else {
                this.error("invalid.tagatt", string2, element.getName());
            }
            if (attributes == null) {
                attributes = new Attributes();
            } else if (attributes.get(string2) != null) {
                this.error("multi.tagatt", string2, element.getName());
            }
            if (string == null) {
                string = attributeList != null && attributeList.value != null ? attributeList.value : "";
            } else if (attributeList != null && attributeList.values != null && !attributeList.values.contains(string)) {
                this.error("invalid.tagattval", string2, element.getName());
            }
            attributes.append(string2, string);
        }
    }

    public String parseDTDMarkup() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.ch = this.readCh();
        block7: while (true) {
            switch (this.ch) {
                case 62: {
                    this.ch = this.readCh();
                    return stringBuffer.toString();
                }
                case -1: {
                    this.error("invalid.markup");
                    return stringBuffer.toString();
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    continue block7;
                }
                case 34: {
                    this.ch = this.readCh();
                    continue block7;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.ch != 10) continue block7;
                    this.ch = this.readCh();
                    continue block7;
                }
            }
            stringBuffer.append((char)(this.ch & 0xFF));
            this.ch = this.readCh();
        }
    }

    protected boolean parseMarkupDeclarations(StringBuffer stringBuffer) throws IOException {
        if (stringBuffer.length() == "DOCTYPE".length() && stringBuffer.toString().toUpperCase().equals("DOCTYPE")) {
            this.parseDTDMarkup();
            return true;
        }
        return false;
    }

    void parseInvalidTag() throws IOException {
        while (true) {
            this.skipSpace();
            switch (this.ch) {
                case -1: 
                case 62: {
                    this.ch = this.readCh();
                    return;
                }
                case 60: {
                    return;
                }
            }
            this.ch = this.readCh();
        }
    }

    /*
     * Unable to fully structure code
     */
    void parseTag() throws IOException {
        var1_1 = null;
        var2_2 = false;
        var3_3 = false;
        this.ch = this.readCh();
        switch (this.ch) {
            case 33: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 45: {
                        block36: while (true) {
                            if (this.ch == 45) {
                                if (!this.strict || (this.ch = this.readCh()) == 45) {
                                    this.ch = this.readCh();
                                    this.parseComment();
                                    this.handleComment(this.getChars(0));
                                    continue;
                                }
                                if (!var3_3) {
                                    var3_3 = true;
                                    this.error("invalid.commentchar", "-");
                                }
                            }
                            this.skipSpace();
                            switch (this.ch) {
                                case 45: {
                                    continue block36;
                                }
                                case 62: {
                                    this.ch = this.readCh();
                                }
                                case -1: {
                                    return;
                                }
                            }
                            this.ch = this.readCh();
                            if (var3_3) continue;
                            var3_3 = true;
                            this.error("invalid.commentchar", String.valueOf((char)this.ch));
                        }
                    }
                }
                var4_4 = new StringBuffer();
                block37: while (true) {
                    var4_4.append((char)this.ch);
                    if (this.parseMarkupDeclarations(var4_4)) {
                        return;
                    }
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.readCh();
                        }
                        case -1: {
                            this.error("invalid.markup");
                            return;
                        }
                        case 10: {
                            ++this.ln;
                            this.ch = this.readCh();
                            continue block37;
                        }
                        case 13: {
                            ++this.ln;
                            this.ch = this.readCh();
                            if (this.ch != 10) continue block37;
                            this.ch = this.readCh();
                            continue block37;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            case 47: {
                this.ch = this.readCh();
                switch (this.ch) {
                    case 62: {
                        this.ch = this.readCh();
                    }
                    case 60: {
                        if (this.recent == null) {
                            this.error("invalid.shortend");
                            return;
                        }
                        var1_1 = this.recent;
                        break;
                    }
                    default: {
                        if (!this.parseIdentifier(true)) {
                            this.error("expected.endtagname");
                            return;
                        }
                        this.skipSpace();
                        switch (this.ch) {
                            case 62: {
                                this.ch = this.readCh();
                                break;
                            }
                            default: {
                                this.error("expected", "'>'");
                                while (this.ch != -1 && this.ch != 10 && this.ch != 62) {
                                    this.ch = this.readCh();
                                }
                                if (this.ch != 62) break;
                                this.ch = this.readCh();
                            }
                            case 60: 
                        }
                        var4_5 = this.getString(0);
                        if (!this.dtd.elementExists((String)var4_5)) {
                            this.error("end.unrecognized", (String)var4_5);
                            if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                                --this.textpos;
                            }
                            return;
                        }
                        var1_1 = this.dtd.getElement((String)var4_5);
                    }
                }
                if (this.stack == null) {
                    this.error("end.extra.tag", var1_1.getName());
                    return;
                }
                if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                    if (this.stack.pre) {
                        if (this.textpos > 1 && this.text[this.textpos - 2] != '\n') {
                            --this.textpos;
                        }
                    } else {
                        --this.textpos;
                    }
                }
                if (!this.strict) {
                    var4_5 = this.stack.elem.getName();
                    if (var1_1.getName().equals("form") && this.ignoreFormEnd) {
                        this.ignoreFormEnd = false;
                        var5_7 = this.stack;
                        while (var5_7 != null && !var5_7.elem.getName().equals("table")) {
                            var5_7 = var5_7.next;
                        }
                        if (var5_7 != null) {
                            this.incrementNumberFormsToEnd(var5_7.tag);
                        }
                        return;
                    }
                    if (var4_5.equals("table") && !var1_1.getName().equals(var4_5)) {
                        this.error("tag.ignore", var1_1.getName());
                        return;
                    }
                    if ((var4_5.equals("tr") || var4_5.equals("td")) && !var1_1.getName().equals("table") && !var1_1.getName().equals(var4_5)) {
                        this.error("tag.ignore", var1_1.getName());
                        return;
                    }
                }
                var4_5 = this.stack;
                while (var4_5 != null && var1_1 != var4_5.elem) {
                    var4_5 = var4_5.next;
                }
                if (var4_5 == null) {
                    this.error("unmatched.endtag", var1_1.getName());
                    return;
                }
                var5_8 = var1_1.getName();
                if (this.stack == var4_5 || !var5_8.equals("font") && !var5_8.equals("center")) ** GOTO lbl135
                if (var5_8.equals("center")) {
                    while (this.stack.elem.omitEnd() && this.stack != var4_5) {
                        this.endTag(true);
                    }
                    if (this.stack.elem == var1_1) {
                        this.endTag(false);
                    }
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.endTag(true);
lbl135:
                    // 2 sources

                    ** while (this.stack != var4_5)
                }
lbl136:
                // 1 sources

                if (!this.strict) {
                    this.checkForSurroundedTable(var1_1, this.stack.tag);
                }
                this.endTag(false);
                if (!this.strict && var1_1.getName().equals("table") && this.stack.elem.getName().equals("form")) {
                    this.doNecessarySurroundedTableCleanup();
                    this.ignoreFormEnd = false;
                }
                return;
            }
            case -1: {
                this.error("eof");
                return;
            }
        }
        if (!this.parseIdentifier(true)) {
            var1_1 = this.recent;
            if (this.ch != 62 || var1_1 == null) {
                this.error("expected.tagname");
                return;
            }
        } else {
            var4_6 = this.getString(0);
            if (!this.dtd.elementExists((String)var4_6)) {
                this.parseInvalidTag();
                this.error("tag.unrecognized", (String)var4_6);
                return;
            }
            var1_1 = this.dtd.getElement((String)var4_6);
        }
        var4_6 = this.parseAttributeSpecificationList(var1_1);
        switch (this.ch) {
            case 47: {
                var2_2 = true;
            }
            case 62: {
                this.ch = this.readCh();
                break;
            }
            default: {
                this.error("expected", "'>'");
            }
            case 60: 
        }
        if (!var1_1.isEmpty()) {
            if (this.ch == 10) {
                ++this.ln;
                this.ch = this.readCh();
            } else if (this.ch == 13) {
                ++this.ln;
                this.ch = this.readCh();
                if (this.ch == 10) {
                    this.ch = this.readCh();
                }
            }
        }
        var5_9 = this.makeTag(var1_1, (Attributes)var4_6);
        this.legalTagContext(var5_9);
        if (!this.strict && this.skipTag) {
            this.skipTag = false;
            return;
        }
        if (!this.strict && this.formNeedsPlacing) {
            this.formNeedsPlacing = false;
            this.handleFormTagInTable(var5_9);
            var6_10 = this.stack;
            while (!var6_10.elem.getName().equals("table")) {
                var6_10 = var6_10.next;
            }
            var7_11 = var6_10.next;
            var6_10.next = var8_12 = new TagStack(var5_9, var7_11);
            return;
        }
        this.startTag(var5_9);
        if (!var1_1.isEmpty()) {
            switch (var1_1.getType()) {
                case 1: {
                    this.parseLiteral(false);
                    return;
                }
                case 16: {
                    this.parseLiteral(true);
                    return;
                }
            }
            this.stack.net = var2_2;
            return;
        }
    }

    void parseContent() throws IOException {
        Thread thread = Thread.currentThread();
        block9: while (true) {
            char[] cArray;
            if (!this.ignoringInterrupts && thread.isInterrupted()) {
                thread.interrupt();
                return;
            }
            int n = this.ch;
            switch (n) {
                case 60: {
                    this.parseTag();
                    continue block9;
                }
                case 47: {
                    this.ch = this.readCh();
                    if (this.stack == null || !this.stack.net) break;
                    this.endTag(false);
                    continue block9;
                }
                case -1: {
                    return;
                }
                case 38: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    if (this.textpos + (cArray = this.parseEntityReference()).length + 1 > this.text.length) {
                        char[] cArray2 = new char[Math.max(this.textpos + cArray.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray2, 0, this.text.length);
                        this.text = cArray2;
                    }
                    if (this.space) {
                        this.space = false;
                        this.text[this.textpos++] = 32;
                    }
                    System.arraycopy(cArray, 0, this.text, this.textpos, cArray.length);
                    this.textpos += cArray.length;
                    continue block9;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 13: {
                    ++this.ln;
                    n = 10;
                    this.ch = this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.readCh();
                    }
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 9: 
                case 32: {
                    this.ch = this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                default: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    this.ch = this.readCh();
                }
            }
            if (this.textpos + 2 > this.text.length) {
                cArray = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            if (this.space) {
                this.text[this.textpos++] = 32;
                this.space = false;
            }
            this.text[this.textpos++] = (char)n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void parse(Reader var1_1, DTD var2_2) throws IOException {
        this.in = var1_1;
        this.dtd = var2_2;
        this.ln = 1;
        this.initDocumentState();
        try {
            try {
                try {
                    this.ch = this.readCh();
                    this.text = new char[1024];
                    this.str = new char[128];
                    this.parseContent();
                    while (this.stack != null) {
                        this.endTag(true);
                    }
                }
                finally {
                    var6_3 = null;
                    var1_1.close();
                }
            }
            catch (IOException var5_6) {
                this.errorContext();
                this.error("ioexception");
                throw var5_6;
            }
            catch (Exception var5_7) {
                this.errorContext();
                this.error("exception", var5_7.getClass().getName(), var5_7.getMessage());
                var5_7.printStackTrace();
            }
            catch (ThreadDeath var5_8) {
                this.errorContext();
                this.error("terminated");
                throw var5_8;
            }
            var4_9 = null;
            ** while (this.stack != null)
        }
        catch (Throwable var3_11) {
            var4_10 = null;
            ** while (this.stack != null)
        }
lbl-1000:
        // 1 sources

        {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
            continue;
        }
lbl40:
        // 1 sources

        this.text = null;
        this.str = null;
        return;
lbl-1000:
        // 1 sources

        {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
            continue;
        }
lbl50:
        // 1 sources

        this.text = null;
        this.str = null;
        throw var3_11;
    }

    protected void interruptsIgnored(boolean bl) {
        this.ignoringInterrupts = bl;
    }

    private final int readCh() throws IOException {
        if (this.pos >= this.len) {
            while (true) {
                try {
                    this.len = this.in.read(this.buf);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.ignoringInterrupts) continue;
                    throw interruptedIOException;
                }
                break;
            }
            if (this.len <= 0) {
                return -1;
            }
            this.pos = 0;
        }
        return this.buf[this.pos++];
    }

    protected void initDocumentState() {
        this.seenHtml = false;
        this.seenHead = false;
        this.seenBody = false;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties(System.getProperties());
        String string = System.getProperty("hotjava.home");
        if (string == null) {
            System.err.println("Must set property 'hotjava.home'");
            return;
        }
        try {
            properties.load(new FileInputStream(String.valueOf(string) + "/lib/properties"));
        }
        catch (IOException iOException) {
            System.err.println("No system properties file");
            iOException.printStackTrace(System.err);
            return;
        }
        System.setProperties(properties);
        Parser parser = new Parser();
        int n = 0;
        DTD dTD = null;
        String string2 = "8859_1";
        while (n < stringArray.length) {
            if (stringArray[n].equals("-verbose")) {
                parser.verbose = true;
            } else if (stringArray[n].equals("-charset") && n + 1 < stringArray.length) {
                string2 = stringArray[++n];
            } else if (stringArray[n].equals("-dtd") && n + 1 < stringArray.length && dTD == null) {
                dTD = DTD.getDTD(stringArray[++n]);
            } else {
                if (!stringArray[n].startsWith("-")) break;
                System.out.println("invalid argument: " + stringArray[n]);
                System.exit(1);
            }
            ++n;
        }
        if (dTD == null) {
            dTD = DTD.getDTD("html32");
        }
        if (parser.verbose) {
            parser.out = new HTMLOutputWriter(new OutputStreamWriter(System.out), dTD);
        }
        while (n < stringArray.length) {
            block15: {
                InputStream inputStream = null;
                try {
                    inputStream = stringArray[n].indexOf(58) > 0 ? new URL(null, stringArray[n]).openStream() : new BufferedInputStream(new FileInputStream(stringArray[n]));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("failed to open: " + stringArray[n]);
                    break block15;
                }
                long l = System.currentTimeMillis();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
                parser.parse(inputStreamReader, dTD);
                l = System.currentTimeMillis() - l;
                System.out.println("[Parsed " + stringArray[n] + " in " + l + "ms]");
            }
            ++n;
        }
    }

    public void printImmediateDocContext() {
        this.printImmediateDocContext(5);
    }

    public void printImmediateDocContext(int n) {
    }

    public boolean matchesInterestedType() {
        return false;
    }
}

