/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import sunw.html.AttributeList;
import sunw.html.ContentModel;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.DTDInputStream;
import sunw.html.Element;
import sunw.html.Entity;

final class DTDParser
implements DTDConstants {
    DTD dtd;
    DTDInputStream in;
    int ch;
    char[] str = new char[128];
    int strpos;
    int nerrors;

    void error(String string, String string2, String string3, String string4) {
        ++this.nerrors;
        String[] stringArray = new String[]{string2, string3, string4};
        String string5 = this.getSubstProp("dtderr." + string, stringArray);
        if (string5 == null) {
            string5 = String.valueOf(string) + "[" + string2 + "," + string3 + "," + string4 + "]";
        }
        System.err.println("line " + this.in.ln + ", dtd " + this.dtd + ": " + string5);
    }

    void error(String string, String string2, String string3) {
        this.error(string, string2, string3, "?");
    }

    void error(String string, String string2) {
        this.error(string, string2, "?", "?");
    }

    void error(String string) {
        this.error(string, "?", "?", "?");
    }

    private String getSubstProp(String string, String[] stringArray) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(string2, stringArray);
    }

    boolean expect(int n) throws IOException {
        if (this.ch != n) {
            char[] cArray = new char[]{(char)n};
            this.error("expected", "'" + new String(cArray) + "'");
            return false;
        }
        this.ch = this.in.read();
        return true;
    }

    void addString(int n) {
        if (this.strpos == this.str.length) {
            char[] cArray = new char[this.str.length * 2];
            System.arraycopy(this.str, 0, cArray, 0, this.str.length);
            this.str = cArray;
        }
        this.str[this.strpos++] = (char)n;
    }

    String getString(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return new String(cArray);
    }

    char[] getChars(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return cArray;
    }

    void skipSpace() throws IOException {
        block3: while (true) {
            switch (this.ch) {
                case 9: 
                case 10: 
                case 32: {
                    this.ch = this.in.read();
                    continue block3;
                }
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    void skipParameterSpace() throws IOException {
        block8: while (true) {
            switch (this.ch) {
                case 9: 
                case 10: 
                case 32: {
                    this.ch = this.in.read();
                    continue block8;
                }
                case 45: {
                    this.ch = this.in.read();
                    if (this.ch != 45) {
                        this.in.push(this.ch);
                        this.ch = 45;
                        return;
                    }
                    ++this.in.replace;
                    block9: while (true) {
                        this.ch = this.in.read();
                        switch (this.ch) {
                            default: {
                                continue block9;
                            }
                            case 45: {
                                this.ch = this.in.read();
                                if (this.ch == 45) ** break;
                                continue block9;
                                this.ch = this.in.read();
                                --this.in.replace;
                                this.skipParameterSpace();
                                return;
                            }
                            case -1: 
                        }
                        break;
                    }
                    this.error("eof.arg", "comment");
                    --this.in.replace;
                    return;
                }
            }
            break;
        }
    }

    boolean parseIdentifier(boolean bl) throws IOException {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (!bl) break;
                this.ch = 97 + (this.ch - 65);
                break;
            }
            default: {
                return false;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (!bl) continue block8;
                    this.ch = 97 + (this.ch - 65);
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    Vector parseIdentifierList(boolean bl) throws IOException {
        Vector<String> vector = new Vector<String>();
        this.skipSpace();
        switch (this.ch) {
            case 40: {
                this.ch = this.in.read();
                this.skipParameterSpace();
                while (this.parseIdentifier(bl)) {
                    vector.addElement(this.getString(0));
                    this.skipParameterSpace();
                    if (this.ch != 124) continue;
                    this.ch = this.in.read();
                    this.skipParameterSpace();
                }
                this.expect(41);
                this.skipParameterSpace();
                break;
            }
            default: {
                if (!this.parseIdentifier(bl)) {
                    this.error("expected", "identifier");
                    break;
                }
                vector.addElement(this.getString(0));
                this.skipParameterSpace();
            }
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    private void parseEntityReference() throws IOException {
        block10: {
            var1_1 = this.strpos;
            this.ch = this.in.read();
            if (this.ch != 35) break block10;
            var2_2 = 0;
            this.ch = this.in.read();
            if ((this.ch < 97 || this.ch > 122) && (this.ch < 65 || this.ch > 90)) ** GOTO lbl11
            this.addString(35);
            break block10;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2 * 10 + this.ch - 48;
                this.ch = this.in.read();
lbl11:
                // 2 sources

                ** while (this.ch >= 48 && this.ch <= 57)
            }
lbl12:
            // 1 sources

            if (this.ch == 59 || this.ch == 10) {
                this.ch = this.in.read();
            }
            this.addString(var2_2);
            return;
        }
        block4: while (true) {
            switch (this.ch) {
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.addString(this.ch);
                    this.ch = this.in.read();
                    continue block4;
                }
            }
            break;
        }
        if (this.strpos == var1_1) {
            this.addString(38);
            return;
        }
        var2_3 = this.getString(var1_1);
        var3_4 = this.dtd.getEntity(var2_3);
        if (var3_4 == null) {
            this.error("undef.entref" + var2_3);
            return;
        }
        if (this.ch == 59 || this.ch == 10) {
            this.ch = this.in.read();
        }
        var4_5 = var3_4.getData();
        var5_6 = 0;
        while (var5_6 < var4_5.length) {
            this.addString(var4_5[var5_6]);
            ++var5_6;
        }
    }

    private void parseEntityDeclaration() throws IOException {
        int n = 65536;
        this.skipSpace();
        if (this.ch == 37) {
            this.ch = this.in.read();
            n = 262144;
            this.skipSpace();
        }
        if (this.ch == 35) {
            this.addString(35);
            this.ch = this.in.read();
        }
        if (!this.parseIdentifier(false)) {
            this.error("expected", "identifier");
            return;
        }
        String string = this.getString(0);
        this.skipParameterSpace();
        if (this.parseIdentifier(false)) {
            String string2 = this.getString(0);
            int n2 = Entity.name2type(string2);
            if (n2 == 0) {
                this.error("invalid.arg", "entity type", string2);
            } else {
                n |= n2;
            }
            this.skipParameterSpace();
        }
        if (this.ch != 34 && this.ch != 39) {
            this.error("expected", "entity value");
            this.skipParameterSpace();
            if (this.ch == 62) {
                this.ch = this.in.read();
            }
            return;
        }
        int n3 = this.ch;
        this.ch = this.in.read();
        while (this.ch != -1 && this.ch != n3) {
            if (this.ch == 38) {
                this.parseEntityReference();
                continue;
            }
            this.addString(this.ch & 0xFF);
            this.ch = this.in.read();
        }
        if (this.ch == n3) {
            this.ch = this.in.read();
        }
        if (this.in.replace == 0) {
            char[] cArray = this.getChars(0);
            this.dtd.defineEntity(string, n, cArray);
        } else {
            this.strpos = 0;
        }
        this.skipParameterSpace();
        this.expect(62);
    }

    ContentModel parseContentModel() throws IOException {
        ContentModel contentModel = null;
        switch (this.ch) {
            case 40: {
                this.ch = this.in.read();
                this.skipParameterSpace();
                ContentModel contentModel2 = this.parseContentModel();
                if (this.ch != 41) {
                    contentModel = new ContentModel(this.ch, contentModel2);
                    do {
                        this.ch = this.in.read();
                        this.skipParameterSpace();
                        contentModel2.next = this.parseContentModel();
                        if (contentModel2.next.type == contentModel.type) {
                            contentModel2.next = (ContentModel)contentModel2.next.content;
                        }
                        while (contentModel2.next != null) {
                            contentModel2 = contentModel2.next;
                        }
                    } while (this.ch == contentModel.type);
                } else {
                    contentModel = new ContentModel(44, contentModel2);
                }
                this.expect(41);
                break;
            }
            case 35: {
                this.ch = this.in.read();
                if (this.parseIdentifier(true)) {
                    contentModel = new ContentModel(42, new ContentModel(this.dtd.getElement("#" + this.getString(0))));
                    break;
                }
                this.error("invalid", "content model");
                break;
            }
            default: {
                if (this.parseIdentifier(true)) {
                    contentModel = new ContentModel(this.dtd.getElement(this.getString(0)));
                    break;
                }
                this.error("invalid", "content model");
            }
        }
        switch (this.ch) {
            case 42: 
            case 43: 
            case 63: {
                contentModel = new ContentModel(this.ch, contentModel);
                this.ch = this.in.read();
                break;
            }
        }
        this.skipParameterSpace();
        return contentModel;
    }

    void parseElementDeclaration() throws IOException {
        Object object;
        Vector vector = this.parseIdentifierList(true);
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.ch == 45 || this.ch == 79) {
            bl = this.ch == 79;
            this.ch = this.in.read();
            this.skipParameterSpace();
            if (this.ch == 45 || this.ch == 79) {
                bl2 = this.ch == 79;
                this.ch = this.in.read();
                this.skipParameterSpace();
            } else {
                this.expect(45);
            }
        }
        int n = 18;
        ContentModel contentModel = null;
        if (this.parseIdentifier(false)) {
            object = this.getString(0);
            n = Element.name2type((String)object);
            if (n == 0) {
                this.error("invalid.arg", "content type", (String)object);
                n = 17;
            }
            this.skipParameterSpace();
        } else {
            contentModel = this.parseContentModel();
        }
        if (n == 18 || n == 19) {
            Enumeration enumeration;
            if (this.ch == 45) {
                this.ch = this.in.read();
                object = this.parseIdentifierList(true);
                bitSet2 = new BitSet();
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    bitSet2.set(this.dtd.getElement((String)enumeration.nextElement()).getIndex());
                }
            }
            if (this.ch == 43) {
                this.ch = this.in.read();
                object = this.parseIdentifierList(true);
                bitSet = new BitSet();
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    bitSet.set(this.dtd.getElement((String)enumeration.nextElement()).getIndex());
                }
            }
        }
        this.expect(62);
        if (this.in.replace == 0) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                this.dtd.defineElement((String)object.nextElement(), n, bl, bl2, contentModel, bitSet2, bitSet, null);
            }
        }
    }

    void parseAttributeDeclaredValue(AttributeList attributeList) throws IOException {
        if (this.ch == 40) {
            attributeList.values = this.parseIdentifierList(true);
            attributeList.type = 9;
            return;
        }
        if (!this.parseIdentifier(false)) {
            this.error("invalid", "attribute value");
            return;
        }
        attributeList.type = AttributeList.name2type(this.getString(0));
        this.skipParameterSpace();
        if (attributeList.type == 11) {
            attributeList.values = this.parseIdentifierList(true);
        }
    }

    String parseAttributeValueSpecification() throws IOException {
        int n = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                n = this.ch;
                this.ch = this.in.read();
            }
        }
        block9: while (true) {
            switch (this.ch) {
                case -1: {
                    this.error("eof.arg", "attribute value");
                    return this.getString(0);
                }
                case 38: {
                    this.parseEntityReference();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 32: {
                    if (n == -1) {
                        return this.getString(0);
                    }
                    this.addString(32);
                    this.ch = this.in.read();
                    continue block9;
                }
                case 34: 
                case 39: {
                    if (n != this.ch) break;
                    this.ch = this.in.read();
                    return this.getString(0);
                }
            }
            this.addString(this.ch & 0xFF);
            this.ch = this.in.read();
        }
    }

    void parseAttributeDefaultValue(AttributeList attributeList) throws IOException {
        if (this.ch == 35) {
            this.ch = this.in.read();
            if (!this.parseIdentifier(true)) {
                this.error("invalid", "attribute value");
                return;
            }
            this.skipParameterSpace();
            attributeList.modifier = AttributeList.name2type(this.getString(0));
            if (attributeList.modifier != 1) {
                return;
            }
        }
        attributeList.value = this.parseAttributeValueSpecification();
        this.skipParameterSpace();
    }

    void parseAttlistDeclaration() throws IOException {
        Vector vector = this.parseIdentifierList(true);
        AttributeList attributeList = null;
        AttributeList attributeList2 = null;
        while (this.parseIdentifier(true)) {
            if (attributeList2 == null) {
                attributeList = attributeList2 = new AttributeList(this.getString(0));
            } else {
                attributeList2 = attributeList2.next = new AttributeList(this.getString(0));
            }
            this.skipParameterSpace();
            this.parseAttributeDeclaredValue(attributeList2);
            this.parseAttributeDefaultValue(attributeList2);
            if (attributeList2.modifier != 5 || attributeList2.values == null || attributeList2.values.size() != 1) continue;
            attributeList2.value = (String)attributeList2.values.elementAt(0);
        }
        this.expect(62);
        if (this.in.replace == 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.dtd.defineAttributes((String)enumeration.nextElement(), attributeList);
            }
        }
    }

    void parseIgnoredSection() throws IOException {
        int n = 1;
        ++this.in.replace;
        block5: while (true) {
            switch (this.ch) {
                case 60: {
                    this.ch = this.in.read();
                    if (this.ch != 33 || (this.ch = this.in.read()) != 91) continue block5;
                    this.ch = this.in.read();
                    ++n;
                    continue block5;
                }
                case 93: {
                    this.ch = this.in.read();
                    if (this.ch != 93 || (this.ch = this.in.read()) != 62) continue block5;
                    this.ch = this.in.read();
                    if (--n != 0) continue block5;
                    --this.in.replace;
                    return;
                }
                case -1: {
                    this.error("eof");
                    --this.in.replace;
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    void parseMarkedSectionDeclaration() throws IOException {
        this.ch = this.in.read();
        this.skipSpace();
        if (!this.parseIdentifier(true)) {
            this.error("expected", "section status keyword");
            return;
        }
        String string = this.getString(0);
        this.skipSpace();
        this.expect(91);
        if ("ignore".equals(string)) {
            this.parseIgnoredSection();
            return;
        }
        if (!"include".equals(string)) {
            this.error("invalid.arg", "section status keyword", string);
        }
        this.parseSection();
        this.expect(93);
        this.expect(93);
        this.expect(62);
    }

    void parseExternalIdentifier() throws IOException {
        if (this.parseIdentifier(false)) {
            String string = this.getString(0);
            this.skipParameterSpace();
            if (string.equals("PUBLIC")) {
                if (this.ch == 39 || this.ch == 34) {
                    this.parseAttributeValueSpecification();
                } else {
                    this.error("expected", "public identifier");
                }
                this.skipParameterSpace();
            } else if (!string.equals("SYSTEM")) {
                this.error("invalid", "external identifier");
            }
            if (this.ch == 39 || this.ch == 34) {
                this.parseAttributeValueSpecification();
            }
            this.skipParameterSpace();
        }
    }

    void parseDocumentTypeDeclaration() throws IOException {
        this.skipParameterSpace();
        if (!this.parseIdentifier(true)) {
            this.error("expected", "identifier");
        } else {
            this.skipParameterSpace();
        }
        this.strpos = 0;
        this.parseExternalIdentifier();
        if (this.ch == 91) {
            this.ch = this.in.read();
            this.parseSection();
            this.expect(93);
            this.skipParameterSpace();
        }
        this.expect(62);
    }

    void parseSection() throws IOException {
        block13: while (true) {
            switch (this.ch) {
                case 93: {
                    return;
                }
                case 60: {
                    Object object;
                    this.ch = this.in.read();
                    switch (this.ch) {
                        default: {
                            continue block13;
                        }
                        case 33: 
                    }
                    this.ch = this.in.read();
                    switch (this.ch) {
                        case 91: {
                            this.parseMarkedSectionDeclaration();
                            continue block13;
                        }
                        case 45: {
                            this.skipParameterSpace();
                            this.expect(62);
                            continue block13;
                        }
                    }
                    if (this.parseIdentifier(true)) {
                        object = this.getString(0);
                        if (((String)object).equals("element")) {
                            this.parseElementDeclaration();
                            continue block13;
                        }
                        if (((String)object).equals("entity")) {
                            this.parseEntityDeclaration();
                            continue block13;
                        }
                        if (((String)object).equals("attlist")) {
                            this.parseAttlistDeclaration();
                            continue block13;
                        }
                        if (((String)object).equals("doctype")) {
                            this.parseDocumentTypeDeclaration();
                            continue block13;
                        }
                        if (((String)object).equals("usemap")) {
                            this.error("ignoring", "usemap");
                            while (this.ch != -1 && this.ch != 62) {
                                this.ch = this.in.read();
                            }
                            this.expect(62);
                            continue block13;
                        }
                        if (((String)object).equals("shortref")) {
                            this.error("ignoring", "shortref");
                            while (this.ch != -1 && this.ch != 62) {
                                this.ch = this.in.read();
                            }
                            this.expect(62);
                            continue block13;
                        }
                        if (((String)object).equals("notation")) {
                            this.error("ignoring", "notation");
                            while (this.ch != -1 && this.ch != 62) {
                                this.ch = this.in.read();
                            }
                            this.expect(62);
                            continue block13;
                        }
                        this.error("markup");
                        continue block13;
                    }
                    this.error("markup");
                    while (this.ch != -1 && this.ch != 62) {
                        this.ch = this.in.read();
                    }
                    this.expect(62);
                    continue block13;
                }
                case -1: {
                    return;
                }
                default: {
                    Object object = new char[]{(char)this.ch};
                    this.error("invalid.arg", "character", "'" + new String((char[])object) + "' / " + this.ch);
                }
                case 9: 
                case 10: 
                case 32: 
            }
            this.ch = this.in.read();
        }
    }

    DTD parse(InputStream inputStream, DTD dTD) {
        try {
            this.dtd = dTD;
            this.in = new DTDInputStream(inputStream, dTD);
            long l = System.currentTimeMillis();
            this.ch = this.in.read();
            this.parseSection();
            if (this.ch != -1) {
                this.error("premature");
            }
            l = System.currentTimeMillis() - l;
            System.err.println("[Parsed DTD " + dTD + " in " + l + "ms]");
        }
        catch (IOException iOException) {
            this.error("ioexception");
        }
        catch (Exception exception) {
            this.error("exception", exception.getClass().getName(), exception.getMessage());
            exception.printStackTrace();
        }
        catch (ThreadDeath threadDeath) {
            this.error("terminated");
        }
        if (this.nerrors > 0) {
            return null;
        }
        return dTD;
    }

    DTDParser() {
    }
}

