/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.URL;
import sun.applet.AppletClassLoader;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.security.CommonSecurity;
import sunw.hotjava.security.PolicyUntrusted;

public class PolicyHigh
extends PolicyUntrusted {
    private static PolicyHigh high;

    public static PolicyHigh getPolicyHigh() {
        if (high == null) {
            high = new PolicyHigh();
        }
        return high;
    }

    protected PolicyHigh() {
    }

    public boolean checkAccess(Thread thread) {
        CommonSecurity commonSecurity = this.getCSM();
        return commonSecurity.inThreadGroup(thread);
    }

    public boolean checkAccess(ThreadGroup threadGroup) {
        CommonSecurity commonSecurity = this.getCSM();
        return commonSecurity.inThreadGroup(threadGroup);
    }

    public boolean checkPropertyAccess(String string) {
        if (Boolean.getBoolean(String.valueOf(string) + ".applet")) {
            return true;
        }
        return super.checkPropertyAccess(string);
    }

    public boolean checkRead(String string, URL uRL) {
        String string2 = this.getRealPath(string);
        if (uRL.getProtocol().equals("file")) {
            String string3 = null;
            try {
                String string4 = uRL.getFile();
                string4.replace('/', File.separatorChar);
                string3 = new File(string4).getCanonicalPath();
            }
            catch (IOException iOException) {
                return false;
            }
            if (!Globals.filesCaseSensitive()) {
                string2 = string2.toLowerCase();
                string3 = string3.toLowerCase();
            }
            if (string2.startsWith(string3)) {
                return true;
            }
        }
        return this.checkReadACL(string2);
    }

    public boolean checkWrite(String string) {
        String string2 = this.getRealPath(string);
        return this.checkWriteACL(string2);
    }

    public synchronized boolean checkRead(FileDescriptor fileDescriptor) {
        return this.getCSM().policyInClass("java.net.SocketInputStream") && fileDescriptor.valid();
    }

    public synchronized boolean checkWrite(FileDescriptor fileDescriptor) {
        return this.getCSM().policyInClass("java.net.SocketOutputStream") && fileDescriptor.valid();
    }

    public boolean checkListen(int n) {
        return n <= 0 || n >= 1024;
    }

    public boolean checkAccept(String string, int n) {
        if (n < 1024) {
            return false;
        }
        return this.checkConnect(string, n);
    }

    public boolean checkConnect(String string, int n) {
        ClassLoader classLoader = this.getCSM().policyGetLoader();
        if (classLoader instanceof sunw.hotjava.applet.AppletClassLoader) {
            return this.checkConnect(this.getCSM().getAppletHost(), string);
        }
        if (classLoader instanceof AppletClassLoader) {
            AppletClassLoader cfr_ignored_0 = (AppletClassLoader)classLoader;
            return this.checkConnect(this.getCSM().getAppletHost(), string);
        }
        return false;
    }

    public boolean checkConnect(String string, String string2, boolean bl) {
        if (string == null) {
            return true;
        }
        switch (this.getCSM().networkMode) {
            case 1: {
                return false;
            }
            case 2: {
                if (!this.testConnect(string, string2, bl)) {
                    return false;
                }
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean checkConnect(String string, String string2) {
        return this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
    }

    public boolean checkTopLevelWindow(Object object) {
        return false;
    }

    public boolean checkPackageAccess(String string) {
        int n = string.indexOf(46);
        while (true) {
            String string2;
            if (n < 0) {
                n = string.length();
            }
            if (Boolean.getBoolean("package.restrict.access." + (string2 = string.substring(0, n)))) {
                return false;
            }
            if (n == string.length()) break;
            n = string.indexOf(46, n + 1);
        }
        return true;
    }

    public boolean checkPackageDefinition(String string) {
        int n = string.indexOf(46);
        while (true) {
            String string2;
            if (n < 0) {
                n = string.length();
            }
            if (Boolean.getBoolean("package.restrict.definition." + (string2 = string.substring(0, n)))) {
                return false;
            }
            if (n == string.length()) break;
            n = string.indexOf(46, n + 1);
        }
        return true;
    }

    public boolean checkSetFactory() {
        return false;
    }

    public boolean checkMemberAccess(Class clazz, int n, int n2) {
        ClassLoader classLoader;
        return n == 0 || (classLoader = this.getCSM().policyGetLoader()) == null || n2 > 2 || classLoader == clazz.getClassLoader();
    }

    public boolean checkPrintJobAccess() {
        return false;
    }

    public boolean checkSystemClipboardAccess() {
        return false;
    }

    public boolean checkAwtEventQueueAccess() {
        return false;
    }

    public boolean checkRun() {
        return true;
    }
}

