/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import sunw.hotjava.misc.ScalingFontMetrics;
import sunw.hotjava.misc.ScalingShape;

public class ScalingGraphics
extends Graphics {
    private double scaleFactor;
    private Graphics target;
    private boolean tryToScaleFonts = false;
    private Font lastFontSet;
    private Hashtable scaledFonts;

    public ScalingGraphics(Graphics graphics, double d) {
        this.target = graphics;
        this.scaleFactor = d;
    }

    public synchronized void setTryToScaleFonts(boolean bl) {
        if (this.tryToScaleFonts == bl) {
            return;
        }
        if (bl) {
            this.scaledFonts = new Hashtable();
            this.tryToScaleFonts = bl;
            this.setFont(this.target.getFont());
            return;
        }
        this.tryToScaleFonts = bl;
        this.scaledFonts = null;
        this.setFont(this.getFont());
    }

    public boolean getTryToScaleFonts() {
        return this.tryToScaleFonts;
    }

    public Graphics create() {
        ScalingGraphics scalingGraphics = new ScalingGraphics(this.target.create(), this.scaleFactor);
        if (this.tryToScaleFonts) {
            scalingGraphics.setTryToScaleFonts(true);
        }
        return scalingGraphics;
    }

    public void translate(int n, int n2) {
        this.target.translate(this.scale(n), this.scale(n2));
    }

    public Color getColor() {
        return this.target.getColor();
    }

    public void setColor(Color color) {
        this.target.setColor(color);
    }

    public void setPaintMode() {
        this.target.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.target.setXORMode(color);
    }

    public Font getFont() {
        if (this.tryToScaleFonts && this.lastFontSet != null) {
            return this.lastFontSet;
        }
        return this.target.getFont();
    }

    public void setFont(Font font) {
        this.lastFontSet = font;
        if (this.tryToScaleFonts) {
            this.target.setFont(this.scaleFont(font));
            return;
        }
        this.target.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.tryToScaleFonts) {
            font = this.scaleFont(font);
        }
        return new ScalingFontMetrics(this.target.getFontMetrics(font), 1.0 / this.scaleFactor);
    }

    private Font scaleFont(Font font) {
        if (font == null) {
            return font;
        }
        Font font2 = (Font)this.scaledFonts.get(font);
        if (font2 != null) {
            return font2;
        }
        int n = (int)((double)font.getSize() * this.scaleFactor);
        if (n < 1) {
            n = 1;
        }
        font2 = new Font(font.getName(), font.getStyle(), n);
        this.scaledFonts.put(font, font2);
        return font2;
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = this.target.getClipBounds();
        return new Rectangle((int)(0.5 + (double)rectangle.x / this.scaleFactor), (int)(0.5 + (double)rectangle.y / this.scaleFactor), (int)(0.5 + (double)rectangle.width / this.scaleFactor), (int)(0.5 + (double)rectangle.height / this.scaleFactor));
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.target.clipRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.target.setClip(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public Shape getClip() {
        return new ScalingShape(this.target.getClip(), this.scaleFactor);
    }

    public void setClip(Shape shape) {
        this.target.setClip(new ScalingShape(shape, 1.0 / this.scaleFactor));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.copyArea(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), this.scale(n5), this.scale(n6));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.target.drawLine(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void drawTextUnderline(int n, int n2, int n3, int n4) {
        this.target.drawLine(this.scale(n), this.scale(n2) + 1, this.scale(n3), this.scale(n4) + 1);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.target.fillRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.target.drawRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.target.clearRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.drawRoundRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), this.scale(n5), this.scale(n6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.fillRoundRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), this.scale(n5), this.scale(n6));
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.target.draw3DRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), bl);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.target.fill3DRect(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), bl);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.target.drawOval(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.target.fillOval(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.drawArc(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.fillArc(this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.target.drawPolyline(this.scaleArray(nArray), this.scaleArray(nArray2), n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.target.drawPolygon(this.scaleArray(nArray), this.scaleArray(nArray2), n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.target.fillPolygon(this.scaleArray(nArray), this.scaleArray(nArray2), n);
    }

    public void drawString(String string, int n, int n2) {
        this.target.drawString(string, this.scale(n), this.scale(n2));
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.target.drawChars(cArray, n, n2, this.scale(n3), this.scale(n4));
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.target.drawBytes(byArray, n, n2, this.scale(n3), this.scale(n4));
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        int n3 = image.getWidth(imageObserver);
        int n4 = image.getHeight(imageObserver);
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        return this.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.target.drawImage(image, this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(imageObserver);
        int n4 = image.getHeight(imageObserver);
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        return this.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.target.drawImage(image, this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.target.drawImage(image, this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.target.drawImage(image, this.scale(n), this.scale(n2), this.scale(n3), this.scale(n4), n5, n6, n7, n8, color, imageObserver);
    }

    public void dispose() {
        this.target.dispose();
    }

    public void finalize() {
    }

    public String toString() {
        return String.valueOf(this.target.toString()) + ", scale factor: " + this.scaleFactor;
    }

    private int scale(int n) {
        return (int)((double)n * this.scaleFactor + 0.5);
    }

    private int[] scaleArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.scale(nArray[n]);
            ++n;
        }
        return nArray2;
    }
}

