/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.misc.CharacterEncoder;
import sunw.hotjava.misc.QPEncoder;

public class QPHeaderEncoder
extends CharacterEncoder {
    String header;
    String charset;

    public QPHeaderEncoder(String string, String string2) {
        this.header = string;
        this.charset = string2;
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        super.encodeBufferPrefix(outputStream);
        this.pStream.print(String.valueOf(this.header) + ":");
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        this.pStream.print(" =?" + this.charset + "?q?");
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println("?=");
    }

    protected int bytesPerAtom() {
        return 3;
    }

    protected int bytesPerLine() {
        int n = 76 - this.charset.length() - " =??q??=".length();
        return n;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            outputStream.write(byArray[n + n3]);
            ++n3;
        }
    }

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            inputStream.mark(1);
            int n2 = inputStream.read();
            if (n2 == -1) {
                return n;
            }
            if (n2 == 61 && n > byArray.length - 3) {
                inputStream.reset();
                return n;
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return byArray.length;
    }

    private void removeTerminations(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) >= 0) {
            if (n == 13 || n == 10) continue;
            if (n == 61) {
                int n2 = inputStream.read();
                if (n2 == -1) break;
                if (n2 == 13 || n2 == 10) continue;
                outputStream.write(n);
                outputStream.write(n2);
                continue;
            }
            outputStream.write(n);
        }
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        QPEncoder qPEncoder = new QPEncoder(true, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        qPEncoder.encodeBuffer(inputStream, byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        this.removeTerminations(byteArrayInputStream, byteArrayOutputStream2);
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        int n = byArray.length;
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream2);
        int n2 = 0;
        byte[] byArray2 = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        int n3 = 0;
        while (n3 < n) {
            n2 = this.readFully(bufferedInputStream, byArray2);
            this.encodeLinePrefix(outputStream, n2);
            int n4 = 0;
            while (n4 < n2) {
                if (n4 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outputStream, byArray2, n4, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputStream, byArray2, n4, n2 - n4);
                }
                n4 += this.bytesPerAtom();
            }
            this.encodeLineSuffix(outputStream);
            n3 += n2;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        QPEncoder qPEncoder = new QPEncoder(true, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        qPEncoder.encodeBuffer(inputStream, byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        super.encode((InputStream)bufferedInputStream, outputStream);
    }

    public static void main(String[] stringArray) {
        String string = "Usage: QPHeaderEncoder <header> <charset> <content>";
        if (stringArray.length != 3) {
            System.out.println(string);
            System.exit(1);
        }
        QPHeaderEncoder qPHeaderEncoder = new QPHeaderEncoder(stringArray[0], stringArray[1]);
        try {
            qPHeaderEncoder.encodeBuffer(stringArray[2].getBytes(), System.out);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error encoding header:");
            exception.printStackTrace();
            return;
        }
    }
}

