/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean.applets;

import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import sunw.hotjava.bean.applets.HotJavaBeanApplet;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.URLApplicationLauncher;
import sunw.hotjava.misc.URLSaver;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.UserTextButton;

public class ContentViewerUnknownApplet
extends HotJavaBeanApplet
implements URLApplicationLauncher.ErrorListener {
    URL url;
    UserTextButton save;
    UserTextButton view;
    UserTextButton application;

    public ContentViewerUnknownApplet() {
        this.setName("contentviewerunknown");
    }

    public void init() {
        super.init();
        this.setLayout(new FlowLayout());
        try {
            this.url = new URL(this.getParameter("url"));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("saveFile: bad url " + this.getParameter("url"));
        }
        this.save = new UserTextButton("viewerunknown.save");
        this.add(this.save);
        this.view = new UserTextButton("viewerunknown.view");
        this.add(this.view);
        this.application = new UserTextButton("viewerunknown.application");
        this.add(this.application);
    }

    public boolean action(Event event, Object object) {
        String string = (String)object;
        if (string.equals(this.save.getName())) {
            return this.saveFile();
        }
        if (string.equals(this.view.getName())) {
            return this.viewInBrowser();
        }
        if (string.equals(this.application.getName())) {
            return this.askForApplication();
        }
        return false;
    }

    boolean saveFile() {
        File file;
        String string = this.url.getFile();
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((file = this.askUserForFile("viewerunknown.savedialog", 1, string)) != null) {
            Frame frame = this.getEnclosingFrame();
            String string2 = file.getAbsolutePath();
            String string3 = String.valueOf(Globals.localProps.handleGetString("progressDialog.title.label", "Saving to: ")) + string2;
            URLSaver uRLSaver = new URLSaver(frame, this.url, string2, string3);
            uRLSaver.start();
        }
        return true;
    }

    boolean viewInBrowser() {
        URL uRL = null;
        try {
            uRL = new URL(this.getParameter("url"));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ContentViewerUnknownApplet bad URL: " + malformedURLException);
        }
        try {
            URL uRL2 = new URL("verbatim:" + uRL.toExternalForm());
            this.getAppletContext().showDocument(uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ContentViewerUnknownApplet view as-is exception: " + malformedURLException);
        }
        return true;
    }

    boolean askForApplication() {
        try {
            File file = this.askUserForFile("viewerunknown.getapplicationdialog", 0, "");
            if (file != null) {
                String string = file.getAbsolutePath();
                if (!file.exists()) {
                    String string2 = Globals.localProps.handleGetString("viewerunknown.appnotfound.msg", "Application not found  : ");
                    this.showErrorMessage(String.valueOf(string2) + string);
                } else {
                    try {
                        URLApplicationLauncher uRLApplicationLauncher = new URLApplicationLauncher(this.url, string);
                        uRLApplicationLauncher.addListener(this);
                        uRLApplicationLauncher.start();
                    }
                    catch (Exception exception) {
                        String string3 = Globals.localProps.handleGetString("viewerunknown.faillaunch.msg", "Could not launch: ");
                        this.showErrorMessage(String.valueOf(string3) + string);
                    }
                }
            } else {
                String string = Globals.localProps.handleGetString("viewerunknown.cancel.msg", "Canceled");
                this.showStatus(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            String string = Globals.localProps.handleGetString("viewerunknown.nonrecoverable.msg", "Could not launch, a non-recoverable error occurred.");
            this.showErrorMessage(string);
        }
        return true;
    }

    private void showErrorMessage(String string) {
        Frame frame = this.getEnclosingFrame();
        ConfirmDialog confirmDialog = new ConfirmDialog(String.valueOf(this.getName()) + ".error", frame, 1);
        confirmDialog.setPrompt(string);
        confirmDialog.show();
    }

    private void showErrorMessageFromKey(String string) {
        String string2 = Globals.localProps.handleGetString(String.valueOf(this.getName()) + "." + string + ".msg");
        this.showErrorMessage(string2);
    }

    public void launcherErrorOccurred(URLApplicationLauncher.ErrorEvent errorEvent) {
        switch (errorEvent.getId()) {
            case 2001: {
                this.showErrorMessageFromKey("file-not-found");
                return;
            }
            case 2002: {
                this.showErrorMessageFromKey("file-not-executable");
                return;
            }
        }
        this.showErrorMessageFromKey("launch-failed");
    }
}

