/*
 * Decompiled with CFR 0.152.
 */
package jspell.spellchecker;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import jspell.spellchecker.JSpellChecker;
import jspell.spellchecker.TextInfo;
import jspell.spellchecker.WordBundle;
import jspell.spellchecker.j_util;

public class JSpellError
extends Dialog
implements Runnable {
    public TextInfo textInfo;
    public TextArea text;
    public String checkWord;
    public int errorPos;
    private int xPosition;
    private int yPosition;
    public TextField wordField;
    public Button replace;
    public Label label_2;
    public Button replaceAll;
    public List suggList;
    public Button ignore;
    public Button ignoreAll;
    public Button learnButton;
    public Button stopButton;
    public JSpellChecker jsc;

    public JSpellError(Frame f, TextArea text, WordBundle wordBundle, String[] suggestions, TextInfo textInfo, int xPos, int yPos, JSpellChecker jsc) {
        super(f, "Spell Checker - Error Detected", true);
        this.text = text;
        this.checkWord = wordBundle.word;
        this.textInfo = textInfo;
        this.errorPos = wordBundle.position;
        this.jsc = jsc;
        ((Component)this).setBackground(Color.lightGray);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{7, 11, 2, 2, 14, 8, 12, 41, 14};
        int[] columnWidths = new int[]{4, 10, 115, 72, 10, 104, 8, 3};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        this.wordField = new TextField(this.checkWord, 20);
        this.add(this.wordField);
        this.replace = new Button();
        this.replace.setLabel("Replace");
        this.add(this.replace);
        this.label_2 = new Label();
        this.label_2.setFont(new Font("Helvetica", 0, 12));
        this.label_2.setText("Suggestions:");
        this.add(this.label_2);
        this.replaceAll = new Button();
        this.replaceAll.setLabel("Replace All");
        this.add(this.replaceAll);
        this.suggList = new List(4, false);
        this.suggList.setBackground(Color.white);
        if (suggestions.length > 0) {
            for (int j = 0; j < suggestions.length && suggestions[j] != null; ++j) {
                this.suggList.addItem(suggestions[j]);
            }
        }
        this.add(this.suggList);
        this.ignore = new Button();
        this.ignore.setLabel("Ignore");
        this.add(this.ignore);
        this.ignoreAll = new Button();
        this.ignoreAll.setLabel("Ignore All");
        this.add(this.ignoreAll);
        this.learnButton = new Button();
        this.learnButton.setLabel("Learn");
        this.add(this.learnButton);
        this.stopButton = new Button();
        this.stopButton.setLabel("Stop");
        this.add(this.stopButton);
        GridBagConstraints con = new GridBagConstraints();
        this.reset(con);
        con.gridx = 2;
        con.gridy = 2;
        con.gridwidth = 2;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.wordField, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.replace, con);
        this.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 2;
        con.anchor = 17;
        con.fill = 0;
        grid.setConstraints(this.label_2, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.replaceAll, con);
        this.reset(con);
        con.gridx = 2;
        con.gridy = 4;
        con.gridwidth = 2;
        con.gridheight = 4;
        con.anchor = 10;
        con.fill = 1;
        grid.setConstraints(this.suggList, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.ignore, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.ignoreAll, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 6;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.learnButton, con);
        this.reset(con);
        con.gridx = 5;
        con.gridy = 7;
        con.anchor = 10;
        con.fill = 2;
        grid.setConstraints(this.stopButton, con);
        this.setLayout(grid);
        this.pack();
        if (xPos == 0 && yPos == 0) {
            j_util.centerDialog(this, f);
            jsc.setErrPos(this.getLocation());
        } else {
            ((Component)this).setLocation(xPos, yPos);
        }
        this.xPosition = this.getLocation().x;
        this.yPosition = this.getLocation().y;
    }

    public void run() {
        this.text.select(this.errorPos, this.errorPos + this.checkWord.length());
        this.show();
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 1001: {
                if (evt.target == this.ignore) {
                    this.text.select(this.errorPos, this.errorPos);
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target == this.suggList) {
                    ((TextComponent)this.wordField).setText(this.suggList.getSelectedItem());
                    this.textInfo.curPos = this.errorPos;
                    this.textInfo.setWordsToCheck(true);
                    this.jsc.replaceSingle(this.checkWord, this.wordField.getText());
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target == this.ignoreAll) {
                    this.jsc.addIgnore(this.checkWord);
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target == this.replace) {
                    this.textInfo.curPos = this.errorPos;
                    this.textInfo.setWordsToCheck(true);
                    this.jsc.replaceSingle(this.checkWord, this.wordField.getText());
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target == this.replaceAll) {
                    this.textInfo.curPos = this.errorPos;
                    this.textInfo.setWordsToCheck(true);
                    this.jsc.replaceAll(this.checkWord, this.wordField.getText());
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target == this.learnButton) {
                    this.jsc.addLearned(this.checkWord);
                    this.jsc.resumeChecking();
                    break;
                }
                if (evt.target != this.stopButton) break;
                this.jsc.setStopped(true);
                this.jsc.resumeChecking();
                break;
            }
            case 701: {
                ((TextComponent)this.wordField).setText(this.suggList.getSelectedItem());
                break;
            }
            case 205: {
                this.jsc.setErrPos(this.getLocation());
                break;
            }
            default: {
                if (this.getLocation().x == this.xPosition && this.getLocation().y == this.yPosition) break;
                this.jsc.setErrPos(this.getLocation());
                this.xPosition = this.getLocation().x;
                this.yPosition = this.getLocation().y;
            }
        }
        return super.handleEvent(evt);
    }

    private void reset(GridBagConstraints con) {
        con.gridx = -1;
        con.gridy = -1;
        con.gridwidth = 1;
        con.gridheight = 1;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.anchor = 10;
        con.fill = 0;
        con.insets = new Insets(0, 0, 0, 0);
        con.ipadx = 0;
        con.ipady = 0;
    }
}

