/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class WordWrapValue
extends Dialog
implements KeyListener,
ActionListener {
    public boolean ret_code;
    private int value;
    private Frame parent;
    private Button okButton;
    private Button cancelButton;
    private TextField valueField;

    WordWrapValue(Frame parent, int value) {
        super(parent, "Alter the Word Wrap Value", true);
        this.parent = parent;
        this.value = value;
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 80, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.valueField = new TextField(String.valueOf("").concat(String.valueOf(this.value)));
        this.valueField.addKeyListener(this);
        this.add(this.valueField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.valueField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.cancelButton, con);
        Label label = new Label("Word Wrap Value:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.enableEvents(64L);
    }

    public int getValue() {
        return this.value;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            boolean ret_code = true;
            int num = 0;
            try {
                num = Integer.valueOf(this.valueField.getText());
            }
            catch (NumberFormatException ex) {
                MsgBox msg = new MsgBox(this, "The value specified is not valid.");
                ret_code = false;
                this.valueField.requestFocus();
            }
            if (ret_code && num < 20) {
                MsgBox msg = new MsgBox(this, "The value may not be less than 20.");
                ret_code = false;
                this.valueField.requestFocus();
            }
            if (ret_code) {
                this.value = num;
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

