/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.TabsetPanel;
import innoval.mailer.FolderField;
import innoval.mailer.FolderItem;
import innoval.mailer.JBevelPanel;
import innoval.mailer.JTextArea;
import innoval.mailer.MsgBox;
import innoval.mailer.PersonaDialog;
import innoval.mailer.Profile;
import innoval.mailer.SelectFolder;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Random;

public class Persona {
    static final int MAX = 30;
    static final int FILEHERE = 0;
    static final int FILENONE = 1;
    static final int FILEMONTH = 2;
    static final String SAVENAME = new String("Persona");
    static final String PERSONALIST = new String("PersonaList");
    static final String FROMNAME = new String("FromName");
    static final String FROMADDR = new String("FromAddress");
    static final String REPNAME = new String("ReplytoName");
    static final String REPADDR = new String("ReplytoAddress");
    static final String SIGNATURE = new String("Signature");
    static final String REPLYPREF = new String("ReplyPreface");
    static final String FORWARDPREF = new String("ForwardPreface");
    static final String COMPOSEPREF = new String("NewMessagePreface");
    static final String TAGLINEFILE = new String("TagLineFile");
    static final String DEFAULT = new String("DefaultPersona");
    static final String FILETYPE = new String("FileType");
    static final String FILEFOLDER = new String("FileFolder");
    private Frame parent;
    private jstreet root;
    private boolean deleted;
    private Profile profile;
    private Panel panel;
    private boolean defaultper;
    private int filetype;
    private PersonaDialog dlg = null;
    private String name;
    private String fromname;
    private String fromaddr;
    private String repname;
    private String repaddr;
    private String signature;
    private String taglinefile;
    private String replypref;
    private String forwardpref;
    private String composepref;
    private String filefolder;
    public Button selectButton;
    public Button selectFolder;
    private CheckboxGroup checkgroup;
    private Checkbox checkDefault;
    private Checkbox fileNone;
    private Checkbox fileMonth;
    private Checkbox fileHere;
    private FolderField fileFolder;
    private TextField textName;
    private TextField textFromname;
    private TextField textFromaddr;
    private TextField textRepname;
    private TextField textRepaddr;
    private TextField textTaglinefile;
    private JTextArea textSig;
    private JTextArea replyPref;
    private JTextArea forwardPref;
    private JTextArea composePref;

    Persona(Frame frame, jstreet parent, Profile profile, String name) {
        this.parent = frame;
        this.root = parent;
        this.profile = profile;
        this.name = name;
        this.deleted = false;
        this.init();
    }

    private void init() {
        this.defaultper = Boolean.valueOf(this.profile.ReadString(this.name, DEFAULT, "false"));
        this.fromname = this.profile.ReadString(this.name, FROMNAME, "");
        this.fromaddr = this.profile.ReadString(this.name, FROMADDR, "");
        this.repname = this.profile.ReadString(this.name, REPNAME, "");
        this.repaddr = this.profile.ReadString(this.name, REPADDR, "");
        this.signature = this.profile.ReadString(this.name, SIGNATURE, "");
        this.taglinefile = this.profile.ReadString(this.name, TAGLINEFILE, "");
        this.replypref = this.profile.ReadString(this.name, REPLYPREF, "** Reply to message from {from} on {date}\n\n");
        this.forwardpref = this.profile.ReadString(this.name, FORWARDPREF, "** Forwarding message from {from} on {date}\n\n");
        this.composepref = this.profile.ReadString(this.name, COMPOSEPREF, "");
        this.filetype = Integer.parseInt(this.profile.ReadString(this.name, FILETYPE, "0"));
        this.filefolder = this.profile.ReadString(this.name, FILEFOLDER, this.root.getDefFileFolder());
    }

    public void setDeleted(boolean val) {
        this.deleted = val;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDefault(boolean val) {
        this.defaultper = val;
        if (this.checkDefault != null) {
            this.checkDefault.setState(false);
        }
    }

    public boolean isDefault() {
        return this.defaultper;
    }

    public String getName() {
        return this.name;
    }

    public String getNewName() {
        return this.textName.getText().trim().replace(' ', '_');
    }

    public String getFromname() {
        return this.fromname;
    }

    public String getFromaddr() {
        return this.fromaddr;
    }

    public String getFrom() {
        String text = null;
        String fname = Persona.formatName(this.fromname);
        text = fname.length() > 0 ? (this.fromaddr.length() > 0 ? new String(String.valueOf(String.valueOf(String.valueOf(fname).concat(String.valueOf(" <"))).concat(String.valueOf(this.fromaddr))).concat(String.valueOf(">"))) : new String(fname)) : new String(this.fromaddr);
        return text;
    }

    public String getReplytoname() {
        return this.repname;
    }

    public String getReplytoaddr() {
        return this.repaddr;
    }

    public String getReply() {
        String text = null;
        String rname = Persona.formatName(this.repname);
        text = rname.length() > 0 ? (this.repaddr.length() > 0 ? new String(String.valueOf(String.valueOf(String.valueOf(rname).concat(String.valueOf(" <"))).concat(String.valueOf(this.repaddr))).concat(String.valueOf(">"))) : new String(rname)) : new String(this.repaddr);
        return text;
    }

    public static String formatAddress(String addr) {
        int spot = addr.indexOf(60);
        if (spot >= 0) {
            String name = new String(addr.substring(0, spot).trim());
            String trest = new String(addr.substring(spot).trim());
            addr = new String(String.valueOf(String.valueOf(Persona.formatName(name)).concat(String.valueOf(" "))).concat(String.valueOf(trest)));
        }
        return addr;
    }

    public static String formatName(String name) {
        if (name == null) {
            name = new String("");
        }
        if (name.trim().length() > 0 && name.trim().charAt(0) != '\"' && (name.indexOf(44) >= 0 || name.indexOf(46) >= 0)) {
            name = new String(String.valueOf(String.valueOf("\"").concat(String.valueOf(name.trim()))).concat(String.valueOf("\"")));
        }
        return name;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = new String(signature);
    }

    public String getTaglineFilename() {
        return this.taglinefile;
    }

    public File getTaglinefile() {
        return new File(this.taglinefile);
    }

    public String getReplyPref() {
        return this.replypref;
    }

    public String getForwardPref() {
        return this.forwardpref;
    }

    public String getComposePref() {
        return this.composepref;
    }

    public String getFolder() {
        String fldr = new String("");
        switch (this.filetype) {
            case 2: {
                fldr = new String(FolderItem.CURRENTMONTH);
                break;
            }
            case 0: {
                fldr = new String(this.filefolder);
            }
        }
        return fldr;
    }

    public void selectTagFile() {
        Object file;
        FileDialog filedialog = new FileDialog(this.parent, "Select a Tagline File", 0);
        if (this.textTaglinefile.getText().length() > 0) {
            file = new File(this.textTaglinefile.getText());
            filedialog.setDirectory(String.valueOf(((File)file).getPath()).concat(String.valueOf("\\")));
            filedialog.setFile(((File)file).getName());
        }
        filedialog.show();
        file = filedialog.getFile();
        if (file != null) {
            ((TextComponent)this.textTaglinefile).setText(String.valueOf(filedialog.getDirectory()).concat(String.valueOf(file)));
        }
    }

    public void selectFolder(Frame frame, jstreet parent) {
        SelectFolder selectfolder = new SelectFolder(frame, parent, parent.CurrentDirectory, false, true);
        selectfolder.show();
        if (selectfolder.ret_code) {
            FolderItem folder = selectfolder.getSelectedFolder();
            this.fileFolder.setText(folder.getPath().getAbsolutePath());
        }
        frame.toFront();
    }

    public static String getPersonas(Profile profile) {
        String personas = profile.ReadString(SAVENAME, PERSONALIST, "");
        return personas;
    }

    public static Persona getDefaultPersona(Frame parent, jstreet root, Profile profile) {
        Persona persona;
        block2: {
            boolean found = false;
            persona = null;
            String personas = Persona.getPersonas(profile);
            int spot = 0;
            do {
                if ((spot = personas.indexOf(44)) > 0) {
                    String text = new String(personas.substring(0, spot));
                    personas = new String(personas.substring(spot + 1));
                    persona = new Persona(parent, root, profile, text);
                    if (!persona.isDefault()) continue;
                    found = true;
                    continue;
                }
                personas = new String("");
            } while (!found && personas.length() > 0);
            if (found) break block2;
            persona = null;
        }
        return persona;
    }

    public static Persona getPersona(Frame parent, jstreet root, Profile profile, String name) {
        Persona persona;
        block2: {
            boolean found = false;
            persona = null;
            String personas = Persona.getPersonas(profile);
            int spot = 0;
            do {
                if ((spot = personas.indexOf(44)) > 0) {
                    String text = new String(personas.substring(0, spot));
                    personas = new String(personas.substring(spot + 1));
                    persona = new Persona(parent, root, profile, text);
                    if (!persona.getName().equalsIgnoreCase(name)) continue;
                    found = true;
                    continue;
                }
                personas = new String("");
            } while (!found && personas.length() > 0);
            if (found) break block2;
            persona = null;
        }
        return persona;
    }

    public void initFocus() {
        this.textFromname.requestFocus();
    }

    public TabsetPanel loadPanel(PersonaDialog dlg) {
        this.dlg = dlg;
        TabsetPanel notebook = new TabsetPanel();
        notebook.setTabsOnTop(false);
        notebook.add((Component)this.setPage1(dlg), "Main");
        notebook.add((Component)this.setPage2(), "Compose Prefaces");
        notebook.add((Component)this.setPage3(dlg), "Sent Folder");
        notebook.setSelectedIndex(0);
        return notebook;
    }

    public Panel setPage1(Dialog dlg) {
        Panel panel = new Panel();
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        int[] columnWidths = new int[]{5, 60, 5, 300, 5, 60, 5, 5};
        int[] rowHeights = new int[]{30, 80, 5, 20, 120, 5, 5, 5, 20, 5, 5};
        GridBagConstraints con = new GridBagConstraints();
        GridBagLayout grid = new GridBagLayout();
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        Panel tpanel = this.setupPanel1();
        panel.add(tpanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 8;
        grid.setConstraints(tpanel, con);
        tpanel = this.setupPanel2();
        panel.add(tpanel);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 8;
        grid.setConstraints(tpanel, con);
        Label label = new Label("Signature:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.textSig = new JTextArea("");
        this.textSig.setPreferredSize(50, 50);
        panel.add(this.textSig);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        con.gridwidth = 5;
        grid.setConstraints(this.textSig, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setPreferredSize(60, 60);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 2;
        con.gridwidth = 8;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        label = new Label("Tagline File:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        grid.setConstraints(label, con);
        this.textTaglinefile = new TextField();
        panel.add(this.textTaglinefile);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 8;
        grid.setConstraints(this.textTaglinefile, con);
        this.selectButton = new Button("Find");
        this.selectButton.addActionListener((ActionListener)((Object)dlg));
        panel.add(this.selectButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 8;
        grid.setConstraints(this.selectButton, con);
        rect = new JBevelPanel();
        rect.setPreferredSize(60, 30);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 7;
        con.gridwidth = 8;
        con.gridheight = 3;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        this.initPanel();
        return panel;
    }

    private Panel setupPanel1() {
        Panel panel = new Panel();
        double[] rowWeights = new double[]{0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        int[] columnWidths = new int[]{60, 5, 150, 5, 100, 50};
        int[] rowHeights = new int[]{5, 20, 5};
        GridBagConstraints con = new GridBagConstraints();
        GridBagLayout grid = new GridBagLayout();
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        Label label = new Label("Persona Name", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.textName = new TextField();
        panel.add(this.textName);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 1;
        grid.setConstraints(this.textName, con);
        this.checkDefault = new Checkbox("Set as default persona");
        this.checkDefault.addItemListener(this.dlg);
        panel.add(this.checkDefault);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 1;
        grid.setConstraints(this.checkDefault, con);
        panel.setLayout(grid);
        return panel;
    }

    private Panel setupPanel2() {
        Panel panel = new Panel();
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        int[] columnWidths = new int[]{5, 60, 5, 160, 60, 5, 160, 5, 5};
        int[] rowHeights = new int[]{5, 20, 20, 5, 20, 5, 5};
        GridBagConstraints con = new GridBagConstraints();
        GridBagLayout grid = new GridBagLayout();
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        Label label = new Label("From:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("Name:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(label, con);
        label = new Label("E-Mail:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        grid.setConstraints(label, con);
        this.textFromname = new TextField();
        panel.add(this.textFromname);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        grid.setConstraints(this.textFromname, con);
        this.textFromaddr = new TextField();
        panel.add(this.textFromaddr);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 4;
        grid.setConstraints(this.textFromaddr, con);
        label = new Label("Reply-To:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label("Name:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 2;
        grid.setConstraints(label, con);
        label = new Label("E-Mail:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 4;
        grid.setConstraints(label, con);
        this.textRepname = new TextField();
        panel.add(this.textRepname);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 2;
        grid.setConstraints(this.textRepname, con);
        this.textRepaddr = new TextField();
        panel.add(this.textRepaddr);
        jstreet.reset(con);
        con.gridx = 6;
        con.gridy = 4;
        grid.setConstraints(this.textRepaddr, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setPreferredSize(60, 60);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 9;
        con.gridheight = 6;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        return panel;
    }

    public void initPanel() {
        this.checkDefault.setState(this.defaultper);
        ((TextComponent)this.textName).setText(this.name);
        ((TextComponent)this.textFromname).setText(this.fromname);
        ((TextComponent)this.textFromaddr).setText(this.fromaddr);
        ((TextComponent)this.textRepname).setText(this.repname);
        ((TextComponent)this.textRepaddr).setText(this.repaddr);
        this.textSig.setText(this.signature);
        ((TextComponent)this.textTaglinefile).setText(this.taglinefile);
    }

    public Panel setPage2() {
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 80, 5, 5, 5, 20, 80, 5, 5, 5, 20, 80, 5};
        int[] columnWidths = new int[]{5, 100, 350, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Reply Preface:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.replyPref = new JTextArea("");
        panel.add(this.replyPref);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 2;
        grid.setConstraints(this.replyPref, con);
        JBevelPanel rect = new JBevelPanel();
        rect.setPreferredSize(60, 60);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 4;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        label = new Label("Forward Preface:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        grid.setConstraints(label, con);
        this.forwardPref = new JTextArea("");
        panel.add(this.forwardPref);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        con.gridwidth = 2;
        grid.setConstraints(this.forwardPref, con);
        rect = new JBevelPanel();
        rect.setPreferredSize(60, 60);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 5;
        con.gridwidth = 4;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        label = new Label("New Message Preface:");
        label.setFont(new Font("Dialog", 1, 12));
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        grid.setConstraints(label, con);
        this.composePref = new JTextArea("");
        panel.add(this.composePref);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 12;
        con.gridwidth = 2;
        grid.setConstraints(this.composePref, con);
        rect = new JBevelPanel();
        rect.setPreferredSize(60, 60);
        panel.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 10;
        con.gridwidth = 4;
        con.gridheight = 4;
        grid.setConstraints(rect, con);
        panel.setLayout(grid);
        this.replyPref.setText(this.replypref);
        this.forwardPref.setText(this.forwardpref);
        this.composePref.setText(this.composepref);
        return panel;
    }

    public Panel setPage3(Dialog dlg) {
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 30, 300, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.checkgroup = new CheckboxGroup();
        this.fileNone = new Checkbox("Do not file messages", this.checkgroup, false);
        panel.add(this.fileNone);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(this.fileNone, con);
        this.fileMonth = new Checkbox("File to current month-year folder", this.checkgroup, false);
        panel.add(this.fileMonth);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.fileMonth, con);
        this.fileHere = new Checkbox("File messages to this folder:", this.checkgroup, false);
        panel.add(this.fileHere);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(this.fileHere, con);
        this.fileFolder = new FolderField("", this.root);
        panel.add(this.fileFolder);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 5;
        grid.setConstraints(this.fileFolder, con);
        this.selectFolder = new Button("Select");
        this.selectFolder.addActionListener((ActionListener)((Object)dlg));
        panel.add(this.selectFolder);
        jstreet.reset(con);
        con.gridx = 4;
        con.gridy = 5;
        grid.setConstraints(this.selectFolder, con);
        panel.setLayout(grid);
        switch (this.filetype) {
            case 1: {
                this.fileNone.setState(true);
                break;
            }
            case 2: {
                this.fileMonth.setState(true);
                break;
            }
            default: {
                this.fileHere.setState(true);
                break;
            }
        }
        this.fileFolder.setText(this.filefolder);
        return panel;
    }

    public void deletePersona() {
        this.profile.WriteString(this.name, DEFAULT, null);
        this.profile.WriteString(this.name, FROMNAME, null);
        this.profile.WriteString(this.name, FROMADDR, null);
        this.profile.WriteString(this.name, REPNAME, null);
        this.profile.WriteString(this.name, REPADDR, null);
        this.profile.WriteString(this.name, SIGNATURE, null);
        this.profile.WriteString(this.name, TAGLINEFILE, null);
        this.profile.WriteString(this.name, REPLYPREF, null);
        this.profile.WriteString(this.name, FORWARDPREF, null);
        this.profile.WriteString(this.name, COMPOSEPREF, null);
        this.profile.WriteString(this.name, FILETYPE, null);
        this.profile.WriteString(this.name, FILEFOLDER, null);
    }

    public boolean savePersona() {
        boolean ret_code = true;
        if (this.name.compareTo(this.getNewName()) != 0) {
            this.deletePersona();
            this.name = new String(this.getNewName());
            if (this.name.length() == 0) {
                this.name = new String("Blank");
            }
        }
        this.defaultper = this.checkDefault.getState();
        this.fromname = this.textFromname.getText();
        this.fromaddr = this.textFromaddr.getText().replace('<', ' ').replace('>', ' ').trim();
        this.repname = this.textRepname.getText();
        this.repaddr = this.textRepaddr.getText().replace('<', ' ').replace('>', ' ').trim();
        this.signature = this.removeChar(this.textSig.getText(), '\r');
        this.taglinefile = this.textTaglinefile.getText();
        this.replypref = this.replyPref.getText();
        this.forwardpref = this.forwardPref.getText();
        this.composepref = this.composePref.getText();
        Checkbox check = this.checkgroup.getSelectedCheckbox();
        if (check == this.fileNone) {
            this.filetype = 1;
        } else if (check == this.fileMonth) {
            this.filetype = 2;
        } else if (check == this.fileHere) {
            this.filetype = 0;
        }
        this.filefolder = this.fileFolder.getText();
        if (this.filefolder.toLowerCase().startsWith(this.dlg.getSystemDir().toLowerCase())) {
            this.filefolder = new String(this.filefolder.substring(this.dlg.getSystemDir().length()));
        }
        if (this.fromaddr.trim().length() == 0 && this.repaddr.trim().length() == 0) {
            ret_code = false;
            MsgBox msg = new MsgBox(this.parent, "A \"From\" address or \"reply-to\" address must be specified for each persona.");
            this.textFromaddr.requestFocus();
        }
        if (ret_code) {
            this.profile.WriteString(this.name, DEFAULT, new Boolean(this.defaultper).toString());
            this.profile.WriteString(this.name, FROMNAME, this.fromname);
            this.profile.WriteString(this.name, FROMADDR, this.fromaddr);
            this.profile.WriteString(this.name, REPNAME, this.repname);
            this.profile.WriteString(this.name, REPADDR, this.repaddr);
            this.profile.WriteString(this.name, SIGNATURE, this.signature);
            this.profile.WriteString(this.name, TAGLINEFILE, this.taglinefile);
            this.profile.WriteString(this.name, REPLYPREF, this.replypref);
            this.profile.WriteString(this.name, FORWARDPREF, this.forwardpref);
            this.profile.WriteString(this.name, COMPOSEPREF, this.composepref);
            this.profile.WriteString(this.name, FILETYPE, new Integer(this.filetype).toString());
            this.profile.WriteString(this.name, FILEFOLDER, this.filefolder);
        }
        return ret_code;
    }

    public String removeChar(String text, char tchar) {
        char[] ttext = text.toCharArray();
        int cnt = 0;
        for (int i = 0; i < ttext.length; ++i) {
            if (ttext[i] == tchar) continue;
            ttext[cnt++] = ttext[i];
        }
        text = new String(ttext, 0, cnt);
        return text;
    }

    public boolean loadTaglines(Choice list) {
        boolean ret_code;
        block8: {
            ret_code = false;
            File file = this.getTaglinefile();
            String text = null;
            int cnt = 0;
            int rnum = 0;
            int hrs = 0;
            int mins = 0;
            int secs = 0;
            Calendar date = Calendar.getInstance();
            if (list.getItemCount() > 0) {
                list.removeAll();
            }
            try {
                if (!file.exists() || file.isDirectory()) break block8;
                list.addItem("<none>");
                BufferedReader in = new BufferedReader(new FileReader(file));
                do {
                    if ((text = in.readLine()) == null || text.startsWith("/*")) continue;
                    list.addItem(text);
                } while (text != null);
                in.close();
                cnt = list.getItemCount();
                if (cnt > 1) {
                    ret_code = true;
                    hrs = 1 + date.get(10);
                    mins = 1 + date.get(12);
                    secs = 1 + date.get(13);
                    Random rand = new Random();
                    rand.setSeed(--cnt * secs);
                    rnum = rand.nextInt();
                    if (rnum < 0) {
                        rnum *= -1;
                    }
                    rand.setSeed((mins + secs) * rnum);
                    rnum = rand.nextInt();
                    if (rnum < 0) {
                        rnum *= -1;
                    }
                    if ((rnum = rnum * secs % cnt) < 0) {
                        rnum *= -1;
                    }
                    list.select(rnum + 1);
                }
            }
            catch (IOException e) {
                MsgBox msgbox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
                ret_code = false;
            }
        }
        return ret_code;
    }
}

