/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import borland.jbcl.control.BevelPanel;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Message;
import innoval.mailer.AttachToolbar;
import innoval.mailer.GenPopName;
import innoval.mailer.HandleAttachFile;
import innoval.mailer.ImapMessageBrowser;
import innoval.mailer.ImapMessageTextarea;
import innoval.mailer.ImapMessageThread;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteWinText;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PreviewImapMail;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class ImapMessageText
extends Panel
implements ActionListener,
ClipboardOwner {
    static final int MSG_TEXTAREA = 0;
    static final int MSG_BROWSER = 1;
    private int style = 0;
    private PreviewImapMail frame;
    private Imap4Message msg;
    public ImapMessageThread loadthread;
    private PopupMenu popup;
    private ImapMessageTextarea textarea = null;
    private ImapMessageBrowser browser = null;
    private Label text = null;
    private AttachToolbar attachbar = null;
    private BevelPanel textPanel = null;
    private BevelPanel attachPanel = null;
    private File popfile = null;
    private File msgdir;
    private File attachdir;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private boolean formatState = true;
    private boolean decodeState = true;

    ImapMessageText(PreviewImapMail frame, File msgdir, File attachdir) {
        this.frame = frame;
        this.msgdir = msgdir;
        this.attachdir = attachdir;
        this.init();
    }

    public void setPopup(PopupMenu popup) {
        this.popup = popup;
    }

    public void setStyle(int style) {
        this.initTextWindow(style);
    }

    public int getStyle() {
        return this.style;
    }

    private void init() {
        this.textPanel = new BevelPanel();
        this.textPanel.setLayout(new BorderLayout());
        this.attachPanel = new BevelPanel();
        this.attachbar = new AttachToolbar(this.frame, this.frame.getFrameParent());
        this.attachbar.setVisible(false);
        this.attachbar.addActionListener(this);
        this.attachPanel.add("Center", this.attachbar);
        this.initTextWindow(0);
        this.setLayout(new BorderLayout());
        this.add("South", this.attachPanel);
        this.add("Center", this.textPanel);
    }

    public void initTextWindow(int val) {
        this.setVisible(false);
        if (this.style == 0 && this.textarea != null) {
            this.textPanel.remove(this.textarea);
        } else if (this.style == 1 && this.browser != null) {
            this.textPanel.remove(this.browser);
        }
        this.style = val;
        switch (this.style) {
            case 0: {
                this.textarea = this.formatState ? new ImapMessageTextarea(this.frame, this.fontSize, this.formatState, this.popup) : new ImapMessageTextarea(this.frame, this.fontSize, this.popup);
                if (this.textarea != null) {
                    if (this.browser != null) {
                        this.textPanel.removeNotify();
                        this.textPanel.addNotify();
                    }
                    this.textPanel.add("Center", this.textarea);
                    this.textarea.clear();
                    if (this.popfile == null) break;
                    this.load();
                    break;
                }
                System.out.println("Error creating message text window.");
                break;
            }
            case 1: {
                this.browser = new ImapMessageBrowser(this.frame, this.popup);
                if (this.browser != null) {
                    if (this.textarea != null) {
                        this.textPanel.removeNotify();
                        this.textPanel.addNotify();
                    }
                    this.textPanel.add("Center", this.browser);
                    this.browser.clear();
                    if (this.popfile == null) break;
                    this.load();
                    break;
                }
                System.out.println("Error creating message browser window.");
            }
        }
        this.validate();
    }

    public void setHeaderState(int val) {
        this.headerState = val;
        this.load();
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val) {
        this.fontSize = val;
        switch (this.style) {
            case 0: {
                this.textarea.setFontSize(val);
                break;
            }
            case 1: {
                this.load();
            }
        }
    }

    public void setFormatState(boolean val) {
        this.formatState = val;
        switch (this.style) {
            case 0: {
                this.setStyle(0);
                break;
            }
            case 1: {
                this.load();
            }
        }
    }

    public void setDecodeState(boolean val) {
        this.decodeState = val;
        this.load();
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd != null && cmd.equals("attach-toolbar")) {
            HandleAttachFile handleAttachFile = new HandleAttachFile((Frame)this.frame, this.frame.getFrameParent(), this.attachdir, this.attachbar.getButtonClickedTag());
        }
    }

    public void load() {
        if (this.msg != null) {
            this.load(this.msg, this.text);
        }
    }

    public void load(Imap4Message msg, Label text) {
        if (this.loadthread != null) {
            this.loadthread.setStop(true);
        }
        this.msg = msg;
        this.text = text;
        this.loadthread = new ImapMessageThread(this, text);
        this.loadthread.start();
    }

    public void clear() {
        if (this.loadthread != null) {
            this.loadthread.setStop(true);
        }
        if (this.popfile != null) {
            this.popfile.delete();
            this.popfile = null;
            NoteWinText.clearDirectory(this.attachdir);
        }
        switch (this.style) {
            case 0: {
                this.textarea.clear();
                break;
            }
            case 1: {
                this.browser.clear();
            }
        }
    }

    public void setEnabled(boolean val) {
        switch (this.style) {
            case 0: {
                this.textarea.setEnabled(val);
                break;
            }
            case 1: {
                this.browser.setEnabled(val);
            }
        }
        super.setEnabled(val);
    }

    public void loadMessage(Label text, ImapMessageThread thread) {
        String line = new String("Loading message...");
        PopFileProcedure pop = null;
        this.setVisible(false);
        if (!thread.getStop()) {
            this.popfile = new File(new GenPopName(this.msgdir.getAbsolutePath()).getName());
        }
        try {
            text.setText("Reading message...");
            if (this.popfile != null) {
                this.msg.writeMessage(this.popfile);
            }
            text.setText("Loading message...");
            NoteWinText.clearDirectory(this.attachdir);
            this.attachbar.setup(this.attachdir);
            pop = new PopFileProcedure();
            pop.setAttachDir(this.attachdir);
            pop.setHeaderState(this.headerState);
            pop.setStickyNotesOff();
            if (this.style == 1) {
                pop.setHtml(true);
            } else {
                pop.setHtml(false);
            }
            pop.setDecode(this.decodeState);
            pop.setFormat(this.formatState);
            pop.setHtmlFontSize(this.fontSize);
            if (!thread.getStop() && this.popfile != null) {
                pop.readFile(this.frame.getFrameParent(), this.popfile.getAbsolutePath());
                this.attachbar.setup(this.attachdir);
            }
            if (!thread.getStop() && this.popfile != null) {
                switch (this.style) {
                    case 0: {
                        this.textarea.setText(pop.getPopText());
                        break;
                    }
                    case 1: {
                        this.browser.setText(pop.getPopHTMLText(this.headerState));
                    }
                }
            }
            this.setVisible(true);
            this.validate();
            this.getParent().validate();
        }
        catch (Imap4Exception e) {
            MsgBox msgBox = new MsgBox(this, e.toString());
        }
        text.setText("");
        pop = null;
        if (thread.getStop() || this.frame.notelist.selected() > 1) {
            this.clear();
        }
        ((PreviewImapMail)MsgBox.findFrame(this)).enableMenu(true);
    }

    public void lostOwnership(Clipboard board, Transferable trans) {
    }

    public boolean copy() {
        boolean ret_code = false;
        String str = null;
        switch (this.style) {
            case 0: {
                str = this.textarea.getSelectedText();
                break;
            }
            case 1: {
                str = new String("");
            }
        }
        if (str != null) {
            StringSelection s = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            if (str.length() > 0) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public String getSelectedText() {
        String str = null;
        switch (this.style) {
            case 0: {
                str = this.textarea.getSelectedText();
                break;
            }
        }
        return str;
    }
}

