/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.util;

import borland.jbcl.util.FastStringBuffer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class TextFormat
extends Format {
    public static char NOT_A_CHAR = (char)65535;
    static final String TRACE = "TextFormat";
    static final byte LITERAL_CHAR = 1;
    static final byte OPTIONAL_CHAR = 2;
    static final byte PASSWORD_CHAR = 4;
    private String pattern;
    boolean rightToLeft;
    boolean injectLiterals;
    char[] litMask;
    byte[] infoMask;
    int charCount;
    int litCount;
    char fillChar;
    char replaceChar;
    boolean explicitFillChar;

    public TextFormat() {
        this.applyPattern(null);
    }

    public TextFormat(String string) {
        this();
        this.applyPattern(string);
    }

    public void setFillCharacter(char c) {
        if (c == NOT_A_CHAR) {
            this.fillChar = (char)32;
            this.explicitFillChar = false;
        } else {
            this.fillChar = c;
            this.explicitFillChar = true;
        }
    }

    public char getFillCharacter() {
        return this.explicitFillChar ? this.fillChar : NOT_A_CHAR;
    }

    public void setReplaceCharacter(char c) {
        this.replaceChar = c;
    }

    public char getReplaceCharacter() {
        return this.replaceChar;
    }

    public void setKeepLiterals(boolean bl) {
        this.injectLiterals = !bl;
    }

    public boolean getKeepLiterals() {
        return !this.injectLiterals;
    }

    public void applyPattern(String string) {
        this.pattern = string != null ? new String(string) : null;
        this.decomposePattern();
    }

    public String toPattern() {
        return this.pattern == null ? null : this.pattern.toString();
    }

    private void decomposePattern() {
        FastStringBuffer fastStringBuffer;
        this.charCount = 0;
        this.litCount = 0;
        this.rightToLeft = false;
        this.injectLiterals = false;
        this.fillChar = (char)32;
        this.explicitFillChar = false;
        this.replaceChar = '\u0000';
        this.litMask = null;
        if (this.pattern == null) {
            return;
        }
        int n = 0;
        int n2 = this.pattern.length();
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(this.pattern);
        int n3 = 0;
        char c = fastStringBuffer2.firstChar();
        while (c != '\u0000') {
            block0 : switch (c) {
                case ';': {
                    ++n;
                    c = fastStringBuffer2.offset() > n2 - 1 ? (char)'\u0000' : fastStringBuffer2.peekNextChar();
                    c = c == ';' ? (char)'\u0000' : fastStringBuffer2.nextChar();
                    if (c == '\\') {
                        c = fastStringBuffer2.parseBackSlash();
                    }
                    switch (n) {
                        case 1: {
                            if (c != '0') break block0;
                            this.injectLiterals = true;
                            break;
                        }
                        case 2: {
                            this.fillChar = c;
                            this.explicitFillChar = true;
                            break;
                        }
                        case 3: {
                            this.replaceChar = c;
                        }
                        default: {
                            fastStringBuffer2.lastChar();
                            break;
                        }
                    }
                    break;
                }
                case '!': {
                    this.rightToLeft = true;
                }
                case '<': 
                case '>': 
                case '^': 
                case '{': 
                case '}': {
                    break;
                }
                case '\'': 
                case '*': {
                    fastStringBuffer = fastStringBuffer2.parseLiteral(c, c == '\'');
                    if (c == '*') {
                        ++n3;
                        this.charCount += fastStringBuffer.length();
                        break;
                    }
                    this.litCount += fastStringBuffer.length();
                    break;
                }
                case '\\': {
                    fastStringBuffer2.parseBackSlash();
                    ++this.litCount;
                    break;
                }
                case '#': 
                case '&': 
                case '0': 
                case '9': 
                case '?': 
                case 'A': 
                case 'C': 
                case 'L': 
                case 'a': 
                case 'c': 
                case 'l': {
                    ++this.charCount;
                    break;
                }
                default: {
                    ++this.litCount;
                }
            }
            c = fastStringBuffer2.nextChar();
        }
        if (this.injectLiterals) {
            // empty if block
        }
        if (this.rightToLeft) {
            // empty if block
        }
        if (this.litCount == 0 && n3 == 0) {
            return;
        }
        int n4 = 0;
        this.litMask = new char[this.charCount + this.litCount];
        this.infoMask = new byte[this.charCount + this.litCount];
        for (int i = 0; i < this.litMask.length; ++i) {
            this.litMask[i] = NOT_A_CHAR;
            this.infoMask[i] = 0;
        }
        int n5 = 0;
        c = fastStringBuffer2.firstChar();
        while (c != '\u0000') {
            switch (c) {
                case '!': 
                case '<': 
                case '>': 
                case '^': {
                    break;
                }
                case '{': {
                    n5 = (byte)(n5 | 2);
                    break;
                }
                case '}': {
                    n5 = (byte)(n5 & 0xFFFFFFFD);
                    break;
                }
                case '*': {
                    n5 = (byte)(n5 ^ 4);
                    break;
                }
                case '\'': {
                    fastStringBuffer = fastStringBuffer2.parseLiteral(c, c == '\'');
                    System.arraycopy(fastStringBuffer.value(), 0, this.litMask, n4, fastStringBuffer.length());
                    for (int i = 0; i < fastStringBuffer.length(); ++i) {
                        this.infoMask[n4++] = 1;
                    }
                    break;
                }
                case '\\': {
                    this.infoMask[n4] = 1;
                    this.litMask[n4++] = fastStringBuffer2.parseBackSlash();
                    break;
                }
                case '0': 
                case 'A': 
                case 'L': 
                case 'c': {
                    this.infoMask[n4++] = n5;
                    break;
                }
                case '#': 
                case '&': 
                case '9': 
                case '?': 
                case 'C': 
                case 'a': 
                case 'l': {
                    this.infoMask[n4++] = (byte)(n5 & 4 | 2);
                    break;
                }
                case ';': {
                    fastStringBuffer2.lastChar();
                    break;
                }
                default: {
                    this.infoMask[n4] = 1;
                    this.litMask[n4++] = c;
                    break;
                }
            }
            c = fastStringBuffer2.nextChar();
        }
    }

    public StringBuffer format(String string, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = this.charCount + this.litCount;
        if (n == 0) {
            stringBuffer = new StringBuffer(string);
            return stringBuffer;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        stringBuffer.setLength(0);
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        if (this.rightToLeft) {
            n3 = -1;
            n5 = n2 - 1;
            n4 = n - 1;
        }
        char[] cArray2 = new char[n];
        if (this.litMask != null) {
            // empty if block
        }
        int n7 = n4;
        while (n4 >= 0 && n4 < n) {
            if (n6 <= 0) {
                if (this.isLiteral(n4)) {
                    cArray2[n7] = this.litMask[n4];
                    n7 += n3;
                } else if (this.replaceChar != '\u0000') {
                    cArray2[n7] = this.replaceChar;
                    n7 += n3;
                }
            } else if (this.isLiteral(n4)) {
                if (this.injectLiterals) {
                    cArray2[n7] = this.litMask[n4];
                    n7 += n3;
                } else if (cArray[n5] != this.litMask[n4] && (this.infoMask[n4] & 4) == 0) {
                    if (this.replaceChar != '\u0000') {
                        cArray2[n7] = this.replaceChar;
                        n7 += n3;
                    }
                } else {
                    cArray2[n7] = this.isPassword(n4) ? 42 : cArray[n5];
                    n7 += n3;
                    n5 += n3;
                    --n6;
                }
            } else {
                boolean bl = this.spotForCharacter(n4);
                if (bl && cArray[n5] == this.fillChar) {
                    if (this.replaceChar != '\u0000') {
                        cArray2[n7] = this.replaceChar;
                        n7 += n3;
                    }
                    n5 += n3;
                    --n6;
                } else {
                    char c = '\u0000';
                    if (bl && this.litMask != null) {
                        for (int i = n4 + n3; i >= 0 && i < n; i += n3) {
                            if (this.litMask[i] == NOT_A_CHAR || (this.infoMask[i] & 4) != 0) continue;
                            c = this.litMask[i];
                            break;
                        }
                    }
                    if (c != '\u0000' && cArray[n5] == c) {
                        if (this.replaceChar != '\u0000') {
                            cArray2[n7] = this.replaceChar;
                            n7 += n3;
                        }
                    } else {
                        if (this.litMask != null && (this.infoMask[n4] & 4) != 0) {
                            cArray2[n7] = 42;
                        } else {
                            cArray2[n7] = cArray[n5];
                            n5 += n3;
                        }
                        n7 += n3;
                        --n6;
                    }
                }
            }
            n4 += n3;
        }
        n4 = 0;
        if (this.rightToLeft) {
            n4 = n7;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= n) {
            n4 = n - 1;
        }
        if (this.rightToLeft) {
            n4 = n7 + 1;
            n2 = n - n7 - 1;
        } else {
            n4 = 0;
            n2 = n7;
        }
        stringBuffer.append(cArray2, n4, n2);
        return stringBuffer;
    }

    public StringBuffer parse(String string, ParsePosition parsePosition) {
        int n = this.charCount + this.litCount;
        if (n == 0) {
            return new StringBuffer(string);
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n];
        int n3 = 0;
        int n4 = 0;
        if (!this.injectLiterals || this.litCount == 0) {
            for (int i = 0; i < n; ++i) {
                char c;
                if (this.litMask != null && this.litMask[i] != NOT_A_CHAR && (this.infoMask[i] & 4) == 0) {
                    cArray2[n4++] = this.litMask[i];
                    continue;
                }
                char c2 = c = i < n2 ? cArray[i] : this.fillChar;
                if (c == this.fillChar && (c = this.replaceChar) == '\u0000') continue;
                cArray2[n4++] = c;
            }
            StringBuffer stringBuffer = new StringBuffer(n4);
            stringBuffer.append(cArray2, 0, n4);
            return stringBuffer;
        }
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        int n8 = n2;
        if (this.rightToLeft) {
            n5 = n2 - 1;
            n6 = -1;
            n4 = n - 1;
            n7 = n - 1;
        }
        while (n5 >= 0 && n5 < n2) {
            if (cArray[n5] != this.fillChar) {
                if (this.litMask[n7] == NOT_A_CHAR || (this.infoMask[n7] & 4) != 0) {
                    char c = cArray[n5];
                    --n8;
                    if (c != this.fillChar || (c = this.replaceChar) != '\u0000') {
                        cArray2[n4] = c;
                        n4 += n6;
                        ++n3;
                    }
                } else if (this.litMask[n7] != cArray[n5]) break;
            }
            n5 += n6;
            n7 += n6;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        if (this.rightToLeft) {
            stringBuffer.append(cArray2, n - n3, n3);
        } else {
            stringBuffer.append(cArray2, 0, n3);
        }
        return stringBuffer;
    }

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(object.toString(), stringBuffer, fieldPosition);
    }

    private final boolean isLiteral(int n) {
        return this.infoMask == null ? false : (n < 0 || n >= this.infoMask.length ? false : (this.infoMask[n] & 1) != 0);
    }

    private final boolean isPassword(int n) {
        return this.infoMask == null ? false : (n < 0 || n >= this.infoMask.length ? false : (this.infoMask[n] & 4) != 0);
    }

    private final boolean isOptional(int n) {
        return this.infoMask == null ? true : (n < 0 || n >= this.infoMask.length ? true : (this.infoMask[n] & 2) != 0);
    }

    private final boolean spotForCharacter(int n) {
        return this.infoMask == null ? true : (this.infoMask[n] & 1) != 0;
    }
}

