/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.util;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ItemMulticaster
implements ItemListener {
    private transient ItemListener[] listeners;

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listeners != null) {
            this.dispatch(itemEvent);
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public final void dispatch(ItemEvent itemEvent) {
        ItemListener[] itemListenerArray = this.listeners;
        if (itemListenerArray != null) {
            int n = itemListenerArray.length;
            for (int i = 0; i < n; ++i) {
                itemListenerArray[i].itemStateChanged(itemEvent);
            }
        }
    }

    public int find(ItemListener itemListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != itemListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final synchronized void add(ItemListener itemListener) {
        if (this.find(itemListener) < 0) {
            ItemListener[] itemListenerArray;
            if (this.listeners == null) {
                itemListenerArray = new ItemListener[1];
            } else {
                itemListenerArray = new ItemListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, itemListenerArray, 0, this.listeners.length);
            }
            itemListenerArray[itemListenerArray.length - 1] = itemListener;
            this.listeners = itemListenerArray;
        }
    }

    public final synchronized void remove(ItemListener itemListener) {
        int n = this.find(itemListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                ItemListener[] itemListenerArray = new ItemListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, itemListenerArray, 0, n);
                if (n < itemListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, itemListenerArray, n, itemListenerArray.length - n);
                }
                this.listeners = itemListenerArray;
            }
        }
    }
}

