/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class SizeDialog
extends JDialog {
    JComboBox list;
    JTextField input;
    JTextArea qhelp;
    String init_val;
    String init_un;
    JButton okb;
    JButton cancelb;
    Hashtable qhmap = CTemplate.lengthHelpHashtable();
    int type;
    String res;
    Action ok_a = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            SizeDialog.this.ok();
        }
    };
    Action cancel_a = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            SizeDialog.this.cancel();
        }
    };

    public SizeDialog(Frame frame) {
        this(frame, "Length", 2, null, null);
    }

    public SizeDialog(Frame frame, String string, int n) {
        this(frame, string, n, null, null);
    }

    public SizeDialog(Frame frame, String string, int n, String string2, String string3) {
        super(frame, string, true);
        this.type = n;
        this.init_val = string2;
        this.init_un = string3;
        this.setup();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createMainPane(), "Center");
        this.getContentPane().add((Component)this.createButtonPane(), "East");
        this.getRootPane().setDefaultButton(this.okb);
        this.getRootPane().registerKeyboardAction(this.cancel_a, DialogTextIn.esc, 2);
        this.setText();
    }

    public String ask() {
        this.show();
        return this.res;
    }

    void cancel() {
        this.res = null;
        this.dispose();
    }

    JPanel createButtonPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        jPanel.add(this.okb);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.cancelb);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    JPanel createListPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.input);
        jPanel.add(this.list);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    JPanel createMainPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        jPanel.add(this.createListPane());
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.qhelp);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("frame");
        SizeDialog sizeDialog = new SizeDialog((Frame)jFrame, "%", 1);
        System.out.println(sizeDialog.ask());
    }

    void ok() {
        try {
            String string = this.input.getText().trim();
            this.res = !string.equals("") ? String.valueOf(string) + this.list.getSelectedItem().toString().trim() : "";
        }
        catch (NullPointerException nullPointerException) {}
        this.dispose();
    }

    void setText() {
        try {
            String string = this.list.getSelectedItem().toString().trim().toLowerCase();
            this.qhelp.setText(this.qhmap.get(string).toString());
        }
        catch (NullPointerException nullPointerException) {
            this.qhelp.setText("Unknown unit!");
        }
    }

    private void setup() {
        this.setupButtons();
        this.setupQhelp();
        this.setupInput();
        this.setupList();
        ComponentTools.transferSize(this.list, this.input);
    }

    void setupButtons() {
        this.cancelb = new JButton("Cancel");
        this.cancelb.addActionListener(this.cancel_a);
        this.cancelb.revalidate();
        this.okb = new JButton("Ok");
        this.okb.addActionListener(this.ok_a);
        ComponentTools.transferSize(this.cancelb, this.okb);
    }

    void setupInput() {
        this.input = new DialogTextIn(4);
        this.input.setText("0");
        if (this.init_val != null) {
            this.input.setText(this.init_val);
        }
        this.input.selectAll();
        this.input.setAlignmentX(0.0f);
        DialogTextIn.popupForText(this.input);
        Keymap keymap = JTextComponent.addKeymap("superMap", this.input.getKeymap());
        keymap.removeKeyStrokeBinding(DialogTextIn.enter);
        keymap.addActionForKeyStroke(DialogTextIn.enter, this.ok_a);
        this.input.setKeymap(keymap);
        this.input.setMaximumSize(this.input.getPreferredSize());
    }

    private void setupList() {
        this.list = new JComboBox<String>(CTemplate.UNITS[this.type]);
        this.list.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeDialog.this.list.getEditor().selectAll();
                SizeDialog.this.setText();
            }
        });
        this.list.setFont(this.input.getFont());
        this.list.setMaximumSize(new Dimension(this.list.getPreferredSize().width, this.input.getMaximumSize().height));
        if (this.init_un != null) {
            this.list.setSelectedItem(this.init_un);
        }
        this.list.setEditable(true);
    }

    void setupQhelp() {
        this.qhelp = new JTextArea(4, 20);
        this.qhelp.setEditable(false);
        this.qhelp.setBackground(new Color(206, 206, 206));
        this.qhelp.setBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 255), new Color(206, 206, 206), new Color(206, 206, 206), new Color(80, 80, 80)));
        this.qhelp.setLineWrap(true);
        this.qhelp.setWrapStyleWord(true);
    }

    public void show() {
        this.pack();
        ComponentTools.setPos(this);
        this.input.requestFocus();
        super.show();
    }
}

