/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLLinker {
    public static void attachCSSToHTML(File file, File file2) throws FileFormatException, IOException {
        File[] fileArray = new File[]{file2};
        HTMLLinker.attachCSSToHTML(file, fileArray);
    }

    public static void attachCSSToHTML(File file, File[] fileArray) throws FileFormatException, IOException {
        FileLoader fileLoader = new FileLoader(file);
        fileLoader.run();
        String string = fileLoader.getData().toLowerCase().trim();
        HTMLLinker.attachCSSToHTML(new StringBuffer(string), fileArray);
    }

    public static void attachCSSToHTML(StringBuffer stringBuffer, File file) throws FileFormatException {
        File[] fileArray = new File[]{file};
        HTMLLinker.attachCSSToHTML(stringBuffer, fileArray);
    }

    public static void attachCSSToHTML(StringBuffer stringBuffer, String string) throws FileFormatException {
        String[] stringArray = new String[]{string};
        HTMLLinker.attachCSSToHTML(stringBuffer, stringArray);
    }

    public static void attachCSSToHTML(StringBuffer stringBuffer, File[] fileArray) throws FileFormatException {
        String[] stringArray = new String[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            stringArray[n] = HTMLLinker.fileToUrl(fileArray[n]);
            ++n;
        }
        HTMLLinker.attachCSSToHTML(stringBuffer, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void attachCSSToHTML(StringBuffer stringBuffer, String[] stringArray) throws FileFormatException {
        StringBuffer stringBuffer2 = stringBuffer;
        int n = 0;
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            try {
                stringBuffer3.append("\n<link rel=stylesheet type=\"text/css\" href=\"" + stringArray[n3] + "\">");
            }
            catch (NullPointerException nullPointerException) {}
            ++n3;
        }
        Bounds bounds = HTMLUtils.tagLocation(stringBuffer2.toString(), "head");
        if (bounds.right == -1) {
            Bounds bounds2 = HTMLUtils.tagLocation(stringBuffer2.toString(), "html");
            if (bounds2.right == -1) throw new FileFormatException("Selected file does not contains <HTML> tag");
            stringBuffer3 = new StringBuffer(HTMLLinker.wrapInToTag(stringBuffer3.toString(), "head"));
            n = bounds2.right;
        } else {
            n = bounds.right;
        }
        stringBuffer2.insert(n + 1, (Object)stringBuffer3);
    }

    public static String fileToUrl(File file) {
        String string = file.getAbsolutePath();
        return string.toString();
    }

    public static Vector importCSSElementsFromHTML(String string) throws FileFormatException {
        Vector vector = new Vector();
        String string2 = HTMLLinker.importCSSFromHTML(string);
        if (string2 != null) {
            vector = CParser.getAllCElements(string2);
        }
        return vector;
    }

    public static String importCSSFromHTML(String string) throws FileFormatException {
        String string2 = string;
        String string3 = null;
        Bounds bounds = HTMLUtils.tagLocation(string2, "style", HTMLTag.OPEN);
        if (bounds.right != -1) {
            Bounds bounds2 = HTMLUtils.tagLocation(string2, "style", HTMLTag.CLOSE, bounds.right);
            if (bounds2.left != -1) {
                string3 = string2.substring(bounds.right + 1, bounds2.left);
                int n = string3.indexOf("<!--");
                int n2 = string3.indexOf("-->");
                if (n != -1 && n2 != -1) {
                    string3 = string3.substring(n + 4, n2);
                }
            }
        } else {
            Bounds bounds3 = HTMLUtils.tagLocation(string2.toString(), "html", HTMLTag.OPEN);
            if (bounds3.right == -1) {
                throw new FileFormatException("Selected file do not contains <HTML> tag");
            }
        }
        return string3;
    }

    public static void insertCSSToHTML(StringBuffer stringBuffer, String string) throws FileFormatException {
        HTMLLinker.insertCSSToHTML(stringBuffer, string, false);
    }

    public static void insertCSSToHTML(StringBuffer stringBuffer, String string, boolean bl) throws FileFormatException {
        int n = 0;
        String string2 = "\n<!--\n" + string + "-->\n";
        StringBuffer stringBuffer2 = stringBuffer;
        Bounds bounds = HTMLUtils.tagLocation(stringBuffer2.toString(), "style", HTMLTag.OPEN, n);
        if (bounds.right == -1) {
            Bounds bounds2 = HTMLUtils.tagLocation(stringBuffer2.toString(), "head", HTMLTag.OPEN, n);
            if (bounds2.right == -1) {
                Bounds bounds3 = HTMLUtils.tagLocation(stringBuffer2.toString(), "html", HTMLTag.OPEN, n);
                if (bounds3.right == -1) {
                    throw new FileFormatException("Selected file do not contains <HTML> tag");
                }
                string2 = HTMLLinker.wrapInToTag(string2, "style", "type=\"text/css\"");
                string2 = HTMLLinker.wrapInToTag(string2, "head");
                n = bounds3.right;
            } else {
                string2 = HTMLLinker.wrapInToTag(string2, "style", "type=\"text/css\"");
                n = bounds2.right;
            }
        } else {
            n = bounds.right;
            if (bl) {
                Bounds bounds4 = HTMLUtils.tagLocation(stringBuffer2.toString(), "style", HTMLTag.CLOSE, n);
                String string3 = stringBuffer2.toString().substring(bounds4.left);
                stringBuffer2.setLength(n + 1);
                stringBuffer2.append(string3);
            }
        }
        stringBuffer2.insert(n + 1, string2);
    }

    public static String[] listLinkedFiles(File file) throws IOException {
        FileLoader fileLoader = new FileLoader(file);
        fileLoader.run();
        String string = fileLoader.getData().toLowerCase().trim();
        return HTMLLinker.listLinkedFiles(string);
    }

    public static String[] listLinkedFiles(String string) {
        Object object;
        String string2 = string;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n != -1) {
            Bounds bounds = HTMLUtils.tagLocation(string2, "link", HTMLTag.OPEN, n);
            if (bounds.left != -1 && bounds.right != -1) {
                object = HTMLUtils.parseString(string2.substring(bounds.left + 1, bounds.right));
                try {
                    vector.addElement(new String(((Hashtable)object).get("href").toString().toLowerCase()));
                }
                catch (NullPointerException nullPointerException) {}
            }
            n = bounds.right;
        }
        int n2 = vector.size();
        object = new String[n2];
        vector.copyInto((Object[])object);
        return (String[])object;
    }

    public static void main(String[] stringArray) {
    }

    public static String wrapInToTag(String string, String string2) {
        return HTMLLinker.wrapInToTag(string, string2, null);
    }

    public static String wrapInToTag(String string, String string2, String string3) {
        if (string3 != null) {
            return "<" + string2 + " " + string3 + ">" + string + "</" + string2 + ">";
        }
        return "<" + string2 + ">" + string + "</" + string2 + ">";
    }
}

