/* EmbeddedFigDemo.java - minimal jfig embedding demonstration */

package jfig.gui;

import jfig.objects.*;
import jfig.utils.*;
import jfig.canvas.*;

import java.awt.*;
import java.awt.event.*;
import java.util.Enumeration;
import javax.swing.*;

public class EmbeddedFigDemo {
  JFrame          frame;         // your main application window
  JButton         loadButton;    // your GUI components
  JButton         addButton;

  FigCanvas       objectCanvas;  // component to display a FIG drawing
  FigObjectList   objectList;
  FigAttribs      attribs;
  FigParser       parser;


  public void createFigCanvas() {
    attribs      = new FigAttribs();     // required to initalize jfig
    objectList   = new FigObjectList();  // stores and manages FIG objects
    objectCanvas = new FigSwingCanvas(); // the canvas and some options:
    objectCanvas.showRulers( true );
    objectCanvas.getTrafo().setGridMode( FigTrafo2D.MEDIUM_GRID );
    objectCanvas.getTrafo().setSnapRelative( FigTrafo2D.COARSE_SNAP );
    objectCanvas.setObjectEnumerator( new FigEnumerator() );
  }

  class FigEnumerator implements FigDrawableEnumerator {
    public Enumeration getDrawableObjects() { return objectList.elements(); }
    public FigDrawable getTmpObject() { return null; }
  }


  public void createAndShowGUI() {
    frame = new JFrame( "embedded FIG viewer demonstration" );
    loadButton = new JButton( "load next file" );
    addButton  = new JButton( "add random rectangle" );
    JPanel buttonPanel = new JPanel();
    buttonPanel.add( loadButton );
    buttonPanel.add( addButton );
    frame.getContentPane().add( "Center", objectCanvas.getComponent() );
    frame.getContentPane().add( "South",  buttonPanel );
    frame.setSize( 600, 400 );
    frame.show();
  }

  public void parseFigFile( String filename ) {
    try {  
      objectList.deleteAll();
      parser = new FigParser();
      parser.setObjectPainter( objectCanvas );
      parser.parse_fig_file_not_threaded( 
        new java.io.FileInputStream( filename ),
        true, false, false, // toplevel, inside nested compound, merge
        attribs, objectCanvas.getTrafo(), objectList 
      );
      objectCanvas.doZoomFit();
    }
    catch( Exception e ) { System.out.println( e ); }
  }



  public void addDemoCallbacks() {
    loadButton.addActionListener( new ActionListener() {
      String names[] = { "welcome.fig", "gold.fig", "watch.fig" };
      int    index = 0;

      public void actionPerformed( ActionEvent evt ) {
        index = (index+1) % names.length;
        parseFigFile( "examples/" + names[index] );
      }
    });

    addButton.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        FigRectangle tmp = new FigRectangle();
        Point[] pp = new Point[2];
        pp[0] = getRandomPoint();
        pp[1] = getRandomPoint();
        tmp.setPoints( pp );
        tmp.setTrafo( objectCanvas.getTrafo() );
        tmp.setLineStyle( FigAttribs.DASHED_LINE );
        tmp.setLineWidth( 2 ); // in pixels
        tmp.setLineColor( Color.blue );
        tmp.rebuild();
        objectList.insert( tmp );
        objectCanvas.doFullRedraw();
      }
    });
  }

  Point getRandomPoint() { // at 2400 dpi resolution: 2400=1 inch
    return new Point(  2400+(int)(9600*Math.random()),
                       2400+(int)(9600*Math.random()) );
  }
  


  public static void main( String argv[] ) {
    EmbeddedFigDemo fd = new EmbeddedFigDemo();
    fd.createFigCanvas();
    fd.createAndShowGUI();
    fd.parseFigFile( "examples/welcome.fig" );   // hard-coded
    fd.addDemoCallbacks();
  }
}
