/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.BZip2Constants;
import installer.CRC;
import java.io.IOException;
import java.io.InputStream;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_unzftab = new int[256];
    private int[][] m_limit = new int[6][258];
    private int[][] m_base = new int[6][258];
    private int[][] m_perm = new int[6][258];
    private int[] m_minLens = new int[6];
    private boolean m_streamEnd;
    private int m_currentChar = -1;
    private int m_currentState = 1;
    private int m_rNToGo;
    private int m_rTPos;
    private int m_tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private InputStream m_input;
    private int m_computedBlockCRC;
    private int m_computedCombinedCRC;
    private int m_last;
    private char[] m_ll8;
    private int m_nInUse;
    private int m_origPtr;
    private int m_storedBlockCRC;
    private int m_storedCombinedCRC;
    private int[] m_tt;

    public CBZip2InputStream(InputStream inputStream) {
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    public int read() {
        if (this.m_streamEnd) {
            return -1;
        }
        int n = this.m_currentChar;
        switch (this.m_currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private void setDecompressStructureSizes(int n) {
        if (0 > n || n > 9 || 0 > this.m_blockSize100k || this.m_blockSize100k > 9) {
            // empty if block
        }
        this.m_blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.m_ll8 = new char[n2];
        this.m_tt = new int[n2];
    }

    private void setupBlock() {
        int[] nArray = new int[257];
        nArray[0] = 0;
        int n = 1;
        while (n <= 256) {
            nArray[n] = this.m_unzftab[n - 1];
            ++n;
        }
        int n2 = 1;
        while (n2 <= 256) {
            int n3 = n2;
            nArray[n3] = nArray[n3] + nArray[n2 - 1];
            ++n2;
        }
        int n4 = 0;
        while (n4 <= this.m_last) {
            char c = this.m_ll8[n4];
            this.m_tt[nArray[c]] = n4++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.m_tPos = this.m_tt[this.m_origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.m_blockRandomised) {
            this.m_rNToGo = 0;
            this.m_rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 6;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                this.m_currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.m_currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.m_last) {
            this.chPrev = this.ch2;
            this.ch2 = this.m_ll8[this.m_tPos];
            this.m_tPos = this.m_tt[this.m_tPos];
            if (this.m_rNToGo == 0) {
                this.m_rNToGo = BZip2Constants.RAND_NUMS[this.m_rTPos];
                ++this.m_rTPos;
                if (this.m_rTPos == 512) {
                    this.m_rTPos = 0;
                }
            }
            --this.m_rNToGo;
            this.ch2 ^= this.m_rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.m_currentChar = this.ch2;
            this.m_currentState = 3;
            this.m_crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.m_currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.m_ll8[this.m_tPos];
                this.m_tPos = this.m_tt[this.m_tPos];
                if (this.m_rNToGo == 0) {
                    this.m_rNToGo = BZip2Constants.RAND_NUMS[this.m_rTPos];
                    ++this.m_rTPos;
                    if (this.m_rTPos == 512) {
                        this.m_rTPos = 0;
                    }
                }
                --this.m_rNToGo;
                this.z = (char)(this.z ^ (this.m_rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.m_currentState = 4;
                this.setupRandPartC();
            } else {
                this.m_currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.m_currentChar = this.ch2;
            this.m_crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.m_currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int n;
        char c;
        char c2;
        int n2 = 100000 * this.m_blockSize100k;
        this.m_origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int n3 = this.m_nInUse + 1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= 255) {
            this.m_unzftab[n6] = 0;
            ++n6;
        }
        char[] cArray = new char[256];
        int n7 = 0;
        while (n7 <= 255) {
            cArray[n7] = (char)n7;
            ++n7;
        }
        this.m_last = -1;
        n5 = 49;
        char c3 = this.m_selector[++n4];
        int n8 = this.m_minLens[c3];
        int n9 = this.bsR(n8);
        while (n9 > this.m_limit[c3][n8]) {
            ++n8;
            while (this.m_bsLive < 1) {
                c2 = '\u0000';
                try {
                    c2 = (char)this.m_input.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (c2 == '\uffffffff') {
                    CBZip2InputStream.compressedStreamEOF();
                }
                c = c2;
                this.m_bsBuff = this.m_bsBuff << 8 | c & 0xFF;
                this.m_bsLive += 8;
            }
            n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
            --this.m_bsLive;
            n9 = n9 << 1 | n;
        }
        int n10 = this.m_perm[c3][n9 - this.m_base[c3][n8]];
        while (n10 != n3) {
            if (n10 == 0 || n10 == 1) {
                c2 = (char)-1;
                int n11 = 1;
                do {
                    c2 = n10 == 0 ? (char)(c2 + 1 * n11) : (char)(c2 + 2 * n11);
                    n11 *= 2;
                    if (n5 == 0) {
                        ++n4;
                        n5 = 50;
                    }
                    --n5;
                    c3 = this.m_selector[n4];
                    n8 = this.m_minLens[c3];
                    n9 = this.bsR(n8);
                    while (n9 > this.m_limit[c3][n8]) {
                        ++n8;
                        while (this.m_bsLive < 1) {
                            char c4 = '\u0000';
                            try {
                                c4 = (char)this.m_input.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (c4 == '\uffffffff') {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            char c5 = c4;
                            this.m_bsBuff = this.m_bsBuff << 8 | c5 & 0xFF;
                            this.m_bsLive += 8;
                        }
                        n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                        --this.m_bsLive;
                        n9 = n9 << 1 | n;
                    }
                } while ((n10 = this.m_perm[c3][n9 - this.m_base[c3][n8]]) == 0 || n10 == 1);
                c2 = (char)(c2 + 1);
                char c6 = c = this.m_seqToUnseq[cArray[0]];
                this.m_unzftab[c6] = this.m_unzftab[c6] + c2;
                while (c2 > '\u0000') {
                    ++this.m_last;
                    this.m_ll8[this.m_last] = c;
                    c2 = (char)(c2 - 1);
                }
                if (this.m_last < n2) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.m_last;
            if (this.m_last >= n2) {
                CBZip2InputStream.blockOverrun();
            }
            c = cArray[n10 - 1];
            char c7 = this.m_seqToUnseq[c];
            this.m_unzftab[c7] = this.m_unzftab[c7] + 1;
            this.m_ll8[this.m_last] = this.m_seqToUnseq[c];
            c2 = (char)(n10 - 1);
            while (c2 > '\u0003') {
                cArray[c2] = cArray[c2 - '\u0001'];
                cArray[c2 - '\u0001'] = cArray[c2 - 2];
                cArray[c2 - 2] = cArray[c2 - 3];
                cArray[c2 - 3] = cArray[c2 - 4];
                c2 = (char)(c2 - 4);
            }
            while (c2 > '\u0000') {
                cArray[c2] = cArray[c2 - '\u0001'];
                c2 = (char)(c2 - 1);
            }
            cArray[0] = c;
            if (n5 == 0) {
                ++n4;
                n5 = 50;
            }
            --n5;
            c3 = this.m_selector[n4];
            n8 = this.m_minLens[c3];
            n9 = this.bsR(n8);
            while (n9 > this.m_limit[c3][n8]) {
                ++n8;
                while (this.m_bsLive < 1) {
                    char c8 = '\u0000';
                    try {
                        c8 = (char)this.m_input.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.m_bsBuff = this.m_bsBuff << 8 | c8 & 0xFF;
                    this.m_bsLive += 8;
                }
                n = this.m_bsBuff >> this.m_bsLive - 1 & 1;
                --this.m_bsLive;
                n9 = n9 << 1 | n;
            }
            n10 = this.m_perm[c3][n9 - this.m_base[c3][n8]];
        }
    }

    private void bsFinishedWithStream() {
        this.m_input = null;
    }

    private int readVariableSizedInt(int n) {
        return this.bsR(n);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private int bsR(int n) {
        char c;
        while (this.m_bsLive < n) {
            c = '\u0000';
            try {
                c = (char)this.m_input.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (c == '\uffffffff') {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.m_bsBuff = this.m_bsBuff << 8 | c & 0xFF;
            this.m_bsLive += 8;
        }
        c = (char)(this.m_bsBuff >> this.m_bsLive - n & (1 << n) - 1);
        this.m_bsLive -= n;
        return c;
    }

    private void bsSetStream(InputStream inputStream) {
        this.m_input = inputStream;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void complete() {
        this.m_storedCombinedCRC = this.readInt();
        if (this.m_storedCombinedCRC != this.m_computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.m_streamEnd = true;
    }

    private void endBlock() {
        this.m_computedBlockCRC = this.m_crc.getFinalCRC();
        if (this.m_storedBlockCRC != this.m_computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.m_computedCombinedCRC = this.m_computedCombinedCRC << 1 | this.m_computedCombinedCRC >>> 31;
        this.m_computedCombinedCRC ^= this.m_computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n;
        while (n6 <= n2) {
            n4 = 0;
            while (n4 < n3) {
                if (cArray[n4] == n6) {
                    nArray3[n5] = n4;
                    ++n5;
                }
                ++n4;
            }
            ++n6;
        }
        n4 = 0;
        while (n4 < 23) {
            nArray2[n4] = 0;
            ++n4;
        }
        int n7 = 0;
        while (n7 < n3) {
            int n8 = cArray[n7] + '\u0001';
            nArray2[n8] = nArray2[n8] + 1;
            ++n7;
        }
        int n9 = 1;
        while (n9 < 23) {
            int n10 = n9;
            nArray2[n10] = nArray2[n10] + nArray2[n9 - 1];
            ++n9;
        }
        int n11 = 0;
        while (n11 < 23) {
            nArray[n11] = 0;
            ++n11;
        }
        int n12 = 0;
        int n13 = n;
        while (n13 <= n2) {
            nArray[n13] = (n12 += nArray2[n13 + 1] - nArray2[n13]) - 1;
            n12 <<= 1;
            ++n13;
        }
        int n14 = n + 1;
        while (n14 <= n2) {
            nArray2[n14] = (nArray[n14 - 1] + 1 << 1) - nArray2[n14];
            ++n14;
        }
    }

    private void initBlock() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        char c3 = this.readUnsignedChar();
        char c4 = this.readUnsignedChar();
        char c5 = this.readUnsignedChar();
        char c6 = this.readUnsignedChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.m_streamEnd = true;
            return;
        }
        this.m_storedBlockCRC = this.readInt();
        this.m_blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.m_crc.initialiseCRC();
        this.m_currentState = 1;
    }

    private void initialize() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.m_streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.m_computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        int n = 0;
        while (n < 256) {
            if (this.m_inUse[n]) {
                this.m_seqToUnseq[this.m_nInUse] = (char)n;
                this.m_unseqToSeq[n] = (char)this.m_nInUse;
                ++this.m_nInUse;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recvDecodingTables() {
        this.buildInUseTable();
        this.makeMaps();
        var1_1 = this.m_nInUse + 2;
        var2_2 = this.bsR(3);
        var3_3 = this.bsR(15);
        var4_4 = 0;
        while (var4_4 < var3_3) {
            var5_5 = 0;
            while (this.bsR(1) == 1) {
                ++var5_5;
            }
            this.m_selectorMtf[var4_4] = (char)var5_5;
            ++var4_4;
        }
        var5_6 = new char[6];
        var6_7 = 0;
        while (var6_7 < var2_2) {
            var5_6[var6_7] = var6_7;
            var6_7 = (char)(var6_7 + 1);
        }
        var7_8 = 0;
        while (var7_8 < var3_3) {
            var8_9 = this.m_selectorMtf[var7_8];
            var9_11 = var5_6[var8_9];
            while (var8_9 > 0) {
                var5_6[var8_9] = var5_6[var8_9 - '\u0001'];
                --var8_9;
            }
            var5_6[0] = var9_11;
            this.m_selector[var7_8] = var9_11;
            ++var7_8;
        }
        var8_10 = new char[6][258];
        var9_11 = 0;
        while (var9_11 < var2_2) {
            var10_12 = this.bsR(5);
            var11_13 = 0;
            ** GOTO lbl44
            {
                var10_12 = this.bsR(1) == 0 ? ++var10_12 : --var10_12;
                do {
                    if (this.bsR(1) == 1) continue block6;
                    var8_10[var9_11][var11_13] = (char)var10_12;
                    ++var11_13;
lbl44:
                    // 2 sources

                } while (var11_13 < var1_1);
            }
            ++var9_11;
        }
        var10_12 = 0;
        while (var10_12 < var2_2) {
            var11_13 = 32;
            var12_14 = '\u0000';
            var13_15 = 0;
            while (var13_15 < var1_1) {
                if (var8_10[var10_12][var13_15] > var12_14) {
                    var12_14 = var8_10[var10_12][var13_15];
                }
                if (var8_10[var10_12][var13_15] < var11_13) {
                    var11_13 = var8_10[var10_12][var13_15];
                }
                ++var13_15;
            }
            this.hbCreateDecodeTables(this.m_limit[var10_12], this.m_base[var10_12], this.m_perm[var10_12], var8_10[var10_12], var11_13, var12_14, var1_1);
            this.m_minLens[var10_12] = var11_13;
            ++var10_12;
        }
    }

    private void buildInUseTable() {
        boolean[] blArray = new boolean[16];
        int n = 0;
        while (n < 16) {
            blArray[n] = this.bsR(1) == 1;
            ++n;
        }
        int n2 = 0;
        while (n2 < 256) {
            this.m_inUse[n2] = false;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 16) {
            if (blArray[n3]) {
                int n4 = 0;
                while (n4 < 16) {
                    if (this.bsR(1) == 1) {
                        this.m_inUse[n3 * 16 + n4] = true;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
    }
}

