/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.util;

/**
 * The Class UnexpectedException.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class UnexpectedException extends RuntimeException {
  private Throwable         _value;

  /** UID */
  private static final long serialVersionUID = -3365993707889312527L;

  /**
   * Instantiates a new unexpected exception.
   *
   * @param value the value
   */
  public UnexpectedException(Throwable value) {
    super(value.toString());
    _value = value;
  }

  /**
   * Instantiates a new unexpected exception.
   *
   * @param value the value
   * @param msg the msg
   */
  public UnexpectedException(Throwable value, String msg) {
    super(msg + ": " + value.toString()); //$NON-NLS-1$
    _value = value;
  }

  /**
   * Instantiates a new unexpected exception.
   */
  public UnexpectedException() {
    this(new RuntimeException("Unreachable point in code has been reached!")); //$NON-NLS-1$
  }

  /**
   * Instantiates a new unexpected exception.
   *
   * @param msg the msg
   */
  public UnexpectedException(String msg) {
    this(new RuntimeException(msg));
  }

  /**
   * Gets the cause.
   *
   * @return the cause
   * @see java.lang.Throwable#getCause()
   */
  @Override
  public Throwable getCause() {
    return _value;
  }

}
