/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import javax.swing.SwingConstants;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;

import jnpad.GUIUtilities;
import jnpad.ui.ColorUtilities;

/**
 * The Class JNPadScrollButton.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class JNPadScrollButton extends MetalScrollButton {
  private Color             highlight;
  private Color             shadow;

  /** UID */
  private static final long serialVersionUID = -1797233002398952045L;

  /**
   * 
   * @param direction int
   * @param width int
   * @param freeStanding boolean
   */
  public JNPadScrollButton(int direction, int width, boolean freeStanding) {
    super(direction, width, freeStanding);
  }

  /**
   * 
   * @param g Graphics
   */
  @Override
  public void paint(Graphics g) {
    super.paint(g);

    Rectangle rec = new Rectangle(0, 0, getWidth(), getHeight());

    GradientPaint grad;

    switch (getDirection()) {
      case EAST:
      case WEST:
        grad = GUIUtilities.getGradientPaint(highlight(),
                                             shadow(),
                                             SwingConstants.VERTICAL,
                                             rec.x,
                                             rec.y,
                                             rec.width,
                                             rec.height);
        break;
      default:
        grad = GUIUtilities.getGradientPaint(highlight(),
                                             shadow(),
                                             SwingConstants.HORIZONTAL,
                                             rec.x,
                                             rec.y,
                                             rec.width,
                                             rec.height);
        break;
    }

    Graphics2D g2D = (Graphics2D) g;
    g2D.setPaint(grad);
    g2D.fillRect(rec.x, rec.y, rec.width, rec.height);
  }

  /**
   * 
   * @return Color
   */
  private Color highlight() {
    if (highlight == null)
      highlight = ColorUtilities.withAlpha(ColorUtilities.getColor_1_3(MetalLookAndFeel.getControlHighlight(), Color.WHITE), 64);
    return highlight;
  }

  /**
   * 
   * @return Color
   */
  private Color shadow() {
    if (shadow == null)
      shadow = ColorUtilities.withAlpha(ColorUtilities.getColor_1_3(MetalLookAndFeel.getControlDarkShadow(), Color.BLACK), 64);
    return shadow;
  }

}
