/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

/**
 * The Interface Roundable.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface Roundable {
  /**
   * Gets the arc width.
   *
   * @return the arc width
   */
  double getArcWidth();

  /**
   * Gets the arc height.
   *
   * @return the arc height
   */
  double getArcHeight();

  /**
   * Sets the arc width.
   *
   * @param arcWidth the new arc width
   */
  void setArcWidth(double arcWidth);

  /**
   * Sets the arc height.
   *
   * @param arcHeight the new arc height
   */
  void setArcHeight(double arcHeight);

  /**
   * Sets the arcs.
   *
   * @param arcWidth the arc width
   * @param arcHeight the arc height
   */
  void setArcs(double arcWidth, double arcHeight);
}
