/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Graphics;
import java.awt.event.MouseEvent;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;

import jnpad.GUIUtilities;
import jnpad.action.JNPadAction;
import jnpad.ui.status.StatusDisplayable;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadRadioButtonMenuItem extends JRadioButtonMenuItem {
  private String            _description;
  private boolean           _descriptionSet;
  private StatusDisplayable _displayable;

  /** UID */
  private static final long serialVersionUID = -2344486457780612910L;

  /**
   *
   */
  public JNPadRadioButtonMenuItem() {
    //empty
  }

  /**
   * 
   * @param text String
   */
  public JNPadRadioButtonMenuItem(String text) {
    super(text);
  }

  /**
   * 
   * @param text String
   * @param b boolean
   */
  public JNPadRadioButtonMenuItem(String text, boolean b) {
    super(text, b);
  }

  /**
   * 
   * @param icon Icon
   */
  public JNPadRadioButtonMenuItem(Icon icon) {
    super(icon);
  }

  /**
   * 
   * @param icon Icon
   * @param b boolean
   */
  public JNPadRadioButtonMenuItem(Icon icon, boolean b) {
    super(icon, b);
  }

  /**
   * 
   * @param text String
   * @param icon Icon
   */
  public JNPadRadioButtonMenuItem(String text, Icon icon) {
    super(text, icon);
  }

  /**
   * 
   * @param text String
   * @param icon Icon
   * @param b boolean
   */
  public JNPadRadioButtonMenuItem(String text, Icon icon, boolean b) {
    super(text, icon, b);
  }

  /**
   * 
   * @param a Action
   */
  public JNPadRadioButtonMenuItem(Action a) {
    this(a, null);
  }

  /**
   * 
   * @param a Action
   * @param group ButtonGroup
   */
  public JNPadRadioButtonMenuItem(Action a, ButtonGroup group) {
    super(a);
    if (a instanceof JNPadAction) {
      setText(((JNPadAction) a).getLabel());
      setDescription(((JNPadAction) a).getDescription());
      addItemListener((JNPadAction) a);
    }
    if (group != null) {
      group.add(this);
    }
  }
  
  /**
   * 
   * @param description String
   */
  public void setDescription(String description) {
    _description = description;
  }

  /**
   * 
   * @return String
   */
  public String getDescription() {
    return _description;
  }

  /**
   * 
   * @param displayable StatusDisplayable
   */
  public void setStatusDisplayable(StatusDisplayable displayable) {
    _displayable = displayable;
  }

  /**
   * 
   * @return StatusDisplayable
   */
  public StatusDisplayable getStatusDisplayable() {
    return _displayable;
  }

  /**
   * 
   * @param e MouseEvent
   * @return StatusDisplayable
   */
  private StatusDisplayable getStatusDisplayable(MouseEvent e) {
    if (_displayable == null) {
      _displayable = GUIUtilities.getJNPadFrame(e);
    }
    return _displayable;
  }

  /**
   * 
   * @param e MouseEvent
   */
  @Override
  protected void processMouseEvent(MouseEvent e) {
    if (_description != null) {
      switch (e.getID()) {
        case MouseEvent.MOUSE_ENTERED:
          getStatusDisplayable(e).setStatus(_description);
          _descriptionSet = true;
          break;
        case MouseEvent.MOUSE_EXITED:
        case MouseEvent.MOUSE_RELEASED:
          if (_descriptionSet) {
            getStatusDisplayable(e).clearStatus();
            _descriptionSet = false;
          }
          break;
        default: //Keep FindBugs happy
          break;
      }
    }
    super.processMouseEvent(e);
  }

  /**
   * 
   * @param g Graphics
   */
  @Override
  protected void paintComponent(Graphics g) {
    GUIUtilities.setRenderingHints(g);
    super.paintComponent(g);
  }
  
}
