/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.Serializable;

import jnpad.JNPadBundle;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class FontChooser implements Serializable {
  private Window            window;
  private String            title;
  private boolean           modal;
  private Font              selectedFont;
  private boolean           okPressed;

  /** UID */
  private static final long serialVersionUID = -753829544574261203L;

  /**
   *
   * @param frame Frame
   * @param title String
   */
  public FontChooser(Frame frame, String title) {
    this(frame, title, true);
  }

  /**
   *
   * @param frame Frame
   * @param title String
   * @param modal boolean
   */
  public FontChooser(Frame frame, String title, boolean modal) {
    this.modal = modal;
    okPressed = false;
    window = frame;
    setTitle(title);
  }

  /**
   *
   * @param dialog Dialog
   * @param title String
   */
  public FontChooser(Dialog dialog, String title) {
    this(dialog, title, true);
  }

  /**
   *
   * @param dialog Dialog
   * @param title String
   * @param modal boolean
   */
  public FontChooser(Dialog dialog, String title, boolean modal) {
    this.modal = modal;
    okPressed = false;
    window = dialog;
    setTitle(title);
  }

  /**
   *
   * @param title String
   */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   *
   * @return String
   */
  public String getTitle() {return title;}

  /**
   *
   * @param modal boolean
   */
  public void setModal(boolean modal) {
    this.modal = modal;
  }

  /**
   *
   * @return boolean
   */
  public boolean isModal() {return modal;}

  /**
   *
   * @param selectedFont Font
   */
  public void setSelectedFont(Font selectedFont) {
    this.selectedFont = selectedFont;
  }

  /**
   *
   * @return Font
   */
  public Font getSelectedFont() {return selectedFont;}

  /**
   *
   */
  public void show() {showDialog();}

  /**
   *
   * @return boolean
   */
  public boolean showDialog() {
    FontChooserDialog dlg = new FontChooserDialog( window, 
                                                   title != null ? title : JNPadBundle.getString("FontChooserDialog.title"), //$NON-NLS-1$
                                                   modal, 
                                                   selectedFont);
    dlg.pack();
    dlg.setLocationRelativeTo(window);
    dlg.setVisible(true);
    if (dlg.isOKPressed()) {
      selectedFont = dlg.getSelectedFont();
      okPressed = true;
    }
    dlg.dispose();
    return okPressed;
  }

}
