/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text.syntax;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

import javax.swing.text.Element;
import javax.swing.text.PlainView;

import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.text.AbstractTextArea;

/**
 * The Class PlainView2.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class PlainView2 extends PlainView {
  boolean mini;
  
  /**
   * Instantiates a new plain view2.
   *
   * @param elem the elem
   * @param mini the mini
   */
  public PlainView2(Element elem, boolean mini) {
    super(elem);
    this.mini = mini;
  }

  /**
   * Paint.
   *
   * @param g the Graphics
   * @param a the Shape
   * @see javax.swing.text.PlainView#paint(java.awt.Graphics, java.awt.Shape)
   */
  @Override
  public void paint(Graphics g, Shape a) {
    GUIUtilities.setRenderingHints(g);
    Container c = getContainer();
    if (c instanceof AbstractTextArea) { // [changed v0.3]
      AbstractTextArea host = (AbstractTextArea) c;
      if (host.isViewRectVisible()) {
        Rectangle viewRect = host.getViewRect();
        if (viewRect != null) {
          g.setColor(Config.MINIMAP_VIEWRECT_COLOR.getValue());
          g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
          g.setColor(Config.MINIMAP_VIEWRECT_BORDER_COLOR.getValue());
          GUIUtilities.drawDottedRectangle(g, viewRect);
        }
      }
      if (host.isRightMarginLineVisible()) {
        updateMetrics();
        int fontWidth = metrics.charWidth('m');
        int margin = host.getRightMarginLineWidth() * fontWidth;
        g.setColor(host.getRightMarginLineColor());
        g.drawLine(margin + 1, 0, margin + 1, c.getHeight());
      }
    }
    super.paint(g, a);
  }

}
