/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.search;

import jnpad.util.Utilities;

/**
 * The Class Text.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class Text {
  private String        textOfLine;
  private SearchContext context;
  private String        path;
  private int           startPosition;
  private int           endPosition;

  /**
   * Instantiates a new text.
   *
   * @param textOfLine String
   * @param context SearchContext
   * @param path String
   * @param startPosition int
   * @param endPosition int
   */
  public Text(String textOfLine, SearchContext context, String path, int startPosition, int endPosition) {
    this.textOfLine = textOfLine;
    this.context = context;
    this.path = path;
    this.startPosition = startPosition;
    this.endPosition = endPosition;
  }

  /**
   * Equals.
   *
   * @param obj the object
   * @return true, if successful
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj) {
    return this == obj || obj != null && (obj instanceof Text) && Utilities.equals(textOfLine, ((Text) obj).getTextOfLine())
        && Utilities.equals(context, ((Text) obj).getContext()) && Utilities.equals(path, ((Text) obj).getPath())
        && startPosition == ((Text) obj).getStartPosition() && endPosition == ((Text) obj).getEndPosition();
  }

  /**
   * Hash code.
   *
   * @return the int
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return Utilities.hashCode(textOfLine,
                              context,
                              path,
                              startPosition,
                              endPosition);
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return textOfLine;
  }

  /**
   * Gets the text of line.
   *
   * @return the text of line
   */
  public String getTextOfLine() {
    return textOfLine;
  }

  /**
   * Gets the context.
   *
   * @return the context
   */
  public SearchContext getContext() {
    return context;
  }

  /**
   * Gets the path.
   *
   * @return the path
   */
  public String getPath() {
    return path;
  }

  /**
   * Gets the start position.
   *
   * @return the start position
   */
  public int getStartPosition() {
    return startPosition;
  }

  /**
   * Gets the end position.
   *
   * @return the end position
   */
  public int getEndPosition() {
    return endPosition;
  }

} //  fin de Text
