/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class ViewActionScopeProp.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class ViewActionScopeProp extends Prop<ViewActionScope> {
  /** UID */
  private static final long serialVersionUID = -9051765505429332129L;

  /**
   * Instantiates a new view action scope prop.
   *
   * @param name the name
   * @param def the def
   */
  public ViewActionScopeProp(String name, ViewActionScope def) {
    super(name, def);
  }

  /**
   * Gets the default string.
   * 
   * @return the default string
   * @see jnpad.config.Prop#getDefaultString()
   */
  @Override
  public String getDefaultString() {
    return format(defaultValue);
  }

  /**
   * Parses the.
   *
   * @param value the value
   * @return the view action scope
   * @throws NumberFormatException the number format exception
   */
  public static ViewActionScope parse(String value) throws NumberFormatException {
    switch(IntProp.parse(value)) {
      case 0 : return ViewActionScope.VIEWER;
      case 1 : return ViewActionScope.BUFFER_SET;
      case 2 : return ViewActionScope.BUFFER;
      case 3 : return ViewActionScope.EDIT_PANE;
      default: return null;
    }
  }

  /**
   * Format.
   *
   * @param value the value
   * @return the string
   */
  public static String format(ViewActionScope value) {
    return IntProp.format(value.ordinal());
  }

  /**
   * Gets the value.
   *
   * @return the value
   * @see jnpad.config.Prop#getValue()
   */
  @Override
  public ViewActionScope getValue() {
    return Config.getViewActionScopeProp(this);
  }

  /**
   * Do set value.
   *
   * @param value the value
   * @see jnpad.config.Prop#doSetValue(java.lang.Object)
   */
  @Override
  protected void doSetValue(ViewActionScope value) {
    Config.setViewActionScopeProp(this, value);
  }
  
}
