/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The listener interface for receiving propChange events.
 * The class that is interested in processing a propChange
 * event implements this interface, and the object created
 * with that class is registered with a component using the
 * component's <code>addPropChangeListener<code> method. When
 * the propChange event occurs, that object's appropriate
 * method is invoked.
 *
 * @param <V> the value type
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface PropChangeListener<V> extends java.util.EventListener {
  /**
   * Prop change.
   *
   * @param evt the evt
   */
  void propChange(PropChangeEvent<V> evt);

}
