/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_TOOLBARS_FORMAT;

import java.awt.event.ItemEvent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;

/**
 * The Class ToolbarsFormatAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class ToolbarsFormatAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = 5674846530946729327L;

  /**
   * Instantiates a new toolbars format action.
   *
   * @param jNPad the jNPad's frame
   */
  public ToolbarsFormatAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_TOOLBARS_FORMAT,
          Group.VIEW,
          null, null);
    
    if (Accelerators.isUsingCompositeShortcuts()) {
      setKeyBinding(Accelerators.getShortcutLabel(ACTION_NAME_TOOLBARS_FORMAT));
    }

    setSelected(Config.TOOLBARS_FORMAT_SELECTED.getValue());
    setStateAction(true);
  }

  /**
   * Handle state changed.
   *
   * @param e the item event
   * @see jnpad.action.JNPadAction#handleStateChanged(java.awt.event.ItemEvent)
   */
  @Override
  public void handleStateChanged(final ItemEvent e) {
    Config.TOOLBARS_VIEW_SELECTED.setValue(ItemEvent.SELECTED == e.getStateChange());
    jNPad.setToolBars();
  }
}

