/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.ResourceBundle;

import jnpad.JNPadBundle;
import jnpad.config.Config;

/**
 * The Class ActionBundle.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class ActionBundle {
  /** The Constant BUNDLE_NAME. */
  private static final String              BUNDLE_NAME = "jnpad.i18n.ActionBundle"; //$NON-NLS-1$

  /** The bundle. */
  private static Reference<ResourceBundle> ourBundle;

  /**
   * no instances.
   */
  private ActionBundle() {
    super();
  }

  /**
   * Gets the string.
   *
   * @param key the key
   * @param params the params
   * @return the string
   */
  public static String getString(final String key, final Object... params) {
    return JNPadBundle.getString(getBundle(), key, params);
  }

  /**
   * Gets the message.
   *
   * @param key the key
   * @param defaultValue the default value
   * @param params the params
   * @return the message
   */
  public static String getMessage(final String key, final String defaultValue, final Object... params) {
    return JNPadBundle.getMessage(getBundle(), key, defaultValue, params);
  }

  /**
   * Gets the bundle.
   *
   * @return the bundle
   */
  private static ResourceBundle getBundle() {
    ResourceBundle bundle = null;
    if (ourBundle != null) {
      bundle = ourBundle.get();
    }
    if (bundle == null) {
      Locale locale = Config.getLocale();
      bundle = (locale != null) ?
          ResourceBundle.getBundle(BUNDLE_NAME, locale) :
          ResourceBundle.getBundle(BUNDLE_NAME);
      ourBundle = new SoftReference<ResourceBundle>(bundle);
    }
    return bundle;
  }
}
