/*
 * Decompiled with CFR 0.152.
 */
package jnpad.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jnpad.util.Platform;

public final class Utilities {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = -1;
    public static final String SPACE_STRING = " ";
    public static final char SPACE = ' ';
    public static final String EMPTY_STRING = "";
    public static final String LF_STRING = "\n";
    public static final char LF = '\n';
    public static final String CR_STRING = "\r";
    public static final char CR = '\r';
    public static final String CRLF = "\r\n";
    public static final String TAB_STRING = "\t";
    public static final char TAB = '\t';
    public static final String COMMA_STRING = ",";
    public static final int INDEX_NOT_FOUND = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String DIR_SEPARATOR_STRING = File.separator;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STRING = Character.toString('.');
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR_MAC = "\r";
    public static final String LINE_SEPARATOR = Utilities.getLineSeparator();
    private static final File[] FILE_SYSTEM_ROOTS = Utilities.listRoots();

    private Utilities() {
    }

    public static Date now() {
        return new Date();
    }

    public static void exitFailure() {
        System.exit(-1);
    }

    public static void exitSuccess() {
        System.exit(0);
    }

    public static void gc() {
        System.runFinalization();
        Runtime.getRuntime().runFinalization();
        System.gc();
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void gc_() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Utilities.gc();
            }
        }, "Perform Garbage Collection");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    public static void restartApplication(Runnable runBeforeRestart) throws IOException {
        try {
            String java = String.valueOf(System.getProperty("java.home")) + "/bin/java";
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            StringBuilder vmArgsOneLine = new StringBuilder();
            for (String arg : vmArguments) {
                if (arg.contains("-agentlib")) continue;
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(SPACE_STRING);
            }
            final StringBuffer cmd = new StringBuffer("\"" + java + "\" " + vmArgsOneLine);
            String[] mainCommand = System.getProperty("sun.java.command").split(SPACE_STRING);
            if (mainCommand[0].endsWith(".jar")) {
                cmd.append("-jar " + new File(mainCommand[0]).getPath());
            } else {
                cmd.append("-cp \"" + System.getProperty("java.class.path") + "\" " + mainCommand[0]);
            }
            int i = 1;
            while (i < mainCommand.length) {
                cmd.append(SPACE_STRING);
                cmd.append(mainCommand[i]);
                ++i;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(cmd.toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            if (runBeforeRestart != null) {
                runBeforeRestart.run();
            }
            Utilities.exitSuccess();
        }
        catch (Exception ex) {
            throw new IOException("Error while trying to restart the application", ex);
        }
    }

    public static void restartApplication2(String jar) throws IOException {
        Runtime.getRuntime().exec("java -jar ".concat(jar));
        Utilities.exitSuccess();
    }

    public static void expandListSize(List<?> list, int newsize) {
        int i = list.size();
        while (i < newsize) {
            list.add(null);
            ++i;
        }
    }

    public static void restrictListSize(List<?> list, int newsize) {
        int i = list.size() - 1;
        while (i >= newsize) {
            list.remove(i);
            --i;
        }
    }

    public static void setListSize(List<?> list, int newsize) {
        if (newsize > list.size()) {
            Utilities.expandListSize(list, newsize);
        } else if (newsize < list.size()) {
            Utilities.restrictListSize(list, newsize);
        }
    }

    public static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmptyList(List<?> list) {
        return !Utilities.isEmptyList(list);
    }

    public static String removeNewLine(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '\n') {
            s = s.substring(0, s.length() - 1);
        }
        if (s.charAt(s.length() - 1) == '\r') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String spaces(int count) {
        if (count <= 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static int countLines(String s) {
        int count = 0;
        int i = s.length();
        while (i-- > 0) {
            if (s.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public static int countMatches(String s, String sub) {
        if (Utilities.isEmptyString(s) || Utilities.isEmptyString(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = s.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmptyString(String s) {
        return !Utilities.isEmptyString(s);
    }

    public static boolean isBlankString(String s) {
        int len;
        if (s == null || (len = s.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotBlankString(String s) {
        return !Utilities.isBlankString(s);
    }

    public static String defaultString(String s) {
        return s != null ? s : EMPTY_STRING;
    }

    public static String defaultString(String s, String defaultStr) {
        return s != null ? s : defaultStr;
    }

    public static String defaultIfEmpty(String s, String defaultStr) {
        return Utilities.isEmptyString(s) ? defaultStr : s;
    }

    private static boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = !Character.isUnicodeIdentifierPart(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = !Character.isUnicodeIdentifierPart(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    private static boolean isWholeWord(CharSequence searchIn, int offset, int len, String noWordSep) {
        boolean wsAfter;
        boolean wsBefore;
        char ch;
        if (noWordSep == null) {
            noWordSep = EMPTY_STRING;
        }
        try {
            ch = searchIn.charAt(offset - 1);
            wsBefore = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            ch = searchIn.charAt(offset + len);
            wsAfter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    public static int indexOf(String s, String searchStr) {
        if (s == null || searchStr == null) {
            return -1;
        }
        return s.indexOf(searchStr);
    }

    public static int indexOf(String s, String searchStr, int startPos) {
        if (s == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= s.length()) {
            return s.length();
        }
        return s.indexOf(searchStr, startPos);
    }

    public static int indexOf(String s, String searchStr, boolean ignoreCase, boolean wholeWord) {
        return Utilities.indexOf(s, searchStr, 0, ignoreCase, wholeWord);
    }

    public static int indexOf(String s, String searchStr, int startPos, boolean ignoreCase, boolean wholeWord) {
        String searchFor;
        if (s == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= s.length()) {
            return s.length();
        }
        String searchIn = ignoreCase ? s.toLowerCase() : s;
        String string = searchFor = ignoreCase ? searchStr.toLowerCase() : searchStr;
        if (wholeWord) {
            int len = searchFor.length();
            int temp = startPos;
            int tempChange = 1;
            while ((temp = searchIn.indexOf(searchFor, temp)) != -1) {
                if (Utilities.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return searchIn.indexOf(searchFor, startPos);
    }

    public static int indexOf(String s, String searchStr, boolean ignoreCase, boolean wholeWord, String noWordSep) {
        return Utilities.indexOf(s, searchStr, 0, ignoreCase, wholeWord, noWordSep);
    }

    public static int indexOf(String s, String searchStr, int startPos, boolean ignoreCase, boolean wholeWord, String noWordSep) {
        String searchFor;
        if (s == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= s.length()) {
            return s.length();
        }
        String searchIn = ignoreCase ? s.toLowerCase() : s;
        String string = searchFor = ignoreCase ? searchStr.toLowerCase() : searchStr;
        if (wholeWord) {
            int len = searchFor.length();
            int temp = startPos;
            int tempChange = 1;
            while ((temp = searchIn.indexOf(searchFor, temp)) != -1) {
                if (Utilities.isWholeWord(searchIn, temp, len, noWordSep)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return searchIn.indexOf(searchFor, startPos);
    }

    public static int lastIndexOf(String s, String searchStr) {
        if (s == null || searchStr == null) {
            return -1;
        }
        return s.lastIndexOf(searchStr);
    }

    public static int lastIndexOf(String s, String searchStr, int startPos) {
        if (s == null || searchStr == null) {
            return -1;
        }
        return s.lastIndexOf(searchStr, startPos);
    }

    public static int lastIndexOf(String s, String searchStr, boolean ignoreCase, boolean wholeWord) {
        return Utilities.lastIndexOf(s, searchStr, s.length(), ignoreCase, wholeWord);
    }

    public static int lastIndexOf(String s, String searchStr, int startPos, boolean ignoreCase, boolean wholeWord) {
        String searchFor;
        if (s == null || searchStr == null) {
            return -1;
        }
        String searchIn = ignoreCase ? s.toLowerCase() : s;
        String string = searchFor = ignoreCase ? searchStr.toLowerCase() : searchStr;
        if (wholeWord) {
            int len = searchFor.length();
            int temp = searchIn.length();
            int tempChange = -1;
            while ((temp = searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (Utilities.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return searchIn.lastIndexOf(searchFor, startPos);
    }

    public static int lastIndexOf(String s, String searchStr, boolean ignoreCase, boolean wholeWord, String noWordSep) {
        return Utilities.lastIndexOf(s, searchStr, s.length(), ignoreCase, wholeWord, noWordSep);
    }

    public static int lastIndexOf(String s, String searchStr, int startPos, boolean ignoreCase, boolean wholeWord, String noWordSep) {
        String searchFor;
        if (s == null || searchStr == null) {
            return -1;
        }
        String searchIn = ignoreCase ? s.toLowerCase() : s;
        String string = searchFor = ignoreCase ? searchStr.toLowerCase() : searchStr;
        if (wholeWord) {
            int len = searchFor.length();
            int temp = searchIn.length();
            int tempChange = -1;
            while ((temp = searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (Utilities.isWholeWord(searchIn, temp, len, noWordSep)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return searchIn.lastIndexOf(searchFor, startPos);
    }

    public static String getLineSeparator() {
        try {
            return System.getProperty("line.separator", "\n");
        }
        catch (Exception e) {
            return "\n";
        }
    }

    public static String convertToUnixLineEndings(String s) {
        return Utilities.convertLineEndings(s, "\n");
    }

    public static String convertToPlatformLineEndings(String s) {
        return Utilities.convertLineEndings(s, Utilities.getLineSeparator());
    }

    public static String convertLineEndings(String s, String separator) {
        String result;
        int i;
        if (s != null && (i = s.length()) > 0 && separator != null) {
            StringBuilder sb = new StringBuilder(i);
            int j = 0;
            int k = 0;
            while (k < i) {
                char c = s.charAt(k);
                if (c == '\r' || c == '\n') {
                    sb.append(s.substring(j, k));
                    sb.append(separator);
                    if (c == '\r' && k < i - 1 && s.charAt(k + 1) == '\n') {
                        ++k;
                    }
                    j = k + 1;
                }
                ++k;
            }
            if (j < i) {
                sb.append(s.substring(j));
            }
            result = sb.toString();
        } else {
            result = s;
        }
        return result;
    }

    public static boolean charsEqual(char a, char b, boolean ignoreCase) {
        return ignoreCase ? Utilities.charsEqualIgnoreCase(a, b) : a == b;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || Utilities.toUpperCase(a) == Utilities.toUpperCase(b) || Utilities.toLowerCase(a) == Utilities.toLowerCase(b);
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a >= 'a' && a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a >= 'A' && a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    public static String toTitleString(String s) {
        if (Utilities.isEmptyString(s)) {
            return s;
        }
        char[] array = s.toCharArray();
        int len = array.length;
        int idx = 0;
        while (idx < len && !Character.isLetter(array[idx])) {
            ++idx;
        }
        if (idx < len) {
            array[idx] = Character.toUpperCase(array[idx]);
        }
        while (idx < len) {
            if (array[idx] == '\n' || array[idx] == '.') {
                while (idx < len && !Character.isLetter(array[idx])) {
                    ++idx;
                }
                if (idx < len) {
                    array[idx] = Character.toUpperCase(array[idx]);
                }
            }
            ++idx;
        }
        return new String(array);
    }

    public static String capitalizeString(String str) {
        return Utilities.capitalizeString(str, null);
    }

    public static String capitalizeString(String s, char ... delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (Utilities.isEmptyString(s) || delimLen == 0) {
            return s;
        }
        char[] buffer = s.toCharArray();
        boolean capitalizeNext = true;
        int i = 0;
        while (i < buffer.length) {
            char ch = buffer[i];
            if (Utilities.isDelimiter(ch, delimiters)) {
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String capitalizeStringFully(String s) {
        return Utilities.capitalizeStringFully(s, null);
    }

    public static String capitalizeStringFully(String s, char ... delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (Utilities.isEmptyString(s) || delimLen == 0) {
            return s;
        }
        s = s.toLowerCase();
        return Utilities.capitalizeString(s, delimiters);
    }

    public static String uncapitalizeString(String s) {
        return Utilities.uncapitalizeString(s, null);
    }

    public static String uncapitalizeString(String s, char ... delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (Utilities.isEmptyString(s) || delimLen == 0) {
            return s;
        }
        char[] buffer = s.toCharArray();
        boolean uncapitalizeNext = true;
        int i = 0;
        while (i < buffer.length) {
            char ch = buffer[i];
            if (Utilities.isDelimiter(ch, delimiters)) {
                uncapitalizeNext = true;
            } else if (uncapitalizeNext) {
                buffer[i] = Character.toLowerCase(ch);
                uncapitalizeNext = false;
            }
            ++i;
        }
        return new String(buffer);
    }

    public static boolean isLowerCase(String str) {
        if (Utilities.isEmptyString(str)) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLowerCase(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLowerCase2(String str) {
        if (Utilities.isEmptyString(str)) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch) && !Character.isLowerCase(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase(String str) {
        if (Utilities.isEmptyString(str)) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isUpperCase(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase2(String str) {
        if (Utilities.isEmptyString(str)) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTitleCase(String str) {
        if (Utilities.isEmptyString(str)) {
            return false;
        }
        char[] array = str.toCharArray();
        int len = array.length;
        int idx = 0;
        while (idx < len && !Character.isLetter(array[idx])) {
            ++idx;
        }
        return idx < len ? Character.isUpperCase(array[idx]) : false;
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        char[] cArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            if (ch == delimiter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String fixSizeString(int size, boolean alignLeft, char filler, long value) {
        return Utilities.fixSizeString(size, alignLeft, filler, String.valueOf(value));
    }

    public static String fixSizeString(int size, boolean alignLeft, String s) {
        return Utilities.fixSizeString(size, alignLeft, ' ', s);
    }

    public static String fixSizeString(int size, boolean alignLeft, char filler, String s) {
        if (s.length() < size) {
            StringBuilder sb = new StringBuilder(size);
            if (alignLeft) {
                sb.append(s);
            }
            int i = 0;
            while (i < size - s.length()) {
                sb.append(filler);
                ++i;
            }
            if (!alignLeft) {
                sb.append(s);
            }
            return sb.toString();
        }
        return alignLeft ? s.substring(0, size) : s.substring(s.length() - size, s.length());
    }

    public static int compareVersionNumbers(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        int idx = 0;
        while (idx < part1.length && idx < part2.length) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        if (part1.length > idx) {
            return 1;
        }
        return -1;
    }

    public static final File[] file_system_roots() {
        return Utilities.copyOf(FILE_SYSTEM_ROOTS);
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static File getUserDirectory() {
        return new File(Utilities.getUserDirectoryPath());
    }

    public static File[] listRoots() {
        return File.listRoots();
    }

    public static boolean isFileSystemRoot(File file) {
        File[] fileArray = FILE_SYSTEM_ROOTS;
        int n = FILE_SYSTEM_ROOTS.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getPath().equals(file.getPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isURL(String s) {
        boolean result = false;
        File file = new File(s);
        URL url = null;
        if (!file.exists()) {
            try {
                url = new URL(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (url != null) {
                result = true;
            }
        }
        return result;
    }

    public static String getFileSeparator() {
        return File.separator;
    }

    public static char getFileSeparatorChar() {
        return File.separatorChar;
    }

    public static String getFileName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = Utilities.indexOfLastFileSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getFileBaseName(String filename) {
        return Utilities.removeFileExtension(Utilities.getFileName(filename));
    }

    public static String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = Utilities.indexOfFileExtension(filename);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return filename.substring(index + 1);
    }

    public static int indexOfLastFileSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfFileExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = Utilities.indexOfLastFileSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String removeFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = Utilities.indexOfFileExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static boolean isFileExtension(String filename, String extension) {
        if (filename == null) {
            return false;
        }
        if (Utilities.isEmptyString(extension)) {
            return Utilities.indexOfFileExtension(filename) == -1;
        }
        String fileExt = Utilities.getFileExtension(filename);
        return fileExt.equals(extension);
    }

    public static boolean isFileExtension(String filename, String[] extensions) {
        if (filename == null) {
            return false;
        }
        if (Utilities.isEmpty(extensions)) {
            return Utilities.indexOfFileExtension(filename) == -1;
        }
        String fileExt = Utilities.getFileExtension(filename);
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (fileExt.equals(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String fileSeparatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static String fileSeparatorsToWindows(String path) {
        if (path == null || path.indexOf(47) == -1) {
            return path;
        }
        return path.replace('/', '\\');
    }

    public static String fileSeparatorsToSystem(String path) {
        if (path == null) {
            return null;
        }
        if (Platform.isWindows) {
            return Utilities.fileSeparatorsToWindows(path);
        }
        return Utilities.fileSeparatorsToUnix(path);
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] arr) {
        return !Utilities.isEmpty(arr);
    }

    public static <T> String toString(T arg) {
        return Utilities.toString(arg, EMPTY_STRING);
    }

    public static <T> String toString(T arg, String nullStr) {
        return arg == null ? nullStr : arg.toString();
    }

    public static <T> boolean equals(T arg1, T arg2) {
        if (arg1 == arg2) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return arg1 == arg2;
        }
        if (arg1 instanceof Object[] && arg2 instanceof Object[]) {
            return Arrays.equals((Object[])arg1, (Object[])arg2);
        }
        if (arg1 instanceof CharSequence && arg2 instanceof CharSequence) {
            return Utilities.equals((CharSequence)arg1, (CharSequence)arg2, true);
        }
        return arg1.equals(arg2);
    }

    public static <T> boolean equals(T[] arr1, T[] arr2) {
        if (arr1 == null || arr2 == null) {
            return arr1 == arr2;
        }
        return Arrays.equals(arr1, arr2);
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        return Utilities.equals(s1, s2, true);
    }

    public static boolean equals(CharSequence s1, CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int to = 0;
        int po = 0;
        if (s1.length() != s2.length()) {
            return false;
        }
        int len = s1.length();
        while (len-- > 0) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(to++)) == (c2 = s2.charAt(po++)) || !caseSensitive && Utilities.charsEqualIgnoreCase(c1, c2)) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(Object o) {
        return o instanceof Object[] ? Utilities.hashCode((Object[])o) : (o == null ? 0 : o.hashCode());
    }

    public static int hashCode(Object obj1, Object obj2) {
        return Utilities.hashCode(obj1) ^ Utilities.hashCode(obj2);
    }

    public static int hashCode(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static int compare(byte arg1, byte arg2) {
        return arg1 < arg2 ? -1 : (arg1 == arg2 ? 0 : 1);
    }

    public static int compare(boolean arg1, boolean arg2) {
        return arg1 == arg2 ? 0 : (arg1 ? 1 : -1);
    }

    public static int compare(int arg1, int arg2) {
        return arg1 < arg2 ? -1 : (arg1 == arg2 ? 0 : 1);
    }

    public static int compare(long arg1, long arg2) {
        return arg1 < arg2 ? -1 : (arg1 == arg2 ? 0 : 1);
    }

    public static int compare(double arg1, double arg2) {
        return arg1 < arg2 ? -1 : (arg1 == arg2 ? 0 : 1);
    }

    public static int compare(byte[] arg1, byte[] arg2) {
        if (arg1 == arg2) {
            return 0;
        }
        if (arg1 == null) {
            return 1;
        }
        if (arg2 == null) {
            return -1;
        }
        if (arg1.length > arg2.length) {
            return 1;
        }
        if (arg1.length < arg2.length) {
            return -1;
        }
        int i = 0;
        while (i < arg1.length) {
            if (arg1[i] > arg2[i]) {
                return 1;
            }
            if (arg1[i] < arg2[i]) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(T arg1, T arg2) {
        if (arg1 == null) {
            return arg2 == null ? 0 : -1;
        }
        if (arg2 == null) {
            return 1;
        }
        return arg1.compareTo(arg2);
    }

    public static <T> int compare(T arg1, T arg2, Comparator<T> notNullComparator) {
        if (arg1 == null) {
            return arg2 == null ? 0 : -1;
        }
        if (arg2 == null) {
            return 1;
        }
        return notNullComparator.compare(arg1, arg2);
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T[] copyOf(T[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOf(array, array.length);
    }

    public static char[] copyOf(char[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOf(array, array.length);
    }
}

