/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import jnpad.ui.toolbar.ToolBarToggleButton;
import jnpad.util.Utilities;

class ToolBoxToggleButton
extends ToolBarToggleButton {
    JToggleButton _reference;
    Action _action;
    private PropertyChangeListener _actionPropertyChangeListener;
    private static final long serialVersionUID = -7301613799735578041L;

    ToolBoxToggleButton(JToggleButton reference) {
        String desc;
        String tooltip;
        String text;
        this._reference = reference;
        Icon icon = reference.getIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        if ((text = reference.getText()) != null) {
            this.setText(text);
        }
        if (Utilities.isEmptyString(tooltip = reference.getToolTipText())) {
            tooltip = reference.getText();
        }
        this.setToolTipText(tooltip);
        if (reference instanceof ToolBarToggleButton && (desc = ((ToolBarToggleButton)reference).getDescription()) != null) {
            this.setDescription(desc);
        }
        this.setEnabled(reference.isEnabled());
        this.setSelected(reference.isSelected());
        this.setMargin(reference.getMargin());
        this.addActionListener(new ActionListenerImpl());
        this.addItemListener(new ItemListenerImpl());
        if (this._action != null && this._actionPropertyChangeListener != null) {
            this._action.removePropertyChangeListener(this._actionPropertyChangeListener);
            this._actionPropertyChangeListener = null;
        }
        this._action = reference.getAction();
        if (this._action != null) {
            this._actionPropertyChangeListener = new PropertyChangeListenerImpl();
            this._action.addPropertyChangeListener(this._actionPropertyChangeListener);
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBoxToggleButton.this._reference.setSelected(ToolBoxToggleButton.this.isSelected());
            ActionListener[] actionListenerArray = ToolBoxToggleButton.this._reference.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                listener.actionPerformed(new ActionEvent(ToolBoxToggleButton.this._reference, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                ++n2;
            }
        }
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemListener[] itemListenerArray = ToolBoxToggleButton.this._reference.getItemListeners();
            int n = itemListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemListener listener = itemListenerArray[n2];
                listener.itemStateChanged(new ItemEvent(ToolBoxToggleButton.this._reference, e.getID(), e.getItem(), e.getStateChange()));
                ++n2;
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -276468994510092616L;

        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("enabled".equals(e.getPropertyName())) {
                ToolBoxToggleButton.this.setEnabled((Boolean)e.getNewValue());
            } else if ("selected".equals(e.getPropertyName())) {
                ToolBoxToggleButton.this.setSelected((Boolean)e.getNewValue());
            }
        }
    }
}

