/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jnpad.ui.JNPadLabel;
import jnpad.ui.layout.VerticalFlowLayout;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.table.HeaderTableCellRenderer;
import jnpad.ui.table.JNPadTable;
import jnpad.util.Utilities;

public class MultiLineHeaderTableCellRenderer
extends JPanel
implements HeaderTableCellRenderer {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    private JPanel panel = new JPanel();
    private JLabel label = new JNPadLabel();
    private static final Logger LOGGER = Logger.getLogger(MultiLineHeaderTableCellRenderer.class.getName());
    private static final long serialVersionUID = -6433259089696708378L;

    public MultiLineHeaderTableCellRenderer(int align) {
        super(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.add((Component)this.label, "East");
        this.panel.setLayout(new VerticalFlowLayout(align, 0, 0));
        this.panel.setOpaque(true);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        this.panel.removeAll();
        int sortedColumnIndex = -1;
        boolean isSortedColumnAscending = true;
        if (table instanceof JNPadTable) {
            sortedColumnIndex = ((JNPadTable)table).getSortedColumnIndex();
            isSortedColumnAscending = ((JNPadTable)table).isSortedColumnAscending();
        }
        Color foreground = LAFUtils.getTableHeaderForeground();
        Color background = LAFUtils.getTableHeaderBackground();
        Font font = LAFUtils.getTableHeaderFont();
        if (table != null && (header = table.getTableHeader()) != null) {
            foreground = header.getForeground();
            this.label.setForeground(foreground);
            background = header.getBackground();
            this.label.setBackground(background);
            font = header.getFont();
            this.label.setFont(font);
            this.panel.setForeground(foreground);
            this.panel.setBackground(background);
            this.panel.setFont(font);
        }
        this.label.setIcon(column == sortedColumnIndex ? (isSortedColumnAscending ? DECENDING : ASCENDING) : NONSORTED);
        String str = Utilities.toString(value);
        BufferedReader br = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                JNPadLabel l = new JNPadLabel();
                l.setText(line);
                l.setHorizontalAlignment(0);
                l.setOpaque(false);
                l.setForeground(foreground);
                l.setFont(font);
                this.panel.add(l);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.panel.validate();
        this.setBorder(LAFUtils.getTableHeaderCellBorder());
        return this;
    }
}

