/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.table.HeaderTableCellRenderer;
import jnpad.ui.table.JNPadTable;
import jnpad.util.Utilities;

public class LineHeaderTableCellRenderer
extends JLabel
implements HeaderTableCellRenderer {
    private static final long serialVersionUID = -7202340586410817206L;

    public LineHeaderTableCellRenderer(int align) {
        this.setOpaque(true);
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(align);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        int sortedColumnIndex = -1;
        boolean isSortedColumnAscending = true;
        if (table instanceof JNPadTable) {
            sortedColumnIndex = ((JNPadTable)table).getSortedColumnIndex();
            isSortedColumnAscending = ((JNPadTable)table).isSortedColumnAscending();
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setIcon(column == sortedColumnIndex ? (isSortedColumnAscending ? DECENDING : ASCENDING) : NONSORTED);
        this.setText(Utilities.toString(value));
        this.setBorder(LAFUtils.getTableHeaderCellBorder());
        return this;
    }
}

