/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.DefaultMetalTheme;
import jnpad.GUIUtilities;
import jnpad.ui.Gray;
import jnpad.ui.plaf.JNPadButtonUI;
import jnpad.ui.plaf.JNPadLabelUI;
import jnpad.ui.plaf.JNPadMenuUI;
import jnpad.ui.plaf.JNPadScrollBarUI;
import jnpad.ui.plaf.JNPadToggleButtonUI;
import jnpad.ui.plaf.JNPadToolBarUI;
import jnpad.ui.plaf.JNPadToolbarSeparatorUI;
import jnpad.util.Platform;

public final class JNPadLightMetalTheme
extends DefaultMetalTheme {
    private static final ColorUIResource PRIMARY1;
    private static final ColorUIResource PRIMARY2;
    private static final ColorUIResource PRIMARY3;
    private static final ColorUIResource SECONDARY2;
    static final ColorUIResource BLACK;
    static final ColorUIResource DARK_GRAY;
    static final ColorUIResource GRAY;
    static final ColorUIResource LIGHT_GRAY_0;
    static final ColorUIResource LIGHT_GRAY_1;
    static final ColorUIResource LIGHT_GRAY_2;
    static final ColorUIResource LIGHT_GRAY_3;
    static final ColorUIResource WHITE;
    static final ColorUIResource DARK_BLUE;
    private static final FontUIResource PLAIN_FONT;
    private static final FontUIResource BOLD_FONT;
    private static final Logger LOGGER;

    static {
        Font font;
        PRIMARY1 = new ColorUIResource(10, 36, 106);
        PRIMARY2 = new ColorUIResource(91, 135, 206);
        PRIMARY3 = new ColorUIResource(166, 202, 240);
        SECONDARY2 = new ColorUIResource(189, 182, 172);
        BLACK = new ColorUIResource(Gray._0);
        DARK_GRAY = new ColorUIResource(Gray._64);
        GRAY = new ColorUIResource(Gray._128);
        LIGHT_GRAY_0 = new ColorUIResource(Gray._160);
        LIGHT_GRAY_1 = new ColorUIResource(Gray._192);
        LIGHT_GRAY_2 = new ColorUIResource(Gray._229);
        LIGHT_GRAY_3 = new ColorUIResource(Gray._244);
        WHITE = new ColorUIResource(Gray._255);
        DARK_BLUE = new ColorUIResource(82, 108, 164);
        if (Platform.isWindows && (font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            PLAIN_FONT = new FontUIResource(font.getName(), 0, font.getSize());
            BOLD_FONT = new FontUIResource(font.getName(), 1, font.getSize());
        } else {
            PLAIN_FONT = new FontUIResource("Dialog", 0, 12);
            BOLD_FONT = new FontUIResource("Dialog", 1, 12);
        }
        LOGGER = Logger.getLogger(JNPadLightMetalTheme.class.getName());
    }

    @Override
    public String getName() {
        return "jNPad (Light)";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return PRIMARY1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return PRIMARY2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return PRIMARY3;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return SECONDARY2;
    }

    @Override
    public ColorUIResource getControl() {
        return LIGHT_GRAY_2;
    }

    @Override
    public ColorUIResource getSeparatorBackground() {
        return WHITE;
    }

    @Override
    public ColorUIResource getSeparatorForeground() {
        return GRAY;
    }

    @Override
    public ColorUIResource getMenuBackground() {
        return LIGHT_GRAY_2;
    }

    @Override
    public ColorUIResource getMenuSelectedBackground() {
        return DARK_BLUE;
    }

    @Override
    public ColorUIResource getMenuSelectedForeground() {
        return WHITE;
    }

    @Override
    public ColorUIResource getAcceleratorSelectedForeground() {
        return WHITE;
    }

    @Override
    public FontUIResource getControlTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return PLAIN_FONT;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return BOLD_FONT;
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        try {
            Object[] defaults = new Object[]{"jnpad.dark.theme", Boolean.FALSE, "FileChooser.upFolderIcon", GUIUtilities.getIcon("plaf/upFolder.png"), "FileChooser.newFolderIcon", GUIUtilities.getIcon("plaf/newFolder.png"), "FileChooser.homeFolderIcon", GUIUtilities.getIcon("plaf/homeFolder.png"), "FileChooser.listViewIcon", GUIUtilities.getIcon("plaf/listView.png"), "FileChooser.detailsViewIcon", GUIUtilities.getIcon("plaf/detailsView.png"), "OptionPane.errorIcon", GUIUtilities.getIcon("plaf/errorDialog.png"), "OptionPane.informationIcon", GUIUtilities.getIcon("plaf/informationDialog.png"), "OptionPane.warningIcon", GUIUtilities.getIcon("plaf/warningDialog.png"), "OptionPane.questionIcon", GUIUtilities.getIcon("plaf/questionDialog.png"), "LabelUI", JNPadLabelUI.class.getName(), "ButtonUI", JNPadButtonUI.class.getName(), "ToggleButtonUI", JNPadToggleButtonUI.class.getName(), "ToolBarUI", JNPadToolBarUI.class.getName(), "ToolBarSeparatorUI", JNPadToolbarSeparatorUI.class.getName(), "SplitPaneUI", BasicSplitPaneUI.class.getName(), "ScrollBarUI", JNPadScrollBarUI.class.getName(), "ScrollBar.track", this.getControlShadow(), "ScrollBar.trackHighlight", this.getControl(), "ScrollBar.thumb", LIGHT_GRAY_1, "ScrollBar.thumbHighlight", LIGHT_GRAY_2, "ScrollBar.thumbDarkShadow", BLACK, "ScrollBar.thumbShadow", GRAY, "TabbedPane.selected", LIGHT_GRAY_3, "MenuUI", JNPadMenuUI.class.getName(), "PopupMenu.background", WHITE, "MenuItem.background", WHITE, "RadioButtonMenuItem.background", WHITE, "CheckBoxMenuItem.background", WHITE, "TitledBorder.titleColor", PRIMARY1, "ToolTip.background", new ColorUIResource(255, 255, 231)};
            table.putDefaults(defaults);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }
}

