/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import jnpad.GUIUtilities;
import jnpad.action.JNPadAction;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Platform;

public class JNPadMenuItem
extends JMenuItem {
    private String _description;
    private boolean _descriptionSet;
    private StatusDisplayable _displayable;
    private String _keyBinding;
    static Font acceleratorFont;
    static Color acceleratorForeground;
    static Color acceleratorSelectionForeground;
    static Color acceleratorDisabledForeground;
    private static final long serialVersionUID = -65101014095861044L;

    static {
        String shortcutFont = Platform.isMac ? "Lucida Grande" : "Monospaced";
        acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        if (acceleratorFont == null) {
            acceleratorFont = new Font(shortcutFont, 0, 12);
        }
        if ((acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground")) == null) {
            acceleratorForeground = Color.BLACK;
        }
        if ((acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground")) == null) {
            acceleratorSelectionForeground = Color.BLACK;
        }
        if ((acceleratorDisabledForeground = UIManager.getColor("MenuItem.disabledForeground")) == null) {
            acceleratorDisabledForeground = Color.GRAY;
        }
    }

    public JNPadMenuItem() {
    }

    public JNPadMenuItem(String text) {
        super(text);
    }

    public JNPadMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
    }

    public JNPadMenuItem(Icon icon) {
        super(icon);
    }

    public JNPadMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public JNPadMenuItem(Action a) {
        super(a);
        if (a instanceof JNPadAction) {
            this.setText(((JNPadAction)a).getLabel());
            this.setDescription(((JNPadAction)a).getDescription());
            this.setKeyBinding(((JNPadAction)a).getKeyBinding());
        }
    }

    public void setKeyBinding(String keyBinding) {
        this._keyBinding = keyBinding;
    }

    public String getKeyBinding() {
        return this._keyBinding;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this._keyBinding != null) {
            d.width += this.getFontMetrics(acceleratorFont).stringWidth(this._keyBinding) + 30;
        }
        return d;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setStatusDisplayable(StatusDisplayable displayable) {
        this._displayable = displayable;
    }

    public StatusDisplayable getStatusDisplayable() {
        return this._displayable;
    }

    private StatusDisplayable getStatusDisplayable(MouseEvent e) {
        if (this._displayable == null) {
            this._displayable = GUIUtilities.getJNPadFrame(e);
        }
        return this._displayable;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._description != null) {
            switch (e.getID()) {
                case 504: {
                    this.getStatusDisplayable(e).setStatus(this._description);
                    this._descriptionSet = true;
                    break;
                }
                case 502: 
                case 505: {
                    if (!this._descriptionSet) break;
                    this.getStatusDisplayable(e).clearStatus();
                    this._descriptionSet = false;
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GUIUtilities.setRenderingHints(g);
        super.paintComponent(g);
        if (this._keyBinding != null) {
            g.setFont(acceleratorFont);
            g.setColor(this.isEnabled() ? (this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground) : acceleratorDisabledForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this._keyBinding, this.getWidth() - (fm.stringWidth(this._keyBinding) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (Platform.isMac ? 0 : 1)));
        }
    }
}

