/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import jnpad.text.syntax.PlainView2;
import jnpad.text.syntax.SyntaxScheme;

public abstract class SyntaxView
extends PlainView2 {
    SyntaxView(Element elem, boolean mini) {
        super(elem, mini);
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        if (start == end) {
            return x;
        }
        int length = (end < this.getDocument().getLength() ? end : this.getDocument().getLength()) - start;
        return this.doDrawUnselectedText(g, x, y, start, length);
    }

    @Override
    protected int drawSelectedText(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        if (start == end) {
            return x;
        }
        int length = (end < this.getDocument().getLength() ? end : this.getDocument().getLength()) - start;
        return this.doDrawSelectedText(g, x, y, start, length);
    }

    abstract int doDrawUnselectedText(Graphics var1, int var2, int var3, int var4, int var5) throws BadLocationException;

    abstract int doDrawSelectedText(Graphics var1, int var2, int var3, int var4, int var5) throws BadLocationException;

    int drawUnselectedText_(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        return super.drawUnselectedText(g, x, y, start, end);
    }

    int drawSelectedText_(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        return super.drawSelectedText(g, x, y, start, end);
    }

    abstract SyntaxScheme getScheme();

    boolean isOperator(char c) {
        char[] cArray = this.getScheme().getOperators();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char bracket = cArray[n2];
            if (c == bracket) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isBracket(char c) {
        char[] cArray = this.getScheme().getBrackets();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char bracket = cArray[n2];
            if (c == bracket) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isStringDelimiter(char c) {
        char[] cArray = this.getScheme().getStringDelimiters();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char delim = cArray[n2];
            if (c == delim) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isCharDelimiter(char c) {
        char[] cArray = this.getScheme().getCharDelimeters();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char delim = cArray[n2];
            if (c == delim) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isSingleLineCommentStart(Segment s, int index) {
        return false;
    }

    boolean isMultiLineCommentStart(Segment s, int index) {
        return false;
    }

    boolean isMultiLineCommentEnd(Segment s, int index) {
        return false;
    }

    String scanIdentifier(Segment s, int index) {
        String string = new String(s.array, s.offset, s.count);
        if (!Character.isJavaIdentifierStart(string.charAt(index))) {
            return "";
        }
        int identifierLength = 1;
        while (identifierLength < string.length() - index) {
            if (!Character.isJavaIdentifierPart(string.charAt(index + identifierLength))) break;
            ++identifierLength;
        }
        return string.substring(index, index + identifierLength);
    }

    int scanMultiLineComment(Segment s, int index) {
        return 0;
    }

    int scanSingleLineComment(Segment s, int index) {
        int commentLength = 0;
        while (commentLength < s.length() - index) {
            char commentChar = s.charAt(index + commentLength);
            if (commentChar == '\n') break;
            ++commentLength;
        }
        return commentLength;
    }

    String scanNumericLiteral(Segment s, int index) {
        String string = new String(s.array, s.offset, s.count);
        if (this.getScheme().hasCLikeSyntax()) {
            char[] buf22 = string.toCharArray();
            int bp = index;
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            char ch = buf22[bp];
            switch (ch) {
                case '0': {
                    ch = buf22[++bp];
                    if (ch != 'x' && ch != 'X') break;
                    flag = true;
                    ch = buf22[++bp];
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ch = buf22[++bp];
                    break;
                }
                default: {
                    return "";
                }
            }
            try {
                block15: while (true) {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            ch = buf22[++bp];
                            continue block15;
                        }
                        case 'E': 
                        case 'e': {
                            if (flag) {
                                ch = buf22[++bp];
                                continue block15;
                            }
                            if (flag2) {
                                return string.substring(index, bp);
                            }
                            if ((ch = buf22[++bp]) != '+' && ch != '-') continue block15;
                            ch = buf22[++bp];
                            continue block15;
                        }
                        case 'D': 
                        case 'F': 
                        case 'd': 
                        case 'f': {
                            ch = buf22[++bp];
                            if (flag) continue block15;
                            return string.substring(index, bp);
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'a': 
                        case 'b': 
                        case 'c': {
                            if (!flag) {
                                return string.substring(index, bp);
                            }
                            ch = buf22[++bp];
                            continue block15;
                        }
                        case '.': {
                            if (flag || flag1 || flag2) {
                                return string.substring(index, bp);
                            }
                            flag1 = true;
                            ch = buf22[++bp];
                            continue block15;
                        }
                        case 'L': 
                        case 'l': {
                            ch = buf22[++bp];
                            return string.substring(index, bp);
                        }
                    }
                    if (!Character.isDigit(ch)) break;
                    ch = buf22[++bp];
                }
                return string.substring(index, bp);
            }
            catch (Exception buf22) {
                // empty catch block
            }
        }
        int identifierLength = 0;
        while (identifierLength < string.length() - index) {
            if (!Character.isDigit(string.charAt(index + identifierLength))) break;
            ++identifierLength;
        }
        return string.substring(index, index + identifierLength);
    }

    int scanStringLiteral(Segment s, int index) {
        boolean backslash = false;
        int stringLength = 1;
        while (stringLength < s.length() - index) {
            char stringChar = s.charAt(index + stringLength);
            if (stringChar == '\\') {
                backslash = true;
            } else {
                if (stringChar == '\n') break;
                if (this.isStringDelimiter(stringChar) && !backslash) {
                    ++stringLength;
                    break;
                }
                if (backslash) {
                    backslash = false;
                }
            }
            ++stringLength;
        }
        return stringLength;
    }

    int scanCharLiteral(Segment s, int index) {
        boolean backslash = false;
        int charLength = 1;
        while (charLength < s.length() - index) {
            char charChar = s.charAt(index + charLength);
            if (charChar == '\\') {
                backslash = true;
            } else {
                if (charChar == '\n') break;
                if (this.isCharDelimiter(charChar) && !backslash) {
                    ++charLength;
                    break;
                }
                if (backslash) {
                    backslash = false;
                }
            }
            ++charLength;
        }
        return charLength;
    }
}

