/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import jnpad.config.Config;
import jnpad.text.syntax.PlainScheme;
import jnpad.util.Utilities;

public abstract class SyntaxScheme
extends PlainScheme {
    static Color commentColor;
    static Color stringColor;
    static Color numberColor;
    static Color keywordColor;
    static Color operatorColor;
    static Color bracketColor;
    Font commentFont;
    Font stringFont;
    Font keywordFont;
    Font operatorFont;
    Font bracketFont;
    private static final char[] BRACKETS;
    private static final char[] OPERATORS;
    private static final char[] DELIM_CHAR;
    private static final char[] DELIM_STRING;
    private static final long serialVersionUID = 5558171778920408921L;

    static {
        BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
        OPERATORS = new char[]{'='};
        DELIM_CHAR = new char[]{'\''};
        DELIM_STRING = new char[]{'\"'};
    }

    public SyntaxScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        commentColor = Config.SYNTAX_COMMENT_COLOR.getValue();
        stringColor = Config.SYNTAX_STRING_COLOR.getValue();
        numberColor = Config.SYNTAX_NUMBER_COLOR.getValue();
        keywordColor = Config.SYNTAX_KEYWORD_COLOR.getValue();
        operatorColor = Config.SYNTAX_OPERATOR_COLOR.getValue();
        bracketColor = Config.SYNTAX_BRACKET_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.commentFont = this.textFont.deriveFont(Config.SYNTAX_COMMENT_STYLE.getValue());
        this.stringFont = this.textFont.deriveFont(Config.SYNTAX_STRING_STYLE.getValue());
        this.keywordFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD_STYLE.getValue());
        this.operatorFont = this.textFont.deriveFont(Config.SYNTAX_OPERATOR_STYLE.getValue());
        this.bracketFont = this.textFont.deriveFont(Config.SYNTAX_BRACKET_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    static int getFontStyle(boolean isBold, boolean isItalic) {
        int i = 0;
        if (isBold) {
            ++i;
        }
        if (isItalic) {
            i += 2;
        }
        return i;
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    public Color getCommentColor() {
        return commentColor;
    }

    public Font getCommentFont() {
        return this.commentFont;
    }

    public Color getKeywordColor() {
        return keywordColor;
    }

    public Font getKeywordFont() {
        return this.keywordFont;
    }

    public Color getNumberColor() {
        return numberColor;
    }

    public Color getOperatorColor() {
        return operatorColor;
    }

    public Font getOperatorFont() {
        return this.operatorFont;
    }

    public char[] getOperators() {
        return Utilities.copyOf(OPERATORS);
    }

    public Color getStringColor() {
        return stringColor;
    }

    public Font getStringFont() {
        return this.stringFont;
    }

    public Color getBracketColor() {
        return bracketColor;
    }

    public Font getBracketFont() {
        return this.bracketFont;
    }

    public char[] getBrackets() {
        return Utilities.copyOf(BRACKETS);
    }

    public char[] getCharDelimeters() {
        return Utilities.copyOf(DELIM_CHAR);
    }

    public char[] getStringDelimiters() {
        return Utilities.copyOf(DELIM_STRING);
    }
}

